/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpec;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecFluent;
import io.fabric8.openshift.api.model.clusterautoscaling.v1.ClusterAutoscalerSpecFluentImpl;
import java.util.Objects;

public class ClusterAutoscalerSpecBuilder
extends ClusterAutoscalerSpecFluentImpl<ClusterAutoscalerSpecBuilder>
implements VisitableBuilder<ClusterAutoscalerSpec, ClusterAutoscalerSpecBuilder> {
    ClusterAutoscalerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterAutoscalerSpecBuilder() {
        this(false);
    }

    public ClusterAutoscalerSpecBuilder(Boolean validationEnabled) {
        this(new ClusterAutoscalerSpec(), validationEnabled);
    }

    public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterAutoscalerSpec(), validationEnabled);
    }

    public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpecFluent<?> fluent, ClusterAutoscalerSpec instance) {
        this(fluent, instance, false);
    }

    public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpecFluent<?> fluent, ClusterAutoscalerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups());
        fluent.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization());
        fluent.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime());
        fluent.withMaxPodGracePeriod(instance.getMaxPodGracePeriod());
        fluent.withPodPriorityThreshold(instance.getPodPriorityThreshold());
        fluent.withResourceLimits(instance.getResourceLimits());
        fluent.withScaleDown(instance.getScaleDown());
        fluent.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpec instance) {
        this(instance, (Boolean)false);
    }

    public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups());
        this.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization());
        this.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime());
        this.withMaxPodGracePeriod(instance.getMaxPodGracePeriod());
        this.withPodPriorityThreshold(instance.getPodPriorityThreshold());
        this.withResourceLimits(instance.getResourceLimits());
        this.withScaleDown(instance.getScaleDown());
        this.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterAutoscalerSpec build() {
        ClusterAutoscalerSpec buildable = new ClusterAutoscalerSpec(this.fluent.getBalanceSimilarNodeGroups(), this.fluent.getIgnoreDaemonsetsUtilization(), this.fluent.getMaxNodeProvisionTime(), this.fluent.getMaxPodGracePeriod(), this.fluent.getPodPriorityThreshold(), this.fluent.getResourceLimits(), this.fluent.getScaleDown(), this.fluent.getSkipNodesWithLocalStorage());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterAutoscalerSpecBuilder that = (ClusterAutoscalerSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

