package io.fabric8.openshift.api.model.clusterautoscaling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineAutoscalerSpecBuilder extends MachineAutoscalerSpecFluentImpl<MachineAutoscalerSpecBuilder> implements VisitableBuilder<MachineAutoscalerSpec,MachineAutoscalerSpecBuilder>{
  public MachineAutoscalerSpecBuilder() {
    this(false);
  }
  public MachineAutoscalerSpecBuilder(Boolean validationEnabled) {
    this(new MachineAutoscalerSpec(), validationEnabled);
  }
  public MachineAutoscalerSpecBuilder(MachineAutoscalerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineAutoscalerSpecBuilder(MachineAutoscalerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineAutoscalerSpec(), validationEnabled);
  }
  public MachineAutoscalerSpecBuilder(MachineAutoscalerSpecFluent<?> fluent,MachineAutoscalerSpec instance) {
    this(fluent, instance, false);
  }
  public MachineAutoscalerSpecBuilder(MachineAutoscalerSpecFluent<?> fluent,MachineAutoscalerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMaxReplicas(instance.getMaxReplicas()); 
    fluent.withMinReplicas(instance.getMinReplicas()); 
    fluent.withScaleTargetRef(instance.getScaleTargetRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachineAutoscalerSpecBuilder(MachineAutoscalerSpec instance) {
    this(instance,false);
  }
  public MachineAutoscalerSpecBuilder(MachineAutoscalerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMaxReplicas(instance.getMaxReplicas()); 
    this.withMinReplicas(instance.getMinReplicas()); 
    this.withScaleTargetRef(instance.getScaleTargetRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachineAutoscalerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MachineAutoscalerSpec build() {
    MachineAutoscalerSpec buildable = new MachineAutoscalerSpec(fluent.getMaxReplicas(),fluent.getMinReplicas(),fluent.getScaleTargetRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}