package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceLimitsFluentImpl<A extends ResourceLimitsFluent<A>> extends BaseFluent<A> implements ResourceLimitsFluent<A>{
  public ResourceLimitsFluentImpl() {
  }
  public ResourceLimitsFluentImpl(ResourceLimits instance) {
    if (instance != null) {
      this.withCores(instance.getCores());
      this.withGpus(instance.getGpus());
      this.withMaxNodesTotal(instance.getMaxNodesTotal());
      this.withMemory(instance.getMemory());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ResourceRangeBuilder cores;
  private ArrayList<GPULimitBuilder> gpus = new ArrayList<GPULimitBuilder>();
  private Integer maxNodesTotal;
  private ResourceRangeBuilder memory;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCores instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRange getCores() {
    return this.cores!=null ?this.cores.build():null;
  }
  public ResourceRange buildCores() {
    return this.cores!=null ?this.cores.build():null;
  }
  public A withCores(ResourceRange cores) {
    _visitables.get("cores").remove(this.cores);
    if (cores!=null){ this.cores= new ResourceRangeBuilder(cores); _visitables.get("cores").add(this.cores);} else { this.cores = null; _visitables.get("cores").remove(this.cores); } return (A) this;
  }
  public Boolean hasCores() {
    return this.cores != null;
  }
  public A withNewCores(Integer max,Integer min) {
    return (A)withCores(new ResourceRange(max, min));
  }
  public ResourceLimitsFluentImpl.CoresNested<A> withNewCores() {
    return new ResourceLimitsFluentImpl.CoresNestedImpl();
  }
  public ResourceLimitsFluentImpl.CoresNested<A> withNewCoresLike(ResourceRange item) {
    return new ResourceLimitsFluentImpl.CoresNestedImpl(item);
  }
  public ResourceLimitsFluentImpl.CoresNested<A> editCores() {
    return withNewCoresLike(getCores());
  }
  public ResourceLimitsFluentImpl.CoresNested<A> editOrNewCores() {
    return withNewCoresLike(getCores() != null ? getCores(): new ResourceRangeBuilder().build());
  }
  public ResourceLimitsFluentImpl.CoresNested<A> editOrNewCoresLike(ResourceRange item) {
    return withNewCoresLike(getCores() != null ? getCores(): item);
  }
  public A addToGpus(int index,GPULimit item) {
    if (this.gpus == null) {this.gpus = new ArrayList<GPULimitBuilder>();}
    GPULimitBuilder builder = new GPULimitBuilder(item);
    if (index < 0 || index >= gpus.size()) { _visitables.get("gpus").add(builder); gpus.add(builder); } else { _visitables.get("gpus").add(index, builder); gpus.add(index, builder);}
    return (A)this;
  }
  public A setToGpus(int index,GPULimit item) {
    if (this.gpus == null) {this.gpus = new ArrayList<GPULimitBuilder>();}
    GPULimitBuilder builder = new GPULimitBuilder(item);
    if (index < 0 || index >= gpus.size()) { _visitables.get("gpus").add(builder); gpus.add(builder); } else { _visitables.get("gpus").set(index, builder); gpus.set(index, builder);}
    return (A)this;
  }
  public A addToGpus(io.fabric8.openshift.api.model.clusterautoscaling.v1.GPULimit... items) {
    if (this.gpus == null) {this.gpus = new ArrayList<GPULimitBuilder>();}
    for (GPULimit item : items) {GPULimitBuilder builder = new GPULimitBuilder(item);_visitables.get("gpus").add(builder);this.gpus.add(builder);} return (A)this;
  }
  public A addAllToGpus(Collection<GPULimit> items) {
    if (this.gpus == null) {this.gpus = new ArrayList<GPULimitBuilder>();}
    for (GPULimit item : items) {GPULimitBuilder builder = new GPULimitBuilder(item);_visitables.get("gpus").add(builder);this.gpus.add(builder);} return (A)this;
  }
  public A removeFromGpus(io.fabric8.openshift.api.model.clusterautoscaling.v1.GPULimit... items) {
    for (GPULimit item : items) {GPULimitBuilder builder = new GPULimitBuilder(item);_visitables.get("gpus").remove(builder);if (this.gpus != null) {this.gpus.remove(builder);}} return (A)this;
  }
  public A removeAllFromGpus(Collection<GPULimit> items) {
    for (GPULimit item : items) {GPULimitBuilder builder = new GPULimitBuilder(item);_visitables.get("gpus").remove(builder);if (this.gpus != null) {this.gpus.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGpus(Predicate<GPULimitBuilder> predicate) {
    if (gpus == null) return (A) this;
    final Iterator<GPULimitBuilder> each = gpus.iterator();
    final List visitables = _visitables.get("gpus");
    while (each.hasNext()) {
      GPULimitBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildGpus instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GPULimit> getGpus() {
    return gpus != null ? build(gpus) : null;
  }
  public List<GPULimit> buildGpus() {
    return gpus != null ? build(gpus) : null;
  }
  public GPULimit buildGpus(int index) {
    return this.gpus.get(index).build();
  }
  public GPULimit buildFirstGpus() {
    return this.gpus.get(0).build();
  }
  public GPULimit buildLastGpus() {
    return this.gpus.get(gpus.size() - 1).build();
  }
  public GPULimit buildMatchingGpus(Predicate<GPULimitBuilder> predicate) {
    for (GPULimitBuilder item: gpus) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingGpus(Predicate<GPULimitBuilder> predicate) {
    for (GPULimitBuilder item: gpus) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGpus(List<GPULimit> gpus) {
    if (this.gpus != null) { _visitables.get("gpus").clear();}
    if (gpus != null) {this.gpus = new ArrayList(); for (GPULimit item : gpus){this.addToGpus(item);}} else { this.gpus = null;} return (A) this;
  }
  public A withGpus(io.fabric8.openshift.api.model.clusterautoscaling.v1.GPULimit... gpus) {
    if (this.gpus != null) {this.gpus.clear(); _visitables.remove("gpus"); }
    if (gpus != null) {for (GPULimit item :gpus){ this.addToGpus(item);}} return (A) this;
  }
  public Boolean hasGpus() {
    return gpus != null && !gpus.isEmpty();
  }
  public A addNewGpus(Integer max,Integer min,String type) {
    return (A)addToGpus(new GPULimit(max, min, type));
  }
  public ResourceLimitsFluentImpl.GpusNested<A> addNewGpus() {
    return new ResourceLimitsFluentImpl.GpusNestedImpl();
  }
  public ResourceLimitsFluentImpl.GpusNested<A> addNewGpusLike(GPULimit item) {
    return new ResourceLimitsFluentImpl.GpusNestedImpl(-1, item);
  }
  public ResourceLimitsFluentImpl.GpusNested<A> setNewGpusLike(int index,GPULimit item) {
    return new ResourceLimitsFluentImpl.GpusNestedImpl(index, item);
  }
  public ResourceLimitsFluentImpl.GpusNested<A> editGpus(int index) {
    if (gpus.size() <= index) throw new RuntimeException("Can't edit gpus. Index exceeds size.");
    return setNewGpusLike(index, buildGpus(index));
  }
  public ResourceLimitsFluentImpl.GpusNested<A> editFirstGpus() {
    if (gpus.size() == 0) throw new RuntimeException("Can't edit first gpus. The list is empty.");
    return setNewGpusLike(0, buildGpus(0));
  }
  public ResourceLimitsFluentImpl.GpusNested<A> editLastGpus() {
    int index = gpus.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last gpus. The list is empty.");
    return setNewGpusLike(index, buildGpus(index));
  }
  public ResourceLimitsFluentImpl.GpusNested<A> editMatchingGpus(Predicate<GPULimitBuilder> predicate) {
    int index = -1;
    for (int i=0;i<gpus.size();i++) { 
    if (predicate.test(gpus.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching gpus. No match found.");
    return setNewGpusLike(index, buildGpus(index));
  }
  public Integer getMaxNodesTotal() {
    return this.maxNodesTotal;
  }
  public A withMaxNodesTotal(Integer maxNodesTotal) {
    this.maxNodesTotal=maxNodesTotal; return (A) this;
  }
  public Boolean hasMaxNodesTotal() {
    return this.maxNodesTotal != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMemory instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRange getMemory() {
    return this.memory!=null ?this.memory.build():null;
  }
  public ResourceRange buildMemory() {
    return this.memory!=null ?this.memory.build():null;
  }
  public A withMemory(ResourceRange memory) {
    _visitables.get("memory").remove(this.memory);
    if (memory!=null){ this.memory= new ResourceRangeBuilder(memory); _visitables.get("memory").add(this.memory);} else { this.memory = null; _visitables.get("memory").remove(this.memory); } return (A) this;
  }
  public Boolean hasMemory() {
    return this.memory != null;
  }
  public A withNewMemory(Integer max,Integer min) {
    return (A)withMemory(new ResourceRange(max, min));
  }
  public ResourceLimitsFluentImpl.MemoryNested<A> withNewMemory() {
    return new ResourceLimitsFluentImpl.MemoryNestedImpl();
  }
  public ResourceLimitsFluentImpl.MemoryNested<A> withNewMemoryLike(ResourceRange item) {
    return new ResourceLimitsFluentImpl.MemoryNestedImpl(item);
  }
  public ResourceLimitsFluentImpl.MemoryNested<A> editMemory() {
    return withNewMemoryLike(getMemory());
  }
  public ResourceLimitsFluentImpl.MemoryNested<A> editOrNewMemory() {
    return withNewMemoryLike(getMemory() != null ? getMemory(): new ResourceRangeBuilder().build());
  }
  public ResourceLimitsFluentImpl.MemoryNested<A> editOrNewMemoryLike(ResourceRange item) {
    return withNewMemoryLike(getMemory() != null ? getMemory(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceLimitsFluentImpl that = (ResourceLimitsFluentImpl) o;
    if (!java.util.Objects.equals(cores, that.cores)) return false;

    if (!java.util.Objects.equals(gpus, that.gpus)) return false;

    if (!java.util.Objects.equals(maxNodesTotal, that.maxNodesTotal)) return false;

    if (!java.util.Objects.equals(memory, that.memory)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(cores,  gpus,  maxNodesTotal,  memory,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cores != null) { sb.append("cores:"); sb.append(cores + ","); }
    if (gpus != null) { sb.append("gpus:"); sb.append(gpus + ","); }
    if (maxNodesTotal != null) { sb.append("maxNodesTotal:"); sb.append(maxNodesTotal + ","); }
    if (memory != null) { sb.append("memory:"); sb.append(memory + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CoresNestedImpl<N> extends ResourceRangeFluentImpl<ResourceLimitsFluentImpl.CoresNested<N>> implements ResourceLimitsFluentImpl.CoresNested<N>,Nested<N>{
    CoresNestedImpl(ResourceRange item) {
      this.builder = new ResourceRangeBuilder(this, item);
    }
    CoresNestedImpl() {
      this.builder = new ResourceRangeBuilder(this);
    }
    ResourceRangeBuilder builder;
    public N and() {
      return (N) ResourceLimitsFluentImpl.this.withCores(builder.build());
    }
    public N endCores() {
      return and();
    }
    
  }
  class GpusNestedImpl<N> extends GPULimitFluentImpl<ResourceLimitsFluentImpl.GpusNested<N>> implements ResourceLimitsFluentImpl.GpusNested<N>,Nested<N>{
    GpusNestedImpl(int index,GPULimit item) {
      this.index = index;
      this.builder = new GPULimitBuilder(this, item);
    }
    GpusNestedImpl() {
      this.index = -1;
      this.builder = new GPULimitBuilder(this);
    }
    GPULimitBuilder builder;
    int index;
    public N and() {
      return (N) ResourceLimitsFluentImpl.this.setToGpus(index,builder.build());
    }
    public N endGpus() {
      return and();
    }
    
  }
  class MemoryNestedImpl<N> extends ResourceRangeFluentImpl<ResourceLimitsFluentImpl.MemoryNested<N>> implements ResourceLimitsFluentImpl.MemoryNested<N>,Nested<N>{
    MemoryNestedImpl(ResourceRange item) {
      this.builder = new ResourceRangeBuilder(this, item);
    }
    MemoryNestedImpl() {
      this.builder = new ResourceRangeBuilder(this);
    }
    ResourceRangeBuilder builder;
    public N and() {
      return (N) ResourceLimitsFluentImpl.this.withMemory(builder.build());
    }
    public N endMemory() {
      return and();
    }
    
  }
  
}