package io.fabric8.openshift.api.model.config.v1;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IdentityProviderFluent<A extends IdentityProviderFluent<A>> extends BaseFluent<A>{
  public IdentityProviderFluent() {
  }
  
  public IdentityProviderFluent(IdentityProvider instance) {
    this.copyInstance(instance);
  }
  private BasicAuthIdentityProviderBuilder basicAuth;
  private GitHubIdentityProviderBuilder github;
  private GitLabIdentityProviderBuilder gitlab;
  private GoogleIdentityProviderBuilder google;
  private HTPasswdIdentityProviderBuilder htpasswd;
  private KeystoneIdentityProviderBuilder keystone;
  private LDAPIdentityProviderBuilder ldap;
  private String mappingMethod;
  private String name;
  private OpenIDIdentityProviderBuilder openID;
  private RequestHeaderIdentityProviderBuilder requestHeader;
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IdentityProvider instance) {
    instance = (instance != null ? instance : new IdentityProvider());
    if (instance != null) {
          this.withBasicAuth(instance.getBasicAuth());
          this.withGithub(instance.getGithub());
          this.withGitlab(instance.getGitlab());
          this.withGoogle(instance.getGoogle());
          this.withHtpasswd(instance.getHtpasswd());
          this.withKeystone(instance.getKeystone());
          this.withLdap(instance.getLdap());
          this.withMappingMethod(instance.getMappingMethod());
          this.withName(instance.getName());
          this.withOpenID(instance.getOpenID());
          this.withRequestHeader(instance.getRequestHeader());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public BasicAuthIdentityProvider buildBasicAuth() {
    return this.basicAuth != null ? this.basicAuth.build() : null;
  }
  
  public A withBasicAuth(BasicAuthIdentityProvider basicAuth) {
    this._visitables.remove("basicAuth");
    if (basicAuth != null) {
        this.basicAuth = new BasicAuthIdentityProviderBuilder(basicAuth);
        this._visitables.get("basicAuth").add(this.basicAuth);
    } else {
        this.basicAuth = null;
        this._visitables.get("basicAuth").remove(this.basicAuth);
    }
    return (A) this;
  }
  
  public boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  
  public BasicAuthNested<A> withNewBasicAuth() {
    return new BasicAuthNested(null);
  }
  
  public BasicAuthNested<A> withNewBasicAuthLike(BasicAuthIdentityProvider item) {
    return new BasicAuthNested(item);
  }
  
  public BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(null));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(new BasicAuthIdentityProviderBuilder().build()));
  }
  
  public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuthIdentityProvider item) {
    return withNewBasicAuthLike(java.util.Optional.ofNullable(buildBasicAuth()).orElse(item));
  }
  
  public GitHubIdentityProvider buildGithub() {
    return this.github != null ? this.github.build() : null;
  }
  
  public A withGithub(GitHubIdentityProvider github) {
    this._visitables.remove("github");
    if (github != null) {
        this.github = new GitHubIdentityProviderBuilder(github);
        this._visitables.get("github").add(this.github);
    } else {
        this.github = null;
        this._visitables.get("github").remove(this.github);
    }
    return (A) this;
  }
  
  public boolean hasGithub() {
    return this.github != null;
  }
  
  public GithubNested<A> withNewGithub() {
    return new GithubNested(null);
  }
  
  public GithubNested<A> withNewGithubLike(GitHubIdentityProvider item) {
    return new GithubNested(item);
  }
  
  public GithubNested<A> editGithub() {
    return withNewGithubLike(java.util.Optional.ofNullable(buildGithub()).orElse(null));
  }
  
  public GithubNested<A> editOrNewGithub() {
    return withNewGithubLike(java.util.Optional.ofNullable(buildGithub()).orElse(new GitHubIdentityProviderBuilder().build()));
  }
  
  public GithubNested<A> editOrNewGithubLike(GitHubIdentityProvider item) {
    return withNewGithubLike(java.util.Optional.ofNullable(buildGithub()).orElse(item));
  }
  
  public GitLabIdentityProvider buildGitlab() {
    return this.gitlab != null ? this.gitlab.build() : null;
  }
  
  public A withGitlab(GitLabIdentityProvider gitlab) {
    this._visitables.remove("gitlab");
    if (gitlab != null) {
        this.gitlab = new GitLabIdentityProviderBuilder(gitlab);
        this._visitables.get("gitlab").add(this.gitlab);
    } else {
        this.gitlab = null;
        this._visitables.get("gitlab").remove(this.gitlab);
    }
    return (A) this;
  }
  
  public boolean hasGitlab() {
    return this.gitlab != null;
  }
  
  public GitlabNested<A> withNewGitlab() {
    return new GitlabNested(null);
  }
  
  public GitlabNested<A> withNewGitlabLike(GitLabIdentityProvider item) {
    return new GitlabNested(item);
  }
  
  public GitlabNested<A> editGitlab() {
    return withNewGitlabLike(java.util.Optional.ofNullable(buildGitlab()).orElse(null));
  }
  
  public GitlabNested<A> editOrNewGitlab() {
    return withNewGitlabLike(java.util.Optional.ofNullable(buildGitlab()).orElse(new GitLabIdentityProviderBuilder().build()));
  }
  
  public GitlabNested<A> editOrNewGitlabLike(GitLabIdentityProvider item) {
    return withNewGitlabLike(java.util.Optional.ofNullable(buildGitlab()).orElse(item));
  }
  
  public GoogleIdentityProvider buildGoogle() {
    return this.google != null ? this.google.build() : null;
  }
  
  public A withGoogle(GoogleIdentityProvider google) {
    this._visitables.remove("google");
    if (google != null) {
        this.google = new GoogleIdentityProviderBuilder(google);
        this._visitables.get("google").add(this.google);
    } else {
        this.google = null;
        this._visitables.get("google").remove(this.google);
    }
    return (A) this;
  }
  
  public boolean hasGoogle() {
    return this.google != null;
  }
  
  public GoogleNested<A> withNewGoogle() {
    return new GoogleNested(null);
  }
  
  public GoogleNested<A> withNewGoogleLike(GoogleIdentityProvider item) {
    return new GoogleNested(item);
  }
  
  public GoogleNested<A> editGoogle() {
    return withNewGoogleLike(java.util.Optional.ofNullable(buildGoogle()).orElse(null));
  }
  
  public GoogleNested<A> editOrNewGoogle() {
    return withNewGoogleLike(java.util.Optional.ofNullable(buildGoogle()).orElse(new GoogleIdentityProviderBuilder().build()));
  }
  
  public GoogleNested<A> editOrNewGoogleLike(GoogleIdentityProvider item) {
    return withNewGoogleLike(java.util.Optional.ofNullable(buildGoogle()).orElse(item));
  }
  
  public HTPasswdIdentityProvider buildHtpasswd() {
    return this.htpasswd != null ? this.htpasswd.build() : null;
  }
  
  public A withHtpasswd(HTPasswdIdentityProvider htpasswd) {
    this._visitables.remove("htpasswd");
    if (htpasswd != null) {
        this.htpasswd = new HTPasswdIdentityProviderBuilder(htpasswd);
        this._visitables.get("htpasswd").add(this.htpasswd);
    } else {
        this.htpasswd = null;
        this._visitables.get("htpasswd").remove(this.htpasswd);
    }
    return (A) this;
  }
  
  public boolean hasHtpasswd() {
    return this.htpasswd != null;
  }
  
  public HtpasswdNested<A> withNewHtpasswd() {
    return new HtpasswdNested(null);
  }
  
  public HtpasswdNested<A> withNewHtpasswdLike(HTPasswdIdentityProvider item) {
    return new HtpasswdNested(item);
  }
  
  public HtpasswdNested<A> editHtpasswd() {
    return withNewHtpasswdLike(java.util.Optional.ofNullable(buildHtpasswd()).orElse(null));
  }
  
  public HtpasswdNested<A> editOrNewHtpasswd() {
    return withNewHtpasswdLike(java.util.Optional.ofNullable(buildHtpasswd()).orElse(new HTPasswdIdentityProviderBuilder().build()));
  }
  
  public HtpasswdNested<A> editOrNewHtpasswdLike(HTPasswdIdentityProvider item) {
    return withNewHtpasswdLike(java.util.Optional.ofNullable(buildHtpasswd()).orElse(item));
  }
  
  public KeystoneIdentityProvider buildKeystone() {
    return this.keystone != null ? this.keystone.build() : null;
  }
  
  public A withKeystone(KeystoneIdentityProvider keystone) {
    this._visitables.remove("keystone");
    if (keystone != null) {
        this.keystone = new KeystoneIdentityProviderBuilder(keystone);
        this._visitables.get("keystone").add(this.keystone);
    } else {
        this.keystone = null;
        this._visitables.get("keystone").remove(this.keystone);
    }
    return (A) this;
  }
  
  public boolean hasKeystone() {
    return this.keystone != null;
  }
  
  public KeystoneNested<A> withNewKeystone() {
    return new KeystoneNested(null);
  }
  
  public KeystoneNested<A> withNewKeystoneLike(KeystoneIdentityProvider item) {
    return new KeystoneNested(item);
  }
  
  public KeystoneNested<A> editKeystone() {
    return withNewKeystoneLike(java.util.Optional.ofNullable(buildKeystone()).orElse(null));
  }
  
  public KeystoneNested<A> editOrNewKeystone() {
    return withNewKeystoneLike(java.util.Optional.ofNullable(buildKeystone()).orElse(new KeystoneIdentityProviderBuilder().build()));
  }
  
  public KeystoneNested<A> editOrNewKeystoneLike(KeystoneIdentityProvider item) {
    return withNewKeystoneLike(java.util.Optional.ofNullable(buildKeystone()).orElse(item));
  }
  
  public LDAPIdentityProvider buildLdap() {
    return this.ldap != null ? this.ldap.build() : null;
  }
  
  public A withLdap(LDAPIdentityProvider ldap) {
    this._visitables.remove("ldap");
    if (ldap != null) {
        this.ldap = new LDAPIdentityProviderBuilder(ldap);
        this._visitables.get("ldap").add(this.ldap);
    } else {
        this.ldap = null;
        this._visitables.get("ldap").remove(this.ldap);
    }
    return (A) this;
  }
  
  public boolean hasLdap() {
    return this.ldap != null;
  }
  
  public LdapNested<A> withNewLdap() {
    return new LdapNested(null);
  }
  
  public LdapNested<A> withNewLdapLike(LDAPIdentityProvider item) {
    return new LdapNested(item);
  }
  
  public LdapNested<A> editLdap() {
    return withNewLdapLike(java.util.Optional.ofNullable(buildLdap()).orElse(null));
  }
  
  public LdapNested<A> editOrNewLdap() {
    return withNewLdapLike(java.util.Optional.ofNullable(buildLdap()).orElse(new LDAPIdentityProviderBuilder().build()));
  }
  
  public LdapNested<A> editOrNewLdapLike(LDAPIdentityProvider item) {
    return withNewLdapLike(java.util.Optional.ofNullable(buildLdap()).orElse(item));
  }
  
  public String getMappingMethod() {
    return this.mappingMethod;
  }
  
  public A withMappingMethod(String mappingMethod) {
    this.mappingMethod = mappingMethod;
    return (A) this;
  }
  
  public boolean hasMappingMethod() {
    return this.mappingMethod != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public OpenIDIdentityProvider buildOpenID() {
    return this.openID != null ? this.openID.build() : null;
  }
  
  public A withOpenID(OpenIDIdentityProvider openID) {
    this._visitables.remove("openID");
    if (openID != null) {
        this.openID = new OpenIDIdentityProviderBuilder(openID);
        this._visitables.get("openID").add(this.openID);
    } else {
        this.openID = null;
        this._visitables.get("openID").remove(this.openID);
    }
    return (A) this;
  }
  
  public boolean hasOpenID() {
    return this.openID != null;
  }
  
  public OpenIDNested<A> withNewOpenID() {
    return new OpenIDNested(null);
  }
  
  public OpenIDNested<A> withNewOpenIDLike(OpenIDIdentityProvider item) {
    return new OpenIDNested(item);
  }
  
  public OpenIDNested<A> editOpenID() {
    return withNewOpenIDLike(java.util.Optional.ofNullable(buildOpenID()).orElse(null));
  }
  
  public OpenIDNested<A> editOrNewOpenID() {
    return withNewOpenIDLike(java.util.Optional.ofNullable(buildOpenID()).orElse(new OpenIDIdentityProviderBuilder().build()));
  }
  
  public OpenIDNested<A> editOrNewOpenIDLike(OpenIDIdentityProvider item) {
    return withNewOpenIDLike(java.util.Optional.ofNullable(buildOpenID()).orElse(item));
  }
  
  public RequestHeaderIdentityProvider buildRequestHeader() {
    return this.requestHeader != null ? this.requestHeader.build() : null;
  }
  
  public A withRequestHeader(RequestHeaderIdentityProvider requestHeader) {
    this._visitables.remove("requestHeader");
    if (requestHeader != null) {
        this.requestHeader = new RequestHeaderIdentityProviderBuilder(requestHeader);
        this._visitables.get("requestHeader").add(this.requestHeader);
    } else {
        this.requestHeader = null;
        this._visitables.get("requestHeader").remove(this.requestHeader);
    }
    return (A) this;
  }
  
  public boolean hasRequestHeader() {
    return this.requestHeader != null;
  }
  
  public RequestHeaderNested<A> withNewRequestHeader() {
    return new RequestHeaderNested(null);
  }
  
  public RequestHeaderNested<A> withNewRequestHeaderLike(RequestHeaderIdentityProvider item) {
    return new RequestHeaderNested(item);
  }
  
  public RequestHeaderNested<A> editRequestHeader() {
    return withNewRequestHeaderLike(java.util.Optional.ofNullable(buildRequestHeader()).orElse(null));
  }
  
  public RequestHeaderNested<A> editOrNewRequestHeader() {
    return withNewRequestHeaderLike(java.util.Optional.ofNullable(buildRequestHeader()).orElse(new RequestHeaderIdentityProviderBuilder().build()));
  }
  
  public RequestHeaderNested<A> editOrNewRequestHeaderLike(RequestHeaderIdentityProvider item) {
    return withNewRequestHeaderLike(java.util.Optional.ofNullable(buildRequestHeader()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IdentityProviderFluent that = (IdentityProviderFluent) o;
    if (!java.util.Objects.equals(basicAuth, that.basicAuth)) return false;
    if (!java.util.Objects.equals(github, that.github)) return false;
    if (!java.util.Objects.equals(gitlab, that.gitlab)) return false;
    if (!java.util.Objects.equals(google, that.google)) return false;
    if (!java.util.Objects.equals(htpasswd, that.htpasswd)) return false;
    if (!java.util.Objects.equals(keystone, that.keystone)) return false;
    if (!java.util.Objects.equals(ldap, that.ldap)) return false;
    if (!java.util.Objects.equals(mappingMethod, that.mappingMethod)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(openID, that.openID)) return false;
    if (!java.util.Objects.equals(requestHeader, that.requestHeader)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(basicAuth,  github,  gitlab,  google,  htpasswd,  keystone,  ldap,  mappingMethod,  name,  openID,  requestHeader,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (github != null) { sb.append("github:"); sb.append(github + ","); }
    if (gitlab != null) { sb.append("gitlab:"); sb.append(gitlab + ","); }
    if (google != null) { sb.append("google:"); sb.append(google + ","); }
    if (htpasswd != null) { sb.append("htpasswd:"); sb.append(htpasswd + ","); }
    if (keystone != null) { sb.append("keystone:"); sb.append(keystone + ","); }
    if (ldap != null) { sb.append("ldap:"); sb.append(ldap + ","); }
    if (mappingMethod != null) { sb.append("mappingMethod:"); sb.append(mappingMethod + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (openID != null) { sb.append("openID:"); sb.append(openID + ","); }
    if (requestHeader != null) { sb.append("requestHeader:"); sb.append(requestHeader + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BasicAuthNested<N> extends BasicAuthIdentityProviderFluent<BasicAuthNested<N>> implements Nested<N>{
    BasicAuthNested(BasicAuthIdentityProvider item) {
      this.builder = new BasicAuthIdentityProviderBuilder(this, item);
    }
    BasicAuthIdentityProviderBuilder builder;
    
    public N and() {
      return (N) IdentityProviderFluent.this.withBasicAuth(builder.build());
    }
    
    public N endBasicAuth() {
      return and();
    }
    
  
  }
  public class GithubNested<N> extends GitHubIdentityProviderFluent<GithubNested<N>> implements Nested<N>{
    GithubNested(GitHubIdentityProvider item) {
      this.builder = new GitHubIdentityProviderBuilder(this, item);
    }
    GitHubIdentityProviderBuilder builder;
    
    public N and() {
      return (N) IdentityProviderFluent.this.withGithub(builder.build());
    }
    
    public N endGithub() {
      return and();
    }
    
  
  }
  public class GitlabNested<N> extends GitLabIdentityProviderFluent<GitlabNested<N>> implements Nested<N>{
    GitlabNested(GitLabIdentityProvider item) {
      this.builder = new GitLabIdentityProviderBuilder(this, item);
    }
    GitLabIdentityProviderBuilder builder;
    
    public N and() {
      return (N) IdentityProviderFluent.this.withGitlab(builder.build());
    }
    
    public N endGitlab() {
      return and();
    }
    
  
  }
  public class GoogleNested<N> extends GoogleIdentityProviderFluent<GoogleNested<N>> implements Nested<N>{
    GoogleNested(GoogleIdentityProvider item) {
      this.builder = new GoogleIdentityProviderBuilder(this, item);
    }
    GoogleIdentityProviderBuilder builder;
    
    public N and() {
      return (N) IdentityProviderFluent.this.withGoogle(builder.build());
    }
    
    public N endGoogle() {
      return and();
    }
    
  
  }
  public class HtpasswdNested<N> extends HTPasswdIdentityProviderFluent<HtpasswdNested<N>> implements Nested<N>{
    HtpasswdNested(HTPasswdIdentityProvider item) {
      this.builder = new HTPasswdIdentityProviderBuilder(this, item);
    }
    HTPasswdIdentityProviderBuilder builder;
    
    public N and() {
      return (N) IdentityProviderFluent.this.withHtpasswd(builder.build());
    }
    
    public N endHtpasswd() {
      return and();
    }
    
  
  }
  public class KeystoneNested<N> extends KeystoneIdentityProviderFluent<KeystoneNested<N>> implements Nested<N>{
    KeystoneNested(KeystoneIdentityProvider item) {
      this.builder = new KeystoneIdentityProviderBuilder(this, item);
    }
    KeystoneIdentityProviderBuilder builder;
    
    public N and() {
      return (N) IdentityProviderFluent.this.withKeystone(builder.build());
    }
    
    public N endKeystone() {
      return and();
    }
    
  
  }
  public class LdapNested<N> extends LDAPIdentityProviderFluent<LdapNested<N>> implements Nested<N>{
    LdapNested(LDAPIdentityProvider item) {
      this.builder = new LDAPIdentityProviderBuilder(this, item);
    }
    LDAPIdentityProviderBuilder builder;
    
    public N and() {
      return (N) IdentityProviderFluent.this.withLdap(builder.build());
    }
    
    public N endLdap() {
      return and();
    }
    
  
  }
  public class OpenIDNested<N> extends OpenIDIdentityProviderFluent<OpenIDNested<N>> implements Nested<N>{
    OpenIDNested(OpenIDIdentityProvider item) {
      this.builder = new OpenIDIdentityProviderBuilder(this, item);
    }
    OpenIDIdentityProviderBuilder builder;
    
    public N and() {
      return (N) IdentityProviderFluent.this.withOpenID(builder.build());
    }
    
    public N endOpenID() {
      return and();
    }
    
  
  }
  public class RequestHeaderNested<N> extends RequestHeaderIdentityProviderFluent<RequestHeaderNested<N>> implements Nested<N>{
    RequestHeaderNested(RequestHeaderIdentityProvider item) {
      this.builder = new RequestHeaderIdentityProviderBuilder(this, item);
    }
    RequestHeaderIdentityProviderBuilder builder;
    
    public N and() {
      return (N) IdentityProviderFluent.this.withRequestHeader(builder.build());
    }
    
    public N endRequestHeader() {
      return and();
    }
    
  
  }

}