package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class APIServerSpecFluent<A extends APIServerSpecFluent<A>> extends BaseFluent<A>{
  public APIServerSpecFluent() {
  }
  
  public APIServerSpecFluent(APIServerSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> additionalCORSAllowedOrigins = new ArrayList<String>();
  private AuditBuilder audit;
  private ConfigMapNameReferenceBuilder clientCA;
  private APIServerEncryptionBuilder encryption;
  private APIServerServingCertsBuilder servingCerts;
  private TLSSecurityProfileBuilder tlsSecurityProfile;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(APIServerSpec instance) {
    instance = (instance != null ? instance : new APIServerSpec());
    if (instance != null) {
          this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
          this.withAudit(instance.getAudit());
          this.withClientCA(instance.getClientCA());
          this.withEncryption(instance.getEncryption());
          this.withServingCerts(instance.getServingCerts());
          this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAdditionalCORSAllowedOrigins(int index,String item) {
    if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
    this.additionalCORSAllowedOrigins.add(index, item);
    return (A)this;
  }
  
  public A setToAdditionalCORSAllowedOrigins(int index,String item) {
    if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
    this.additionalCORSAllowedOrigins.set(index, item); return (A)this;
  }
  
  public A addToAdditionalCORSAllowedOrigins(java.lang.String... items) {
    if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
    for (String item : items) {this.additionalCORSAllowedOrigins.add(item);} return (A)this;
  }
  
  public A addAllToAdditionalCORSAllowedOrigins(Collection<String> items) {
    if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
    for (String item : items) {this.additionalCORSAllowedOrigins.add(item);} return (A)this;
  }
  
  public A removeFromAdditionalCORSAllowedOrigins(java.lang.String... items) {
    if (this.additionalCORSAllowedOrigins == null) return (A)this;
    for (String item : items) { this.additionalCORSAllowedOrigins.remove(item);} return (A)this;
  }
  
  public A removeAllFromAdditionalCORSAllowedOrigins(Collection<String> items) {
    if (this.additionalCORSAllowedOrigins == null) return (A)this;
    for (String item : items) { this.additionalCORSAllowedOrigins.remove(item);} return (A)this;
  }
  
  public List<String> getAdditionalCORSAllowedOrigins() {
    return this.additionalCORSAllowedOrigins;
  }
  
  public String getAdditionalCORSAllowedOrigin(int index) {
    return this.additionalCORSAllowedOrigins.get(index);
  }
  
  public String getFirstAdditionalCORSAllowedOrigin() {
    return this.additionalCORSAllowedOrigins.get(0);
  }
  
  public String getLastAdditionalCORSAllowedOrigin() {
    return this.additionalCORSAllowedOrigins.get(additionalCORSAllowedOrigins.size() - 1);
  }
  
  public String getMatchingAdditionalCORSAllowedOrigin(Predicate<String> predicate) {
      for (String item : additionalCORSAllowedOrigins) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalCORSAllowedOrigin(Predicate<String> predicate) {
      for (String item : additionalCORSAllowedOrigins) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalCORSAllowedOrigins(List<String> additionalCORSAllowedOrigins) {
    if (additionalCORSAllowedOrigins != null) {
        this.additionalCORSAllowedOrigins = new ArrayList();
        for (String item : additionalCORSAllowedOrigins) {
          this.addToAdditionalCORSAllowedOrigins(item);
        }
    } else {
      this.additionalCORSAllowedOrigins = null;
    }
    return (A) this;
  }
  
  public A withAdditionalCORSAllowedOrigins(java.lang.String... additionalCORSAllowedOrigins) {
    if (this.additionalCORSAllowedOrigins != null) {
        this.additionalCORSAllowedOrigins.clear();
        _visitables.remove("additionalCORSAllowedOrigins");
    }
    if (additionalCORSAllowedOrigins != null) {
      for (String item : additionalCORSAllowedOrigins) {
        this.addToAdditionalCORSAllowedOrigins(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAdditionalCORSAllowedOrigins() {
    return this.additionalCORSAllowedOrigins != null && !this.additionalCORSAllowedOrigins.isEmpty();
  }
  
  public Audit buildAudit() {
    return this.audit != null ? this.audit.build() : null;
  }
  
  public A withAudit(Audit audit) {
    this._visitables.remove("audit");
    if (audit != null) {
        this.audit = new AuditBuilder(audit);
        this._visitables.get("audit").add(this.audit);
    } else {
        this.audit = null;
        this._visitables.get("audit").remove(this.audit);
    }
    return (A) this;
  }
  
  public boolean hasAudit() {
    return this.audit != null;
  }
  
  public AuditNested<A> withNewAudit() {
    return new AuditNested(null);
  }
  
  public AuditNested<A> withNewAuditLike(Audit item) {
    return new AuditNested(item);
  }
  
  public AuditNested<A> editAudit() {
    return withNewAuditLike(java.util.Optional.ofNullable(buildAudit()).orElse(null));
  }
  
  public AuditNested<A> editOrNewAudit() {
    return withNewAuditLike(java.util.Optional.ofNullable(buildAudit()).orElse(new AuditBuilder().build()));
  }
  
  public AuditNested<A> editOrNewAuditLike(Audit item) {
    return withNewAuditLike(java.util.Optional.ofNullable(buildAudit()).orElse(item));
  }
  
  public ConfigMapNameReference buildClientCA() {
    return this.clientCA != null ? this.clientCA.build() : null;
  }
  
  public A withClientCA(ConfigMapNameReference clientCA) {
    this._visitables.remove("clientCA");
    if (clientCA != null) {
        this.clientCA = new ConfigMapNameReferenceBuilder(clientCA);
        this._visitables.get("clientCA").add(this.clientCA);
    } else {
        this.clientCA = null;
        this._visitables.get("clientCA").remove(this.clientCA);
    }
    return (A) this;
  }
  
  public boolean hasClientCA() {
    return this.clientCA != null;
  }
  
  public A withNewClientCA(String name) {
    return (A)withClientCA(new ConfigMapNameReference(name));
  }
  
  public ClientCANested<A> withNewClientCA() {
    return new ClientCANested(null);
  }
  
  public ClientCANested<A> withNewClientCALike(ConfigMapNameReference item) {
    return new ClientCANested(item);
  }
  
  public ClientCANested<A> editClientCA() {
    return withNewClientCALike(java.util.Optional.ofNullable(buildClientCA()).orElse(null));
  }
  
  public ClientCANested<A> editOrNewClientCA() {
    return withNewClientCALike(java.util.Optional.ofNullable(buildClientCA()).orElse(new ConfigMapNameReferenceBuilder().build()));
  }
  
  public ClientCANested<A> editOrNewClientCALike(ConfigMapNameReference item) {
    return withNewClientCALike(java.util.Optional.ofNullable(buildClientCA()).orElse(item));
  }
  
  public APIServerEncryption buildEncryption() {
    return this.encryption != null ? this.encryption.build() : null;
  }
  
  public A withEncryption(APIServerEncryption encryption) {
    this._visitables.remove("encryption");
    if (encryption != null) {
        this.encryption = new APIServerEncryptionBuilder(encryption);
        this._visitables.get("encryption").add(this.encryption);
    } else {
        this.encryption = null;
        this._visitables.get("encryption").remove(this.encryption);
    }
    return (A) this;
  }
  
  public boolean hasEncryption() {
    return this.encryption != null;
  }
  
  public A withNewEncryption(String type) {
    return (A)withEncryption(new APIServerEncryption(type));
  }
  
  public EncryptionNested<A> withNewEncryption() {
    return new EncryptionNested(null);
  }
  
  public EncryptionNested<A> withNewEncryptionLike(APIServerEncryption item) {
    return new EncryptionNested(item);
  }
  
  public EncryptionNested<A> editEncryption() {
    return withNewEncryptionLike(java.util.Optional.ofNullable(buildEncryption()).orElse(null));
  }
  
  public EncryptionNested<A> editOrNewEncryption() {
    return withNewEncryptionLike(java.util.Optional.ofNullable(buildEncryption()).orElse(new APIServerEncryptionBuilder().build()));
  }
  
  public EncryptionNested<A> editOrNewEncryptionLike(APIServerEncryption item) {
    return withNewEncryptionLike(java.util.Optional.ofNullable(buildEncryption()).orElse(item));
  }
  
  public APIServerServingCerts buildServingCerts() {
    return this.servingCerts != null ? this.servingCerts.build() : null;
  }
  
  public A withServingCerts(APIServerServingCerts servingCerts) {
    this._visitables.remove("servingCerts");
    if (servingCerts != null) {
        this.servingCerts = new APIServerServingCertsBuilder(servingCerts);
        this._visitables.get("servingCerts").add(this.servingCerts);
    } else {
        this.servingCerts = null;
        this._visitables.get("servingCerts").remove(this.servingCerts);
    }
    return (A) this;
  }
  
  public boolean hasServingCerts() {
    return this.servingCerts != null;
  }
  
  public ServingCertsNested<A> withNewServingCerts() {
    return new ServingCertsNested(null);
  }
  
  public ServingCertsNested<A> withNewServingCertsLike(APIServerServingCerts item) {
    return new ServingCertsNested(item);
  }
  
  public ServingCertsNested<A> editServingCerts() {
    return withNewServingCertsLike(java.util.Optional.ofNullable(buildServingCerts()).orElse(null));
  }
  
  public ServingCertsNested<A> editOrNewServingCerts() {
    return withNewServingCertsLike(java.util.Optional.ofNullable(buildServingCerts()).orElse(new APIServerServingCertsBuilder().build()));
  }
  
  public ServingCertsNested<A> editOrNewServingCertsLike(APIServerServingCerts item) {
    return withNewServingCertsLike(java.util.Optional.ofNullable(buildServingCerts()).orElse(item));
  }
  
  public TLSSecurityProfile buildTlsSecurityProfile() {
    return this.tlsSecurityProfile != null ? this.tlsSecurityProfile.build() : null;
  }
  
  public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
    this._visitables.remove("tlsSecurityProfile");
    if (tlsSecurityProfile != null) {
        this.tlsSecurityProfile = new TLSSecurityProfileBuilder(tlsSecurityProfile);
        this._visitables.get("tlsSecurityProfile").add(this.tlsSecurityProfile);
    } else {
        this.tlsSecurityProfile = null;
        this._visitables.get("tlsSecurityProfile").remove(this.tlsSecurityProfile);
    }
    return (A) this;
  }
  
  public boolean hasTlsSecurityProfile() {
    return this.tlsSecurityProfile != null;
  }
  
  public TlsSecurityProfileNested<A> withNewTlsSecurityProfile() {
    return new TlsSecurityProfileNested(null);
  }
  
  public TlsSecurityProfileNested<A> withNewTlsSecurityProfileLike(TLSSecurityProfile item) {
    return new TlsSecurityProfileNested(item);
  }
  
  public TlsSecurityProfileNested<A> editTlsSecurityProfile() {
    return withNewTlsSecurityProfileLike(java.util.Optional.ofNullable(buildTlsSecurityProfile()).orElse(null));
  }
  
  public TlsSecurityProfileNested<A> editOrNewTlsSecurityProfile() {
    return withNewTlsSecurityProfileLike(java.util.Optional.ofNullable(buildTlsSecurityProfile()).orElse(new TLSSecurityProfileBuilder().build()));
  }
  
  public TlsSecurityProfileNested<A> editOrNewTlsSecurityProfileLike(TLSSecurityProfile item) {
    return withNewTlsSecurityProfileLike(java.util.Optional.ofNullable(buildTlsSecurityProfile()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIServerSpecFluent that = (APIServerSpecFluent) o;
    if (!java.util.Objects.equals(additionalCORSAllowedOrigins, that.additionalCORSAllowedOrigins)) return false;
    if (!java.util.Objects.equals(audit, that.audit)) return false;
    if (!java.util.Objects.equals(clientCA, that.clientCA)) return false;
    if (!java.util.Objects.equals(encryption, that.encryption)) return false;
    if (!java.util.Objects.equals(servingCerts, that.servingCerts)) return false;
    if (!java.util.Objects.equals(tlsSecurityProfile, that.tlsSecurityProfile)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalCORSAllowedOrigins,  audit,  clientCA,  encryption,  servingCerts,  tlsSecurityProfile,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalCORSAllowedOrigins != null && !additionalCORSAllowedOrigins.isEmpty()) { sb.append("additionalCORSAllowedOrigins:"); sb.append(additionalCORSAllowedOrigins + ","); }
    if (audit != null) { sb.append("audit:"); sb.append(audit + ","); }
    if (clientCA != null) { sb.append("clientCA:"); sb.append(clientCA + ","); }
    if (encryption != null) { sb.append("encryption:"); sb.append(encryption + ","); }
    if (servingCerts != null) { sb.append("servingCerts:"); sb.append(servingCerts + ","); }
    if (tlsSecurityProfile != null) { sb.append("tlsSecurityProfile:"); sb.append(tlsSecurityProfile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AuditNested<N> extends AuditFluent<AuditNested<N>> implements Nested<N>{
    AuditNested(Audit item) {
      this.builder = new AuditBuilder(this, item);
    }
    AuditBuilder builder;
    
    public N and() {
      return (N) APIServerSpecFluent.this.withAudit(builder.build());
    }
    
    public N endAudit() {
      return and();
    }
    
  
  }
  public class ClientCANested<N> extends ConfigMapNameReferenceFluent<ClientCANested<N>> implements Nested<N>{
    ClientCANested(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    ConfigMapNameReferenceBuilder builder;
    
    public N and() {
      return (N) APIServerSpecFluent.this.withClientCA(builder.build());
    }
    
    public N endClientCA() {
      return and();
    }
    
  
  }
  public class EncryptionNested<N> extends APIServerEncryptionFluent<EncryptionNested<N>> implements Nested<N>{
    EncryptionNested(APIServerEncryption item) {
      this.builder = new APIServerEncryptionBuilder(this, item);
    }
    APIServerEncryptionBuilder builder;
    
    public N and() {
      return (N) APIServerSpecFluent.this.withEncryption(builder.build());
    }
    
    public N endEncryption() {
      return and();
    }
    
  
  }
  public class ServingCertsNested<N> extends APIServerServingCertsFluent<ServingCertsNested<N>> implements Nested<N>{
    ServingCertsNested(APIServerServingCerts item) {
      this.builder = new APIServerServingCertsBuilder(this, item);
    }
    APIServerServingCertsBuilder builder;
    
    public N and() {
      return (N) APIServerSpecFluent.this.withServingCerts(builder.build());
    }
    
    public N endServingCerts() {
      return and();
    }
    
  
  }
  public class TlsSecurityProfileNested<N> extends TLSSecurityProfileFluent<TlsSecurityProfileNested<N>> implements Nested<N>{
    TlsSecurityProfileNested(TLSSecurityProfile item) {
      this.builder = new TLSSecurityProfileBuilder(this, item);
    }
    TLSSecurityProfileBuilder builder;
    
    public N and() {
      return (N) APIServerSpecFluent.this.withTlsSecurityProfile(builder.build());
    }
    
    public N endTlsSecurityProfile() {
      return and();
    }
    
  
  }

}