package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OAuthStatusBuilder extends OAuthStatusFluent<OAuthStatusBuilder> implements VisitableBuilder<OAuthStatus,OAuthStatusBuilder>{
  public OAuthStatusBuilder() {
    this(new OAuthStatus());
  }
  
  public OAuthStatusBuilder(OAuthStatusFluent<?> fluent) {
    this(fluent, new OAuthStatus());
  }
  
  public OAuthStatusBuilder(OAuthStatusFluent<?> fluent,OAuthStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OAuthStatusBuilder(OAuthStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OAuthStatusFluent<?> fluent;
  
  public OAuthStatus build() {
    OAuthStatus buildable = new OAuthStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}