package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzurePlatformSpecBuilder extends AzurePlatformSpecFluent<AzurePlatformSpecBuilder> implements VisitableBuilder<AzurePlatformSpec,AzurePlatformSpecBuilder>{
  public AzurePlatformSpecBuilder() {
    this(new AzurePlatformSpec());
  }
  
  public AzurePlatformSpecBuilder(AzurePlatformSpecFluent<?> fluent) {
    this(fluent, new AzurePlatformSpec());
  }
  
  public AzurePlatformSpecBuilder(AzurePlatformSpecFluent<?> fluent,AzurePlatformSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzurePlatformSpecBuilder(AzurePlatformSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzurePlatformSpecFluent<?> fluent;
  
  public AzurePlatformSpec build() {
    AzurePlatformSpec buildable = new AzurePlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}