package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageContentPolicyBuilder extends ImageContentPolicyFluent<ImageContentPolicyBuilder> implements VisitableBuilder<ImageContentPolicy,ImageContentPolicyBuilder>{
  public ImageContentPolicyBuilder() {
    this(new ImageContentPolicy());
  }
  
  public ImageContentPolicyBuilder(ImageContentPolicyFluent<?> fluent) {
    this(fluent, new ImageContentPolicy());
  }
  
  public ImageContentPolicyBuilder(ImageContentPolicyFluent<?> fluent,ImageContentPolicy instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageContentPolicyBuilder(ImageContentPolicy instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageContentPolicyFluent<?> fluent;
  
  public ImageContentPolicy build() {
    ImageContentPolicy buildable = new ImageContentPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}