package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServerEncryptionBuilder extends APIServerEncryptionFluentImpl<APIServerEncryptionBuilder> implements VisitableBuilder<APIServerEncryption,APIServerEncryptionBuilder>{
  public APIServerEncryptionBuilder() {
    this(false);
  }
  public APIServerEncryptionBuilder(Boolean validationEnabled) {
    this(new APIServerEncryption(), validationEnabled);
  }
  public APIServerEncryptionBuilder(APIServerEncryptionFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServerEncryptionBuilder(APIServerEncryptionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServerEncryption(), validationEnabled);
  }
  public APIServerEncryptionBuilder(APIServerEncryptionFluent<?> fluent,APIServerEncryption instance) {
    this(fluent, instance, false);
  }
  public APIServerEncryptionBuilder(APIServerEncryptionFluent<?> fluent,APIServerEncryption instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public APIServerEncryptionBuilder(APIServerEncryption instance) {
    this(instance,false);
  }
  public APIServerEncryptionBuilder(APIServerEncryption instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  APIServerEncryptionFluent<?> fluent;
  Boolean validationEnabled;
  public APIServerEncryption build() {
    APIServerEncryption buildable = new APIServerEncryption(fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}