package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthenticationBuilder extends AuthenticationFluentImpl<AuthenticationBuilder> implements VisitableBuilder<Authentication,AuthenticationBuilder>{
  public AuthenticationBuilder() {
    this(false);
  }
  public AuthenticationBuilder(Boolean validationEnabled) {
    this(new Authentication(), validationEnabled);
  }
  public AuthenticationBuilder(AuthenticationFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthenticationBuilder(AuthenticationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Authentication(), validationEnabled);
  }
  public AuthenticationBuilder(AuthenticationFluent<?> fluent,Authentication instance) {
    this(fluent, instance, false);
  }
  public AuthenticationBuilder(AuthenticationFluent<?> fluent,Authentication instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AuthenticationBuilder(Authentication instance) {
    this(instance,false);
  }
  public AuthenticationBuilder(Authentication instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AuthenticationFluent<?> fluent;
  Boolean validationEnabled;
  public Authentication build() {
    Authentication buildable = new Authentication(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}