package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthenticationSpecBuilder extends AuthenticationSpecFluentImpl<AuthenticationSpecBuilder> implements VisitableBuilder<AuthenticationSpec,AuthenticationSpecBuilder>{
  public AuthenticationSpecBuilder() {
    this(false);
  }
  public AuthenticationSpecBuilder(Boolean validationEnabled) {
    this(new AuthenticationSpec(), validationEnabled);
  }
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AuthenticationSpec(), validationEnabled);
  }
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent,AuthenticationSpec instance) {
    this(fluent, instance, false);
  }
  public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent,AuthenticationSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withOauthMetadata(instance.getOauthMetadata()); 
    fluent.withServiceAccountIssuer(instance.getServiceAccountIssuer()); 
    fluent.withType(instance.getType()); 
    fluent.withWebhookTokenAuthenticator(instance.getWebhookTokenAuthenticator()); 
    fluent.withWebhookTokenAuthenticators(instance.getWebhookTokenAuthenticators()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AuthenticationSpecBuilder(AuthenticationSpec instance) {
    this(instance,false);
  }
  public AuthenticationSpecBuilder(AuthenticationSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withOauthMetadata(instance.getOauthMetadata()); 
    this.withServiceAccountIssuer(instance.getServiceAccountIssuer()); 
    this.withType(instance.getType()); 
    this.withWebhookTokenAuthenticator(instance.getWebhookTokenAuthenticator()); 
    this.withWebhookTokenAuthenticators(instance.getWebhookTokenAuthenticators()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AuthenticationSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AuthenticationSpec build() {
    AuthenticationSpec buildable = new AuthenticationSpec(fluent.getOauthMetadata(),fluent.getServiceAccountIssuer(),fluent.getType(),fluent.getWebhookTokenAuthenticator(),fluent.getWebhookTokenAuthenticators());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}