package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BuildOverridesFluentImpl<A extends BuildOverridesFluent<A>> extends BaseFluent<A> implements BuildOverridesFluent<A>{
  public BuildOverridesFluentImpl() {
  }
  public BuildOverridesFluentImpl(BuildOverrides instance) {
    this.withForcePull(instance.getForcePull()); 
    this.withImageLabels(instance.getImageLabels()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withTolerations(instance.getTolerations()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Boolean forcePull;
  private ArrayList<ImageLabelBuilder> imageLabels = new ArrayList<ImageLabelBuilder>();
  private Map<String,String> nodeSelector;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  private Map<String,Object> additionalProperties;
  public Boolean getForcePull() {
    return this.forcePull;
  }
  public A withForcePull(Boolean forcePull) {
    this.forcePull=forcePull; return (A) this;
  }
  public Boolean hasForcePull() {
    return this.forcePull != null;
  }
  public A addToImageLabels(Integer index,ImageLabel item) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").add(index >= 0 ? index : _visitables.get("imageLabels").size(), builder);this.imageLabels.add(index >= 0 ? index : imageLabels.size(), builder); return (A)this;
  }
  public A setToImageLabels(Integer index,ImageLabel item) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    ImageLabelBuilder builder = new ImageLabelBuilder(item);
    if (index < 0 || index >= _visitables.get("imageLabels").size()) { _visitables.get("imageLabels").add(builder); } else { _visitables.get("imageLabels").set(index, builder);}
    if (index < 0 || index >= imageLabels.size()) { imageLabels.add(builder); } else { imageLabels.set(index, builder);}
     return (A)this;
  }
  public A addToImageLabels(io.fabric8.openshift.api.model.config.v1.ImageLabel... items) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
  }
  public A addAllToImageLabels(Collection<ImageLabel> items) {
    if (this.imageLabels == null) {this.imageLabels = new ArrayList<ImageLabelBuilder>();}
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").add(builder);this.imageLabels.add(builder);} return (A)this;
  }
  public A removeFromImageLabels(io.fabric8.openshift.api.model.config.v1.ImageLabel... items) {
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder);if (this.imageLabels != null) {this.imageLabels.remove(builder);}} return (A)this;
  }
  public A removeAllFromImageLabels(Collection<ImageLabel> items) {
    for (ImageLabel item : items) {ImageLabelBuilder builder = new ImageLabelBuilder(item);_visitables.get("imageLabels").remove(builder);if (this.imageLabels != null) {this.imageLabels.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImageLabels(Predicate<ImageLabelBuilder> predicate) {
    if (imageLabels == null) return (A) this;
    final Iterator<ImageLabelBuilder> each = imageLabels.iterator();
    final List visitables = _visitables.get("imageLabels");
    while (each.hasNext()) {
      ImageLabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImageLabels instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageLabel> getImageLabels() {
    return imageLabels != null ? build(imageLabels) : null;
  }
  public List<ImageLabel> buildImageLabels() {
    return imageLabels != null ? build(imageLabels) : null;
  }
  public ImageLabel buildImageLabel(Integer index) {
    return this.imageLabels.get(index).build();
  }
  public ImageLabel buildFirstImageLabel() {
    return this.imageLabels.get(0).build();
  }
  public ImageLabel buildLastImageLabel() {
    return this.imageLabels.get(imageLabels.size() - 1).build();
  }
  public ImageLabel buildMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
    for (ImageLabelBuilder item: imageLabels) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
    for (ImageLabelBuilder item: imageLabels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImageLabels(List<ImageLabel> imageLabels) {
    if (this.imageLabels != null) { _visitables.get("imageLabels").removeAll(this.imageLabels);}
    if (imageLabels != null) {this.imageLabels = new ArrayList(); for (ImageLabel item : imageLabels){this.addToImageLabels(item);}} else { this.imageLabels = null;} return (A) this;
  }
  public A withImageLabels(io.fabric8.openshift.api.model.config.v1.ImageLabel... imageLabels) {
    if (this.imageLabels != null) {this.imageLabels.clear();}
    if (imageLabels != null) {for (ImageLabel item :imageLabels){ this.addToImageLabels(item);}} return (A) this;
  }
  public Boolean hasImageLabels() {
    return imageLabels != null && !imageLabels.isEmpty();
  }
  public A addNewImageLabel(String name,String value) {
    return (A)addToImageLabels(new ImageLabel(name, value));
  }
  public BuildOverridesFluent.ImageLabelsNested<A> addNewImageLabel() {
    return new BuildOverridesFluentImpl.ImageLabelsNestedImpl();
  }
  public BuildOverridesFluent.ImageLabelsNested<A> addNewImageLabelLike(ImageLabel item) {
    return new BuildOverridesFluentImpl.ImageLabelsNestedImpl(-1, item);
  }
  public BuildOverridesFluent.ImageLabelsNested<A> setNewImageLabelLike(Integer index,ImageLabel item) {
    return new BuildOverridesFluentImpl.ImageLabelsNestedImpl(index, item);
  }
  public BuildOverridesFluent.ImageLabelsNested<A> editImageLabel(Integer index) {
    if (imageLabels.size() <= index) throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  public BuildOverridesFluent.ImageLabelsNested<A> editFirstImageLabel() {
    if (imageLabels.size() == 0) throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
    return setNewImageLabelLike(0, buildImageLabel(0));
  }
  public BuildOverridesFluent.ImageLabelsNested<A> editLastImageLabel() {
    int index = imageLabels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  public BuildOverridesFluent.ImageLabelsNested<A> editMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageLabels.size();i++) { 
    if (predicate.test(imageLabels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageLabels. No match found.");
    return setNewImageLabelLike(index, buildImageLabel(index));
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  public A addToTolerations(Integer index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  public A setToTolerations(Integer index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
  }
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  public Toleration getToleration(Integer index) {
    return this.tolerations.get(index);
  }
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
    for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear();}
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BuildOverridesFluentImpl that = (BuildOverridesFluentImpl) o;
    if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
    if (imageLabels != null ? !imageLabels.equals(that.imageLabels) :that.imageLabels != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(forcePull,  imageLabels,  nodeSelector,  tolerations,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (forcePull != null) { sb.append("forcePull:"); sb.append(forcePull + ","); }
    if (imageLabels != null && !imageLabels.isEmpty()) { sb.append("imageLabels:"); sb.append(imageLabels + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withForcePull() {
    return withForcePull(true);
  }
  class ImageLabelsNestedImpl<N> extends ImageLabelFluentImpl<BuildOverridesFluent.ImageLabelsNested<N>> implements BuildOverridesFluent.ImageLabelsNested<N>,Nested<N>{
    ImageLabelsNestedImpl(Integer index,ImageLabel item) {
      this.index = index;
      this.builder = new ImageLabelBuilder(this, item);
    }
    ImageLabelsNestedImpl() {
      this.index = -1;
      this.builder = new ImageLabelBuilder(this);
    }
    ImageLabelBuilder builder;
    Integer index;
    public N and() {
      return (N) BuildOverridesFluentImpl.this.setToImageLabels(index,builder.build());
    }
    public N endImageLabel() {
      return and();
    }
    
  }
  
}