package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildSpecBuilder extends BuildSpecFluentImpl<BuildSpecBuilder> implements VisitableBuilder<BuildSpec,BuildSpecBuilder>{
  public BuildSpecBuilder() {
    this(false);
  }
  public BuildSpecBuilder(Boolean validationEnabled) {
    this(new BuildSpec(), validationEnabled);
  }
  public BuildSpecBuilder(BuildSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildSpecBuilder(BuildSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildSpec(), validationEnabled);
  }
  public BuildSpecBuilder(BuildSpecFluent<?> fluent,BuildSpec instance) {
    this(fluent, instance, false);
  }
  public BuildSpecBuilder(BuildSpecFluent<?> fluent,BuildSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalTrustedCA(instance.getAdditionalTrustedCA()); 
    fluent.withBuildDefaults(instance.getBuildDefaults()); 
    fluent.withBuildOverrides(instance.getBuildOverrides()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildSpecBuilder(BuildSpec instance) {
    this(instance,false);
  }
  public BuildSpecBuilder(BuildSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalTrustedCA(instance.getAdditionalTrustedCA()); 
    this.withBuildDefaults(instance.getBuildDefaults()); 
    this.withBuildOverrides(instance.getBuildOverrides()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  BuildSpecFluent<?> fluent;
  Boolean validationEnabled;
  public BuildSpec build() {
    BuildSpec buildable = new BuildSpec(fluent.getAdditionalTrustedCA(),fluent.getBuildDefaults(),fluent.getBuildOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}