package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterOperatorListBuilder extends ClusterOperatorListFluentImpl<ClusterOperatorListBuilder> implements VisitableBuilder<ClusterOperatorList,ClusterOperatorListBuilder>{
  public ClusterOperatorListBuilder() {
    this(false);
  }
  public ClusterOperatorListBuilder(Boolean validationEnabled) {
    this(new ClusterOperatorList(), validationEnabled);
  }
  public ClusterOperatorListBuilder(ClusterOperatorListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterOperatorListBuilder(ClusterOperatorListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterOperatorList(), validationEnabled);
  }
  public ClusterOperatorListBuilder(ClusterOperatorListFluent<?> fluent,ClusterOperatorList instance) {
    this(fluent, instance, false);
  }
  public ClusterOperatorListBuilder(ClusterOperatorListFluent<?> fluent,ClusterOperatorList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterOperatorListBuilder(ClusterOperatorList instance) {
    this(instance,false);
  }
  public ClusterOperatorListBuilder(ClusterOperatorList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterOperatorListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterOperatorList build() {
    ClusterOperatorList buildable = new ClusterOperatorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}