package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HubSourceStatusBuilder extends HubSourceStatusFluentImpl<HubSourceStatusBuilder> implements VisitableBuilder<HubSourceStatus,HubSourceStatusBuilder>{
  public HubSourceStatusBuilder() {
    this(false);
  }
  public HubSourceStatusBuilder(Boolean validationEnabled) {
    this(new HubSourceStatus(), validationEnabled);
  }
  public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HubSourceStatus(), validationEnabled);
  }
  public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent,HubSourceStatus instance) {
    this(fluent, instance, false);
  }
  public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent,HubSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDisabled(instance.getDisabled()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withName(instance.getName()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HubSourceStatusBuilder(HubSourceStatus instance) {
    this(instance,false);
  }
  public HubSourceStatusBuilder(HubSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDisabled(instance.getDisabled()); 
    this.withMessage(instance.getMessage()); 
    this.withName(instance.getName()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HubSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public HubSourceStatus build() {
    HubSourceStatus buildable = new HubSourceStatus(fluent.getDisabled(),fluent.getMessage(),fluent.getName(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}