package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageSpecFluentImpl<A extends ImageSpecFluent<A>> extends BaseFluent<A> implements ImageSpecFluent<A>{
  public ImageSpecFluentImpl() {
  }
  public ImageSpecFluentImpl(ImageSpec instance) {
    this.withAdditionalTrustedCA(instance.getAdditionalTrustedCA()); 
    this.withAllowedRegistriesForImport(instance.getAllowedRegistriesForImport()); 
    this.withExternalRegistryHostnames(instance.getExternalRegistryHostnames()); 
    this.withRegistrySources(instance.getRegistrySources()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConfigMapNameReferenceBuilder additionalTrustedCA;
  private ArrayList<RegistryLocationBuilder> allowedRegistriesForImport = new ArrayList<RegistryLocationBuilder>();
  private List<String> externalRegistryHostnames = new ArrayList<String>();
  private RegistrySourcesBuilder registrySources;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAdditionalTrustedCA instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getAdditionalTrustedCA() {
    return this.additionalTrustedCA!=null ?this.additionalTrustedCA.build():null;
  }
  public ConfigMapNameReference buildAdditionalTrustedCA() {
    return this.additionalTrustedCA!=null ?this.additionalTrustedCA.build():null;
  }
  public A withAdditionalTrustedCA(ConfigMapNameReference additionalTrustedCA) {
    _visitables.get("additionalTrustedCA").remove(this.additionalTrustedCA);
    if (additionalTrustedCA!=null){ this.additionalTrustedCA= new ConfigMapNameReferenceBuilder(additionalTrustedCA); _visitables.get("additionalTrustedCA").add(this.additionalTrustedCA);} else { this.additionalTrustedCA = null; _visitables.get("additionalTrustedCA").remove(this.additionalTrustedCA); } return (A) this;
  }
  public Boolean hasAdditionalTrustedCA() {
    return this.additionalTrustedCA != null;
  }
  public A withNewAdditionalTrustedCA(String name) {
    return (A)withAdditionalTrustedCA(new ConfigMapNameReference(name));
  }
  public ImageSpecFluent.AdditionalTrustedCANested<A> withNewAdditionalTrustedCA() {
    return new ImageSpecFluentImpl.AdditionalTrustedCANestedImpl();
  }
  public ImageSpecFluent.AdditionalTrustedCANested<A> withNewAdditionalTrustedCALike(ConfigMapNameReference item) {
    return new ImageSpecFluentImpl.AdditionalTrustedCANestedImpl(item);
  }
  public ImageSpecFluent.AdditionalTrustedCANested<A> editAdditionalTrustedCA() {
    return withNewAdditionalTrustedCALike(getAdditionalTrustedCA());
  }
  public ImageSpecFluent.AdditionalTrustedCANested<A> editOrNewAdditionalTrustedCA() {
    return withNewAdditionalTrustedCALike(getAdditionalTrustedCA() != null ? getAdditionalTrustedCA(): new ConfigMapNameReferenceBuilder().build());
  }
  public ImageSpecFluent.AdditionalTrustedCANested<A> editOrNewAdditionalTrustedCALike(ConfigMapNameReference item) {
    return withNewAdditionalTrustedCALike(getAdditionalTrustedCA() != null ? getAdditionalTrustedCA(): item);
  }
  public A addToAllowedRegistriesForImport(Integer index,RegistryLocation item) {
    if (this.allowedRegistriesForImport == null) {this.allowedRegistriesForImport = new ArrayList<RegistryLocationBuilder>();}
    RegistryLocationBuilder builder = new RegistryLocationBuilder(item);_visitables.get("allowedRegistriesForImport").add(index >= 0 ? index : _visitables.get("allowedRegistriesForImport").size(), builder);this.allowedRegistriesForImport.add(index >= 0 ? index : allowedRegistriesForImport.size(), builder); return (A)this;
  }
  public A setToAllowedRegistriesForImport(Integer index,RegistryLocation item) {
    if (this.allowedRegistriesForImport == null) {this.allowedRegistriesForImport = new ArrayList<RegistryLocationBuilder>();}
    RegistryLocationBuilder builder = new RegistryLocationBuilder(item);
    if (index < 0 || index >= _visitables.get("allowedRegistriesForImport").size()) { _visitables.get("allowedRegistriesForImport").add(builder); } else { _visitables.get("allowedRegistriesForImport").set(index, builder);}
    if (index < 0 || index >= allowedRegistriesForImport.size()) { allowedRegistriesForImport.add(builder); } else { allowedRegistriesForImport.set(index, builder);}
     return (A)this;
  }
  public A addToAllowedRegistriesForImport(io.fabric8.openshift.api.model.config.v1.RegistryLocation... items) {
    if (this.allowedRegistriesForImport == null) {this.allowedRegistriesForImport = new ArrayList<RegistryLocationBuilder>();}
    for (RegistryLocation item : items) {RegistryLocationBuilder builder = new RegistryLocationBuilder(item);_visitables.get("allowedRegistriesForImport").add(builder);this.allowedRegistriesForImport.add(builder);} return (A)this;
  }
  public A addAllToAllowedRegistriesForImport(Collection<RegistryLocation> items) {
    if (this.allowedRegistriesForImport == null) {this.allowedRegistriesForImport = new ArrayList<RegistryLocationBuilder>();}
    for (RegistryLocation item : items) {RegistryLocationBuilder builder = new RegistryLocationBuilder(item);_visitables.get("allowedRegistriesForImport").add(builder);this.allowedRegistriesForImport.add(builder);} return (A)this;
  }
  public A removeFromAllowedRegistriesForImport(io.fabric8.openshift.api.model.config.v1.RegistryLocation... items) {
    for (RegistryLocation item : items) {RegistryLocationBuilder builder = new RegistryLocationBuilder(item);_visitables.get("allowedRegistriesForImport").remove(builder);if (this.allowedRegistriesForImport != null) {this.allowedRegistriesForImport.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllowedRegistriesForImport(Collection<RegistryLocation> items) {
    for (RegistryLocation item : items) {RegistryLocationBuilder builder = new RegistryLocationBuilder(item);_visitables.get("allowedRegistriesForImport").remove(builder);if (this.allowedRegistriesForImport != null) {this.allowedRegistriesForImport.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
    if (allowedRegistriesForImport == null) return (A) this;
    final Iterator<RegistryLocationBuilder> each = allowedRegistriesForImport.iterator();
    final List visitables = _visitables.get("allowedRegistriesForImport");
    while (each.hasNext()) {
      RegistryLocationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllowedRegistriesForImport instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RegistryLocation> getAllowedRegistriesForImport() {
    return allowedRegistriesForImport != null ? build(allowedRegistriesForImport) : null;
  }
  public List<RegistryLocation> buildAllowedRegistriesForImport() {
    return allowedRegistriesForImport != null ? build(allowedRegistriesForImport) : null;
  }
  public RegistryLocation buildAllowedRegistriesForImport(Integer index) {
    return this.allowedRegistriesForImport.get(index).build();
  }
  public RegistryLocation buildFirstAllowedRegistriesForImport() {
    return this.allowedRegistriesForImport.get(0).build();
  }
  public RegistryLocation buildLastAllowedRegistriesForImport() {
    return this.allowedRegistriesForImport.get(allowedRegistriesForImport.size() - 1).build();
  }
  public RegistryLocation buildMatchingAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
    for (RegistryLocationBuilder item: allowedRegistriesForImport) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
    for (RegistryLocationBuilder item: allowedRegistriesForImport) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedRegistriesForImport(List<RegistryLocation> allowedRegistriesForImport) {
    if (this.allowedRegistriesForImport != null) { _visitables.get("allowedRegistriesForImport").removeAll(this.allowedRegistriesForImport);}
    if (allowedRegistriesForImport != null) {this.allowedRegistriesForImport = new ArrayList(); for (RegistryLocation item : allowedRegistriesForImport){this.addToAllowedRegistriesForImport(item);}} else { this.allowedRegistriesForImport = null;} return (A) this;
  }
  public A withAllowedRegistriesForImport(io.fabric8.openshift.api.model.config.v1.RegistryLocation... allowedRegistriesForImport) {
    if (this.allowedRegistriesForImport != null) {this.allowedRegistriesForImport.clear();}
    if (allowedRegistriesForImport != null) {for (RegistryLocation item :allowedRegistriesForImport){ this.addToAllowedRegistriesForImport(item);}} return (A) this;
  }
  public Boolean hasAllowedRegistriesForImport() {
    return allowedRegistriesForImport != null && !allowedRegistriesForImport.isEmpty();
  }
  public A addNewAllowedRegistriesForImport(String domainName,Boolean insecure) {
    return (A)addToAllowedRegistriesForImport(new RegistryLocation(domainName, insecure));
  }
  public ImageSpecFluent.AllowedRegistriesForImportNested<A> addNewAllowedRegistriesForImport() {
    return new ImageSpecFluentImpl.AllowedRegistriesForImportNestedImpl();
  }
  public ImageSpecFluent.AllowedRegistriesForImportNested<A> addNewAllowedRegistriesForImportLike(RegistryLocation item) {
    return new ImageSpecFluentImpl.AllowedRegistriesForImportNestedImpl(-1, item);
  }
  public ImageSpecFluent.AllowedRegistriesForImportNested<A> setNewAllowedRegistriesForImportLike(Integer index,RegistryLocation item) {
    return new ImageSpecFluentImpl.AllowedRegistriesForImportNestedImpl(index, item);
  }
  public ImageSpecFluent.AllowedRegistriesForImportNested<A> editAllowedRegistriesForImport(Integer index) {
    if (allowedRegistriesForImport.size() <= index) throw new RuntimeException("Can't edit allowedRegistriesForImport. Index exceeds size.");
    return setNewAllowedRegistriesForImportLike(index, buildAllowedRegistriesForImport(index));
  }
  public ImageSpecFluent.AllowedRegistriesForImportNested<A> editFirstAllowedRegistriesForImport() {
    if (allowedRegistriesForImport.size() == 0) throw new RuntimeException("Can't edit first allowedRegistriesForImport. The list is empty.");
    return setNewAllowedRegistriesForImportLike(0, buildAllowedRegistriesForImport(0));
  }
  public ImageSpecFluent.AllowedRegistriesForImportNested<A> editLastAllowedRegistriesForImport() {
    int index = allowedRegistriesForImport.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allowedRegistriesForImport. The list is empty.");
    return setNewAllowedRegistriesForImportLike(index, buildAllowedRegistriesForImport(index));
  }
  public ImageSpecFluent.AllowedRegistriesForImportNested<A> editMatchingAllowedRegistriesForImport(Predicate<RegistryLocationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allowedRegistriesForImport.size();i++) { 
    if (predicate.test(allowedRegistriesForImport.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allowedRegistriesForImport. No match found.");
    return setNewAllowedRegistriesForImportLike(index, buildAllowedRegistriesForImport(index));
  }
  public A addToExternalRegistryHostnames(Integer index,String item) {
    if (this.externalRegistryHostnames == null) {this.externalRegistryHostnames = new ArrayList<String>();}
    this.externalRegistryHostnames.add(index, item);
    return (A)this;
  }
  public A setToExternalRegistryHostnames(Integer index,String item) {
    if (this.externalRegistryHostnames == null) {this.externalRegistryHostnames = new ArrayList<String>();}
    this.externalRegistryHostnames.set(index, item); return (A)this;
  }
  public A addToExternalRegistryHostnames(java.lang.String... items) {
    if (this.externalRegistryHostnames == null) {this.externalRegistryHostnames = new ArrayList<String>();}
    for (String item : items) {this.externalRegistryHostnames.add(item);} return (A)this;
  }
  public A addAllToExternalRegistryHostnames(Collection<String> items) {
    if (this.externalRegistryHostnames == null) {this.externalRegistryHostnames = new ArrayList<String>();}
    for (String item : items) {this.externalRegistryHostnames.add(item);} return (A)this;
  }
  public A removeFromExternalRegistryHostnames(java.lang.String... items) {
    for (String item : items) {if (this.externalRegistryHostnames!= null){ this.externalRegistryHostnames.remove(item);}} return (A)this;
  }
  public A removeAllFromExternalRegistryHostnames(Collection<String> items) {
    for (String item : items) {if (this.externalRegistryHostnames!= null){ this.externalRegistryHostnames.remove(item);}} return (A)this;
  }
  public List<String> getExternalRegistryHostnames() {
    return this.externalRegistryHostnames;
  }
  public String getExternalRegistryHostname(Integer index) {
    return this.externalRegistryHostnames.get(index);
  }
  public String getFirstExternalRegistryHostname() {
    return this.externalRegistryHostnames.get(0);
  }
  public String getLastExternalRegistryHostname() {
    return this.externalRegistryHostnames.get(externalRegistryHostnames.size() - 1);
  }
  public String getMatchingExternalRegistryHostname(Predicate<String> predicate) {
    for (String item: externalRegistryHostnames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExternalRegistryHostname(Predicate<String> predicate) {
    for (String item: externalRegistryHostnames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExternalRegistryHostnames(List<String> externalRegistryHostnames) {
    if (externalRegistryHostnames != null) {this.externalRegistryHostnames = new ArrayList(); for (String item : externalRegistryHostnames){this.addToExternalRegistryHostnames(item);}} else { this.externalRegistryHostnames = null;} return (A) this;
  }
  public A withExternalRegistryHostnames(java.lang.String... externalRegistryHostnames) {
    if (this.externalRegistryHostnames != null) {this.externalRegistryHostnames.clear();}
    if (externalRegistryHostnames != null) {for (String item :externalRegistryHostnames){ this.addToExternalRegistryHostnames(item);}} return (A) this;
  }
  public Boolean hasExternalRegistryHostnames() {
    return externalRegistryHostnames != null && !externalRegistryHostnames.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildRegistrySources instead.
   * @return The buildable object.
   */
  @Deprecated
  public RegistrySources getRegistrySources() {
    return this.registrySources!=null ?this.registrySources.build():null;
  }
  public RegistrySources buildRegistrySources() {
    return this.registrySources!=null ?this.registrySources.build():null;
  }
  public A withRegistrySources(RegistrySources registrySources) {
    _visitables.get("registrySources").remove(this.registrySources);
    if (registrySources!=null){ this.registrySources= new RegistrySourcesBuilder(registrySources); _visitables.get("registrySources").add(this.registrySources);} else { this.registrySources = null; _visitables.get("registrySources").remove(this.registrySources); } return (A) this;
  }
  public Boolean hasRegistrySources() {
    return this.registrySources != null;
  }
  public ImageSpecFluent.RegistrySourcesNested<A> withNewRegistrySources() {
    return new ImageSpecFluentImpl.RegistrySourcesNestedImpl();
  }
  public ImageSpecFluent.RegistrySourcesNested<A> withNewRegistrySourcesLike(RegistrySources item) {
    return new ImageSpecFluentImpl.RegistrySourcesNestedImpl(item);
  }
  public ImageSpecFluent.RegistrySourcesNested<A> editRegistrySources() {
    return withNewRegistrySourcesLike(getRegistrySources());
  }
  public ImageSpecFluent.RegistrySourcesNested<A> editOrNewRegistrySources() {
    return withNewRegistrySourcesLike(getRegistrySources() != null ? getRegistrySources(): new RegistrySourcesBuilder().build());
  }
  public ImageSpecFluent.RegistrySourcesNested<A> editOrNewRegistrySourcesLike(RegistrySources item) {
    return withNewRegistrySourcesLike(getRegistrySources() != null ? getRegistrySources(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageSpecFluentImpl that = (ImageSpecFluentImpl) o;
    if (additionalTrustedCA != null ? !additionalTrustedCA.equals(that.additionalTrustedCA) :that.additionalTrustedCA != null) return false;
    if (allowedRegistriesForImport != null ? !allowedRegistriesForImport.equals(that.allowedRegistriesForImport) :that.allowedRegistriesForImport != null) return false;
    if (externalRegistryHostnames != null ? !externalRegistryHostnames.equals(that.externalRegistryHostnames) :that.externalRegistryHostnames != null) return false;
    if (registrySources != null ? !registrySources.equals(that.registrySources) :that.registrySources != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalTrustedCA,  allowedRegistriesForImport,  externalRegistryHostnames,  registrySources,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalTrustedCA != null) { sb.append("additionalTrustedCA:"); sb.append(additionalTrustedCA + ","); }
    if (allowedRegistriesForImport != null && !allowedRegistriesForImport.isEmpty()) { sb.append("allowedRegistriesForImport:"); sb.append(allowedRegistriesForImport + ","); }
    if (externalRegistryHostnames != null && !externalRegistryHostnames.isEmpty()) { sb.append("externalRegistryHostnames:"); sb.append(externalRegistryHostnames + ","); }
    if (registrySources != null) { sb.append("registrySources:"); sb.append(registrySources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AdditionalTrustedCANestedImpl<N> extends ConfigMapNameReferenceFluentImpl<ImageSpecFluent.AdditionalTrustedCANested<N>> implements ImageSpecFluent.AdditionalTrustedCANested<N>,Nested<N>{
    AdditionalTrustedCANestedImpl(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    AdditionalTrustedCANestedImpl() {
      this.builder = new ConfigMapNameReferenceBuilder(this);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) ImageSpecFluentImpl.this.withAdditionalTrustedCA(builder.build());
    }
    public N endAdditionalTrustedCA() {
      return and();
    }
    
  }
  class AllowedRegistriesForImportNestedImpl<N> extends RegistryLocationFluentImpl<ImageSpecFluent.AllowedRegistriesForImportNested<N>> implements ImageSpecFluent.AllowedRegistriesForImportNested<N>,Nested<N>{
    AllowedRegistriesForImportNestedImpl(Integer index,RegistryLocation item) {
      this.index = index;
      this.builder = new RegistryLocationBuilder(this, item);
    }
    AllowedRegistriesForImportNestedImpl() {
      this.index = -1;
      this.builder = new RegistryLocationBuilder(this);
    }
    RegistryLocationBuilder builder;
    Integer index;
    public N and() {
      return (N) ImageSpecFluentImpl.this.setToAllowedRegistriesForImport(index,builder.build());
    }
    public N endAllowedRegistriesForImport() {
      return and();
    }
    
  }
  class RegistrySourcesNestedImpl<N> extends RegistrySourcesFluentImpl<ImageSpecFluent.RegistrySourcesNested<N>> implements ImageSpecFluent.RegistrySourcesNested<N>,Nested<N>{
    RegistrySourcesNestedImpl(RegistrySources item) {
      this.builder = new RegistrySourcesBuilder(this, item);
    }
    RegistrySourcesNestedImpl() {
      this.builder = new RegistrySourcesBuilder(this);
    }
    RegistrySourcesBuilder builder;
    public N and() {
      return (N) ImageSpecFluentImpl.this.withRegistrySources(builder.build());
    }
    public N endRegistrySources() {
      return and();
    }
    
  }
  
}