package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IntermediateTLSProfileBuilder extends IntermediateTLSProfileFluentImpl<IntermediateTLSProfileBuilder> implements VisitableBuilder<IntermediateTLSProfile,IntermediateTLSProfileBuilder>{
  public IntermediateTLSProfileBuilder() {
    this(false);
  }
  public IntermediateTLSProfileBuilder(Boolean validationEnabled) {
    this(new IntermediateTLSProfile(), validationEnabled);
  }
  public IntermediateTLSProfileBuilder(IntermediateTLSProfileFluent<?> fluent) {
    this(fluent, false);
  }
  public IntermediateTLSProfileBuilder(IntermediateTLSProfileFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IntermediateTLSProfile(), validationEnabled);
  }
  public IntermediateTLSProfileBuilder(IntermediateTLSProfileFluent<?> fluent,IntermediateTLSProfile instance) {
    this(fluent, instance, false);
  }
  public IntermediateTLSProfileBuilder(IntermediateTLSProfileFluent<?> fluent,IntermediateTLSProfile instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IntermediateTLSProfileBuilder(IntermediateTLSProfile instance) {
    this(instance,false);
  }
  public IntermediateTLSProfileBuilder(IntermediateTLSProfile instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IntermediateTLSProfileFluent<?> fluent;
  Boolean validationEnabled;
  public IntermediateTLSProfile build() {
    IntermediateTLSProfile buildable = new IntermediateTLSProfile();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}