package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenStackPlatformSpecBuilder extends OpenStackPlatformSpecFluentImpl<OpenStackPlatformSpecBuilder> implements VisitableBuilder<OpenStackPlatformSpec,OpenStackPlatformSpecBuilder>{
  public OpenStackPlatformSpecBuilder() {
    this(false);
  }
  public OpenStackPlatformSpecBuilder(Boolean validationEnabled) {
    this(new OpenStackPlatformSpec(), validationEnabled);
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenStackPlatformSpec(), validationEnabled);
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent,OpenStackPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent,OpenStackPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpec instance) {
    this(instance,false);
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OpenStackPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public OpenStackPlatformSpec build() {
    OpenStackPlatformSpec buildable = new OpenStackPlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}