package io.fabric8.openshift.api.model.config.v1;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IdentityProviderFluentImpl<A extends IdentityProviderFluent<A>> extends BaseFluent<A> implements IdentityProviderFluent<A>{
  public IdentityProviderFluentImpl() {
  }
  public IdentityProviderFluentImpl(IdentityProvider instance) {
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withGithub(instance.getGithub()); 
    this.withGitlab(instance.getGitlab()); 
    this.withGoogle(instance.getGoogle()); 
    this.withHtpasswd(instance.getHtpasswd()); 
    this.withKeystone(instance.getKeystone()); 
    this.withLdap(instance.getLdap()); 
    this.withMappingMethod(instance.getMappingMethod()); 
    this.withName(instance.getName()); 
    this.withOpenID(instance.getOpenID()); 
    this.withRequestHeader(instance.getRequestHeader()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private BasicAuthIdentityProviderBuilder basicAuth;
  private GitHubIdentityProviderBuilder github;
  private GitLabIdentityProviderBuilder gitlab;
  private GoogleIdentityProviderBuilder google;
  private HTPasswdIdentityProviderBuilder htpasswd;
  private KeystoneIdentityProviderBuilder keystone;
  private LDAPIdentityProviderBuilder ldap;
  private String mappingMethod;
  private String name;
  private OpenIDIdentityProviderBuilder openID;
  private RequestHeaderIdentityProviderBuilder requestHeader;
  private String type;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @Deprecated
  public BasicAuthIdentityProvider getBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public BasicAuthIdentityProvider buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(BasicAuthIdentityProvider basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new BasicAuthIdentityProviderBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} else { this.basicAuth = null; _visitables.get("basicAuth").remove(this.basicAuth); } return (A) this;
  }
  public Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public IdentityProviderFluent.BasicAuthNested<A> withNewBasicAuth() {
    return new IdentityProviderFluentImpl.BasicAuthNestedImpl();
  }
  public IdentityProviderFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuthIdentityProvider item) {
    return new IdentityProviderFluentImpl.BasicAuthNestedImpl(item);
  }
  public IdentityProviderFluent.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public IdentityProviderFluent.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new BasicAuthIdentityProviderBuilder().build());
  }
  public IdentityProviderFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuthIdentityProvider item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGithub instead.
   * @return The buildable object.
   */
  @Deprecated
  public GitHubIdentityProvider getGithub() {
    return this.github!=null ?this.github.build():null;
  }
  public GitHubIdentityProvider buildGithub() {
    return this.github!=null ?this.github.build():null;
  }
  public A withGithub(GitHubIdentityProvider github) {
    _visitables.get("github").remove(this.github);
    if (github!=null){ this.github= new GitHubIdentityProviderBuilder(github); _visitables.get("github").add(this.github);} else { this.github = null; _visitables.get("github").remove(this.github); } return (A) this;
  }
  public Boolean hasGithub() {
    return this.github != null;
  }
  public IdentityProviderFluent.GithubNested<A> withNewGithub() {
    return new IdentityProviderFluentImpl.GithubNestedImpl();
  }
  public IdentityProviderFluent.GithubNested<A> withNewGithubLike(GitHubIdentityProvider item) {
    return new IdentityProviderFluentImpl.GithubNestedImpl(item);
  }
  public IdentityProviderFluent.GithubNested<A> editGithub() {
    return withNewGithubLike(getGithub());
  }
  public IdentityProviderFluent.GithubNested<A> editOrNewGithub() {
    return withNewGithubLike(getGithub() != null ? getGithub(): new GitHubIdentityProviderBuilder().build());
  }
  public IdentityProviderFluent.GithubNested<A> editOrNewGithubLike(GitHubIdentityProvider item) {
    return withNewGithubLike(getGithub() != null ? getGithub(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGitlab instead.
   * @return The buildable object.
   */
  @Deprecated
  public GitLabIdentityProvider getGitlab() {
    return this.gitlab!=null ?this.gitlab.build():null;
  }
  public GitLabIdentityProvider buildGitlab() {
    return this.gitlab!=null ?this.gitlab.build():null;
  }
  public A withGitlab(GitLabIdentityProvider gitlab) {
    _visitables.get("gitlab").remove(this.gitlab);
    if (gitlab!=null){ this.gitlab= new GitLabIdentityProviderBuilder(gitlab); _visitables.get("gitlab").add(this.gitlab);} else { this.gitlab = null; _visitables.get("gitlab").remove(this.gitlab); } return (A) this;
  }
  public Boolean hasGitlab() {
    return this.gitlab != null;
  }
  public IdentityProviderFluent.GitlabNested<A> withNewGitlab() {
    return new IdentityProviderFluentImpl.GitlabNestedImpl();
  }
  public IdentityProviderFluent.GitlabNested<A> withNewGitlabLike(GitLabIdentityProvider item) {
    return new IdentityProviderFluentImpl.GitlabNestedImpl(item);
  }
  public IdentityProviderFluent.GitlabNested<A> editGitlab() {
    return withNewGitlabLike(getGitlab());
  }
  public IdentityProviderFluent.GitlabNested<A> editOrNewGitlab() {
    return withNewGitlabLike(getGitlab() != null ? getGitlab(): new GitLabIdentityProviderBuilder().build());
  }
  public IdentityProviderFluent.GitlabNested<A> editOrNewGitlabLike(GitLabIdentityProvider item) {
    return withNewGitlabLike(getGitlab() != null ? getGitlab(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGoogle instead.
   * @return The buildable object.
   */
  @Deprecated
  public GoogleIdentityProvider getGoogle() {
    return this.google!=null ?this.google.build():null;
  }
  public GoogleIdentityProvider buildGoogle() {
    return this.google!=null ?this.google.build():null;
  }
  public A withGoogle(GoogleIdentityProvider google) {
    _visitables.get("google").remove(this.google);
    if (google!=null){ this.google= new GoogleIdentityProviderBuilder(google); _visitables.get("google").add(this.google);} else { this.google = null; _visitables.get("google").remove(this.google); } return (A) this;
  }
  public Boolean hasGoogle() {
    return this.google != null;
  }
  public IdentityProviderFluent.GoogleNested<A> withNewGoogle() {
    return new IdentityProviderFluentImpl.GoogleNestedImpl();
  }
  public IdentityProviderFluent.GoogleNested<A> withNewGoogleLike(GoogleIdentityProvider item) {
    return new IdentityProviderFluentImpl.GoogleNestedImpl(item);
  }
  public IdentityProviderFluent.GoogleNested<A> editGoogle() {
    return withNewGoogleLike(getGoogle());
  }
  public IdentityProviderFluent.GoogleNested<A> editOrNewGoogle() {
    return withNewGoogleLike(getGoogle() != null ? getGoogle(): new GoogleIdentityProviderBuilder().build());
  }
  public IdentityProviderFluent.GoogleNested<A> editOrNewGoogleLike(GoogleIdentityProvider item) {
    return withNewGoogleLike(getGoogle() != null ? getGoogle(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHtpasswd instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTPasswdIdentityProvider getHtpasswd() {
    return this.htpasswd!=null ?this.htpasswd.build():null;
  }
  public HTPasswdIdentityProvider buildHtpasswd() {
    return this.htpasswd!=null ?this.htpasswd.build():null;
  }
  public A withHtpasswd(HTPasswdIdentityProvider htpasswd) {
    _visitables.get("htpasswd").remove(this.htpasswd);
    if (htpasswd!=null){ this.htpasswd= new HTPasswdIdentityProviderBuilder(htpasswd); _visitables.get("htpasswd").add(this.htpasswd);} else { this.htpasswd = null; _visitables.get("htpasswd").remove(this.htpasswd); } return (A) this;
  }
  public Boolean hasHtpasswd() {
    return this.htpasswd != null;
  }
  public IdentityProviderFluent.HtpasswdNested<A> withNewHtpasswd() {
    return new IdentityProviderFluentImpl.HtpasswdNestedImpl();
  }
  public IdentityProviderFluent.HtpasswdNested<A> withNewHtpasswdLike(HTPasswdIdentityProvider item) {
    return new IdentityProviderFluentImpl.HtpasswdNestedImpl(item);
  }
  public IdentityProviderFluent.HtpasswdNested<A> editHtpasswd() {
    return withNewHtpasswdLike(getHtpasswd());
  }
  public IdentityProviderFluent.HtpasswdNested<A> editOrNewHtpasswd() {
    return withNewHtpasswdLike(getHtpasswd() != null ? getHtpasswd(): new HTPasswdIdentityProviderBuilder().build());
  }
  public IdentityProviderFluent.HtpasswdNested<A> editOrNewHtpasswdLike(HTPasswdIdentityProvider item) {
    return withNewHtpasswdLike(getHtpasswd() != null ? getHtpasswd(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKeystone instead.
   * @return The buildable object.
   */
  @Deprecated
  public KeystoneIdentityProvider getKeystone() {
    return this.keystone!=null ?this.keystone.build():null;
  }
  public KeystoneIdentityProvider buildKeystone() {
    return this.keystone!=null ?this.keystone.build():null;
  }
  public A withKeystone(KeystoneIdentityProvider keystone) {
    _visitables.get("keystone").remove(this.keystone);
    if (keystone!=null){ this.keystone= new KeystoneIdentityProviderBuilder(keystone); _visitables.get("keystone").add(this.keystone);} else { this.keystone = null; _visitables.get("keystone").remove(this.keystone); } return (A) this;
  }
  public Boolean hasKeystone() {
    return this.keystone != null;
  }
  public IdentityProviderFluent.KeystoneNested<A> withNewKeystone() {
    return new IdentityProviderFluentImpl.KeystoneNestedImpl();
  }
  public IdentityProviderFluent.KeystoneNested<A> withNewKeystoneLike(KeystoneIdentityProvider item) {
    return new IdentityProviderFluentImpl.KeystoneNestedImpl(item);
  }
  public IdentityProviderFluent.KeystoneNested<A> editKeystone() {
    return withNewKeystoneLike(getKeystone());
  }
  public IdentityProviderFluent.KeystoneNested<A> editOrNewKeystone() {
    return withNewKeystoneLike(getKeystone() != null ? getKeystone(): new KeystoneIdentityProviderBuilder().build());
  }
  public IdentityProviderFluent.KeystoneNested<A> editOrNewKeystoneLike(KeystoneIdentityProvider item) {
    return withNewKeystoneLike(getKeystone() != null ? getKeystone(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLdap instead.
   * @return The buildable object.
   */
  @Deprecated
  public LDAPIdentityProvider getLdap() {
    return this.ldap!=null ?this.ldap.build():null;
  }
  public LDAPIdentityProvider buildLdap() {
    return this.ldap!=null ?this.ldap.build():null;
  }
  public A withLdap(LDAPIdentityProvider ldap) {
    _visitables.get("ldap").remove(this.ldap);
    if (ldap!=null){ this.ldap= new LDAPIdentityProviderBuilder(ldap); _visitables.get("ldap").add(this.ldap);} else { this.ldap = null; _visitables.get("ldap").remove(this.ldap); } return (A) this;
  }
  public Boolean hasLdap() {
    return this.ldap != null;
  }
  public IdentityProviderFluent.LdapNested<A> withNewLdap() {
    return new IdentityProviderFluentImpl.LdapNestedImpl();
  }
  public IdentityProviderFluent.LdapNested<A> withNewLdapLike(LDAPIdentityProvider item) {
    return new IdentityProviderFluentImpl.LdapNestedImpl(item);
  }
  public IdentityProviderFluent.LdapNested<A> editLdap() {
    return withNewLdapLike(getLdap());
  }
  public IdentityProviderFluent.LdapNested<A> editOrNewLdap() {
    return withNewLdapLike(getLdap() != null ? getLdap(): new LDAPIdentityProviderBuilder().build());
  }
  public IdentityProviderFluent.LdapNested<A> editOrNewLdapLike(LDAPIdentityProvider item) {
    return withNewLdapLike(getLdap() != null ? getLdap(): item);
  }
  public String getMappingMethod() {
    return this.mappingMethod;
  }
  public A withMappingMethod(String mappingMethod) {
    this.mappingMethod=mappingMethod; return (A) this;
  }
  public Boolean hasMappingMethod() {
    return this.mappingMethod != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOpenID instead.
   * @return The buildable object.
   */
  @Deprecated
  public OpenIDIdentityProvider getOpenID() {
    return this.openID!=null ?this.openID.build():null;
  }
  public OpenIDIdentityProvider buildOpenID() {
    return this.openID!=null ?this.openID.build():null;
  }
  public A withOpenID(OpenIDIdentityProvider openID) {
    _visitables.get("openID").remove(this.openID);
    if (openID!=null){ this.openID= new OpenIDIdentityProviderBuilder(openID); _visitables.get("openID").add(this.openID);} else { this.openID = null; _visitables.get("openID").remove(this.openID); } return (A) this;
  }
  public Boolean hasOpenID() {
    return this.openID != null;
  }
  public IdentityProviderFluent.OpenIDNested<A> withNewOpenID() {
    return new IdentityProviderFluentImpl.OpenIDNestedImpl();
  }
  public IdentityProviderFluent.OpenIDNested<A> withNewOpenIDLike(OpenIDIdentityProvider item) {
    return new IdentityProviderFluentImpl.OpenIDNestedImpl(item);
  }
  public IdentityProviderFluent.OpenIDNested<A> editOpenID() {
    return withNewOpenIDLike(getOpenID());
  }
  public IdentityProviderFluent.OpenIDNested<A> editOrNewOpenID() {
    return withNewOpenIDLike(getOpenID() != null ? getOpenID(): new OpenIDIdentityProviderBuilder().build());
  }
  public IdentityProviderFluent.OpenIDNested<A> editOrNewOpenIDLike(OpenIDIdentityProvider item) {
    return withNewOpenIDLike(getOpenID() != null ? getOpenID(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRequestHeader instead.
   * @return The buildable object.
   */
  @Deprecated
  public RequestHeaderIdentityProvider getRequestHeader() {
    return this.requestHeader!=null ?this.requestHeader.build():null;
  }
  public RequestHeaderIdentityProvider buildRequestHeader() {
    return this.requestHeader!=null ?this.requestHeader.build():null;
  }
  public A withRequestHeader(RequestHeaderIdentityProvider requestHeader) {
    _visitables.get("requestHeader").remove(this.requestHeader);
    if (requestHeader!=null){ this.requestHeader= new RequestHeaderIdentityProviderBuilder(requestHeader); _visitables.get("requestHeader").add(this.requestHeader);} else { this.requestHeader = null; _visitables.get("requestHeader").remove(this.requestHeader); } return (A) this;
  }
  public Boolean hasRequestHeader() {
    return this.requestHeader != null;
  }
  public IdentityProviderFluent.RequestHeaderNested<A> withNewRequestHeader() {
    return new IdentityProviderFluentImpl.RequestHeaderNestedImpl();
  }
  public IdentityProviderFluent.RequestHeaderNested<A> withNewRequestHeaderLike(RequestHeaderIdentityProvider item) {
    return new IdentityProviderFluentImpl.RequestHeaderNestedImpl(item);
  }
  public IdentityProviderFluent.RequestHeaderNested<A> editRequestHeader() {
    return withNewRequestHeaderLike(getRequestHeader());
  }
  public IdentityProviderFluent.RequestHeaderNested<A> editOrNewRequestHeader() {
    return withNewRequestHeaderLike(getRequestHeader() != null ? getRequestHeader(): new RequestHeaderIdentityProviderBuilder().build());
  }
  public IdentityProviderFluent.RequestHeaderNested<A> editOrNewRequestHeaderLike(RequestHeaderIdentityProvider item) {
    return withNewRequestHeaderLike(getRequestHeader() != null ? getRequestHeader(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IdentityProviderFluentImpl that = (IdentityProviderFluentImpl) o;
    if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
    if (github != null ? !github.equals(that.github) :that.github != null) return false;
    if (gitlab != null ? !gitlab.equals(that.gitlab) :that.gitlab != null) return false;
    if (google != null ? !google.equals(that.google) :that.google != null) return false;
    if (htpasswd != null ? !htpasswd.equals(that.htpasswd) :that.htpasswd != null) return false;
    if (keystone != null ? !keystone.equals(that.keystone) :that.keystone != null) return false;
    if (ldap != null ? !ldap.equals(that.ldap) :that.ldap != null) return false;
    if (mappingMethod != null ? !mappingMethod.equals(that.mappingMethod) :that.mappingMethod != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (openID != null ? !openID.equals(that.openID) :that.openID != null) return false;
    if (requestHeader != null ? !requestHeader.equals(that.requestHeader) :that.requestHeader != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(basicAuth,  github,  gitlab,  google,  htpasswd,  keystone,  ldap,  mappingMethod,  name,  openID,  requestHeader,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (github != null) { sb.append("github:"); sb.append(github + ","); }
    if (gitlab != null) { sb.append("gitlab:"); sb.append(gitlab + ","); }
    if (google != null) { sb.append("google:"); sb.append(google + ","); }
    if (htpasswd != null) { sb.append("htpasswd:"); sb.append(htpasswd + ","); }
    if (keystone != null) { sb.append("keystone:"); sb.append(keystone + ","); }
    if (ldap != null) { sb.append("ldap:"); sb.append(ldap + ","); }
    if (mappingMethod != null) { sb.append("mappingMethod:"); sb.append(mappingMethod + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (openID != null) { sb.append("openID:"); sb.append(openID + ","); }
    if (requestHeader != null) { sb.append("requestHeader:"); sb.append(requestHeader + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BasicAuthNestedImpl<N> extends BasicAuthIdentityProviderFluentImpl<IdentityProviderFluent.BasicAuthNested<N>> implements IdentityProviderFluent.BasicAuthNested<N>,Nested<N>{
    BasicAuthNestedImpl(BasicAuthIdentityProvider item) {
      this.builder = new BasicAuthIdentityProviderBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new BasicAuthIdentityProviderBuilder(this);
    }
    BasicAuthIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  class GithubNestedImpl<N> extends GitHubIdentityProviderFluentImpl<IdentityProviderFluent.GithubNested<N>> implements IdentityProviderFluent.GithubNested<N>,Nested<N>{
    GithubNestedImpl(GitHubIdentityProvider item) {
      this.builder = new GitHubIdentityProviderBuilder(this, item);
    }
    GithubNestedImpl() {
      this.builder = new GitHubIdentityProviderBuilder(this);
    }
    GitHubIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withGithub(builder.build());
    }
    public N endGithub() {
      return and();
    }
    
  }
  class GitlabNestedImpl<N> extends GitLabIdentityProviderFluentImpl<IdentityProviderFluent.GitlabNested<N>> implements IdentityProviderFluent.GitlabNested<N>,Nested<N>{
    GitlabNestedImpl(GitLabIdentityProvider item) {
      this.builder = new GitLabIdentityProviderBuilder(this, item);
    }
    GitlabNestedImpl() {
      this.builder = new GitLabIdentityProviderBuilder(this);
    }
    GitLabIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withGitlab(builder.build());
    }
    public N endGitlab() {
      return and();
    }
    
  }
  class GoogleNestedImpl<N> extends GoogleIdentityProviderFluentImpl<IdentityProviderFluent.GoogleNested<N>> implements IdentityProviderFluent.GoogleNested<N>,Nested<N>{
    GoogleNestedImpl(GoogleIdentityProvider item) {
      this.builder = new GoogleIdentityProviderBuilder(this, item);
    }
    GoogleNestedImpl() {
      this.builder = new GoogleIdentityProviderBuilder(this);
    }
    GoogleIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withGoogle(builder.build());
    }
    public N endGoogle() {
      return and();
    }
    
  }
  class HtpasswdNestedImpl<N> extends HTPasswdIdentityProviderFluentImpl<IdentityProviderFluent.HtpasswdNested<N>> implements IdentityProviderFluent.HtpasswdNested<N>,Nested<N>{
    HtpasswdNestedImpl(HTPasswdIdentityProvider item) {
      this.builder = new HTPasswdIdentityProviderBuilder(this, item);
    }
    HtpasswdNestedImpl() {
      this.builder = new HTPasswdIdentityProviderBuilder(this);
    }
    HTPasswdIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withHtpasswd(builder.build());
    }
    public N endHtpasswd() {
      return and();
    }
    
  }
  class KeystoneNestedImpl<N> extends KeystoneIdentityProviderFluentImpl<IdentityProviderFluent.KeystoneNested<N>> implements IdentityProviderFluent.KeystoneNested<N>,Nested<N>{
    KeystoneNestedImpl(KeystoneIdentityProvider item) {
      this.builder = new KeystoneIdentityProviderBuilder(this, item);
    }
    KeystoneNestedImpl() {
      this.builder = new KeystoneIdentityProviderBuilder(this);
    }
    KeystoneIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withKeystone(builder.build());
    }
    public N endKeystone() {
      return and();
    }
    
  }
  class LdapNestedImpl<N> extends LDAPIdentityProviderFluentImpl<IdentityProviderFluent.LdapNested<N>> implements IdentityProviderFluent.LdapNested<N>,Nested<N>{
    LdapNestedImpl(LDAPIdentityProvider item) {
      this.builder = new LDAPIdentityProviderBuilder(this, item);
    }
    LdapNestedImpl() {
      this.builder = new LDAPIdentityProviderBuilder(this);
    }
    LDAPIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withLdap(builder.build());
    }
    public N endLdap() {
      return and();
    }
    
  }
  class OpenIDNestedImpl<N> extends OpenIDIdentityProviderFluentImpl<IdentityProviderFluent.OpenIDNested<N>> implements IdentityProviderFluent.OpenIDNested<N>,Nested<N>{
    OpenIDNestedImpl(OpenIDIdentityProvider item) {
      this.builder = new OpenIDIdentityProviderBuilder(this, item);
    }
    OpenIDNestedImpl() {
      this.builder = new OpenIDIdentityProviderBuilder(this);
    }
    OpenIDIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withOpenID(builder.build());
    }
    public N endOpenID() {
      return and();
    }
    
  }
  class RequestHeaderNestedImpl<N> extends RequestHeaderIdentityProviderFluentImpl<IdentityProviderFluent.RequestHeaderNested<N>> implements IdentityProviderFluent.RequestHeaderNested<N>,Nested<N>{
    RequestHeaderNestedImpl(RequestHeaderIdentityProvider item) {
      this.builder = new RequestHeaderIdentityProviderBuilder(this, item);
    }
    RequestHeaderNestedImpl() {
      this.builder = new RequestHeaderIdentityProviderBuilder(this);
    }
    RequestHeaderIdentityProviderBuilder builder;
    public N and() {
      return (N) IdentityProviderFluentImpl.this.withRequestHeader(builder.build());
    }
    public N endRequestHeader() {
      return and();
    }
    
  }
  
}