package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorHubStatusBuilder extends OperatorHubStatusFluentImpl<OperatorHubStatusBuilder> implements VisitableBuilder<OperatorHubStatus,OperatorHubStatusBuilder>{
  public OperatorHubStatusBuilder() {
    this(false);
  }
  public OperatorHubStatusBuilder(Boolean validationEnabled) {
    this(new OperatorHubStatus(), validationEnabled);
  }
  public OperatorHubStatusBuilder(OperatorHubStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorHubStatusBuilder(OperatorHubStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorHubStatus(), validationEnabled);
  }
  public OperatorHubStatusBuilder(OperatorHubStatusFluent<?> fluent,OperatorHubStatus instance) {
    this(fluent, instance, false);
  }
  public OperatorHubStatusBuilder(OperatorHubStatusFluent<?> fluent,OperatorHubStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSources(instance.getSources()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperatorHubStatusBuilder(OperatorHubStatus instance) {
    this(instance,false);
  }
  public OperatorHubStatusBuilder(OperatorHubStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSources(instance.getSources()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OperatorHubStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorHubStatus build() {
    OperatorHubStatus buildable = new OperatorHubStatus(fluent.getSources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}