package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeprecatedWebhookTokenAuthenticatorBuilder extends DeprecatedWebhookTokenAuthenticatorFluentImpl<DeprecatedWebhookTokenAuthenticatorBuilder> implements VisitableBuilder<DeprecatedWebhookTokenAuthenticator,DeprecatedWebhookTokenAuthenticatorBuilder>{
  public DeprecatedWebhookTokenAuthenticatorBuilder() {
    this(false);
  }
  public DeprecatedWebhookTokenAuthenticatorBuilder(Boolean validationEnabled) {
    this(new DeprecatedWebhookTokenAuthenticator(), validationEnabled);
  }
  public DeprecatedWebhookTokenAuthenticatorBuilder(DeprecatedWebhookTokenAuthenticatorFluent<?> fluent) {
    this(fluent, false);
  }
  public DeprecatedWebhookTokenAuthenticatorBuilder(DeprecatedWebhookTokenAuthenticatorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeprecatedWebhookTokenAuthenticator(), validationEnabled);
  }
  public DeprecatedWebhookTokenAuthenticatorBuilder(DeprecatedWebhookTokenAuthenticatorFluent<?> fluent,DeprecatedWebhookTokenAuthenticator instance) {
    this(fluent, instance, false);
  }
  public DeprecatedWebhookTokenAuthenticatorBuilder(DeprecatedWebhookTokenAuthenticatorFluent<?> fluent,DeprecatedWebhookTokenAuthenticator instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKubeConfig(instance.getKubeConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeprecatedWebhookTokenAuthenticatorBuilder(DeprecatedWebhookTokenAuthenticator instance) {
    this(instance,false);
  }
  public DeprecatedWebhookTokenAuthenticatorBuilder(DeprecatedWebhookTokenAuthenticator instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withKubeConfig(instance.getKubeConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  DeprecatedWebhookTokenAuthenticatorFluent<?> fluent;
  Boolean validationEnabled;
  public DeprecatedWebhookTokenAuthenticator build() {
    DeprecatedWebhookTokenAuthenticator buildable = new DeprecatedWebhookTokenAuthenticator(fluent.getKubeConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}