package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OldTLSProfileBuilder extends OldTLSProfileFluentImpl<OldTLSProfileBuilder> implements VisitableBuilder<OldTLSProfile,OldTLSProfileBuilder>{
  public OldTLSProfileBuilder() {
    this(false);
  }
  public OldTLSProfileBuilder(Boolean validationEnabled) {
    this(new OldTLSProfile(), validationEnabled);
  }
  public OldTLSProfileBuilder(OldTLSProfileFluent<?> fluent) {
    this(fluent, false);
  }
  public OldTLSProfileBuilder(OldTLSProfileFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OldTLSProfile(), validationEnabled);
  }
  public OldTLSProfileBuilder(OldTLSProfileFluent<?> fluent,OldTLSProfile instance) {
    this(fluent, instance, false);
  }
  public OldTLSProfileBuilder(OldTLSProfileFluent<?> fluent,OldTLSProfile instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OldTLSProfileBuilder(OldTLSProfile instance) {
    this(instance,false);
  }
  public OldTLSProfileBuilder(OldTLSProfile instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OldTLSProfileFluent<?> fluent;
  Boolean validationEnabled;
  public OldTLSProfile build() {
    OldTLSProfile buildable = new OldTLSProfile();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}