package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RegistrySourcesFluentImpl<A extends RegistrySourcesFluent<A>> extends BaseFluent<A> implements RegistrySourcesFluent<A>{
  public RegistrySourcesFluentImpl() {
  }
  public RegistrySourcesFluentImpl(RegistrySources instance) {
    this.withAllowedRegistries(instance.getAllowedRegistries()); 
    this.withBlockedRegistries(instance.getBlockedRegistries()); 
    this.withContainerRuntimeSearchRegistries(instance.getContainerRuntimeSearchRegistries()); 
    this.withInsecureRegistries(instance.getInsecureRegistries()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> allowedRegistries = new ArrayList<String>();
  private List<String> blockedRegistries = new ArrayList<String>();
  private List<String> containerRuntimeSearchRegistries = new ArrayList<String>();
  private List<String> insecureRegistries = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToAllowedRegistries(Integer index,String item) {
    if (this.allowedRegistries == null) {this.allowedRegistries = new ArrayList<String>();}
    this.allowedRegistries.add(index, item);
    return (A)this;
  }
  public A setToAllowedRegistries(Integer index,String item) {
    if (this.allowedRegistries == null) {this.allowedRegistries = new ArrayList<String>();}
    this.allowedRegistries.set(index, item); return (A)this;
  }
  public A addToAllowedRegistries(java.lang.String... items) {
    if (this.allowedRegistries == null) {this.allowedRegistries = new ArrayList<String>();}
    for (String item : items) {this.allowedRegistries.add(item);} return (A)this;
  }
  public A addAllToAllowedRegistries(Collection<String> items) {
    if (this.allowedRegistries == null) {this.allowedRegistries = new ArrayList<String>();}
    for (String item : items) {this.allowedRegistries.add(item);} return (A)this;
  }
  public A removeFromAllowedRegistries(java.lang.String... items) {
    for (String item : items) {if (this.allowedRegistries!= null){ this.allowedRegistries.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowedRegistries(Collection<String> items) {
    for (String item : items) {if (this.allowedRegistries!= null){ this.allowedRegistries.remove(item);}} return (A)this;
  }
  public List<String> getAllowedRegistries() {
    return this.allowedRegistries;
  }
  public String getAllowedRegistry(Integer index) {
    return this.allowedRegistries.get(index);
  }
  public String getFirstAllowedRegistry() {
    return this.allowedRegistries.get(0);
  }
  public String getLastAllowedRegistry() {
    return this.allowedRegistries.get(allowedRegistries.size() - 1);
  }
  public String getMatchingAllowedRegistry(Predicate<String> predicate) {
    for (String item: allowedRegistries) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAllowedRegistry(Predicate<String> predicate) {
    for (String item: allowedRegistries) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowedRegistries(List<String> allowedRegistries) {
    if (allowedRegistries != null) {this.allowedRegistries = new ArrayList(); for (String item : allowedRegistries){this.addToAllowedRegistries(item);}} else { this.allowedRegistries = null;} return (A) this;
  }
  public A withAllowedRegistries(java.lang.String... allowedRegistries) {
    if (this.allowedRegistries != null) {this.allowedRegistries.clear();}
    if (allowedRegistries != null) {for (String item :allowedRegistries){ this.addToAllowedRegistries(item);}} return (A) this;
  }
  public Boolean hasAllowedRegistries() {
    return allowedRegistries != null && !allowedRegistries.isEmpty();
  }
  public A addToBlockedRegistries(Integer index,String item) {
    if (this.blockedRegistries == null) {this.blockedRegistries = new ArrayList<String>();}
    this.blockedRegistries.add(index, item);
    return (A)this;
  }
  public A setToBlockedRegistries(Integer index,String item) {
    if (this.blockedRegistries == null) {this.blockedRegistries = new ArrayList<String>();}
    this.blockedRegistries.set(index, item); return (A)this;
  }
  public A addToBlockedRegistries(java.lang.String... items) {
    if (this.blockedRegistries == null) {this.blockedRegistries = new ArrayList<String>();}
    for (String item : items) {this.blockedRegistries.add(item);} return (A)this;
  }
  public A addAllToBlockedRegistries(Collection<String> items) {
    if (this.blockedRegistries == null) {this.blockedRegistries = new ArrayList<String>();}
    for (String item : items) {this.blockedRegistries.add(item);} return (A)this;
  }
  public A removeFromBlockedRegistries(java.lang.String... items) {
    for (String item : items) {if (this.blockedRegistries!= null){ this.blockedRegistries.remove(item);}} return (A)this;
  }
  public A removeAllFromBlockedRegistries(Collection<String> items) {
    for (String item : items) {if (this.blockedRegistries!= null){ this.blockedRegistries.remove(item);}} return (A)this;
  }
  public List<String> getBlockedRegistries() {
    return this.blockedRegistries;
  }
  public String getBlockedRegistry(Integer index) {
    return this.blockedRegistries.get(index);
  }
  public String getFirstBlockedRegistry() {
    return this.blockedRegistries.get(0);
  }
  public String getLastBlockedRegistry() {
    return this.blockedRegistries.get(blockedRegistries.size() - 1);
  }
  public String getMatchingBlockedRegistry(Predicate<String> predicate) {
    for (String item: blockedRegistries) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingBlockedRegistry(Predicate<String> predicate) {
    for (String item: blockedRegistries) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBlockedRegistries(List<String> blockedRegistries) {
    if (blockedRegistries != null) {this.blockedRegistries = new ArrayList(); for (String item : blockedRegistries){this.addToBlockedRegistries(item);}} else { this.blockedRegistries = null;} return (A) this;
  }
  public A withBlockedRegistries(java.lang.String... blockedRegistries) {
    if (this.blockedRegistries != null) {this.blockedRegistries.clear();}
    if (blockedRegistries != null) {for (String item :blockedRegistries){ this.addToBlockedRegistries(item);}} return (A) this;
  }
  public Boolean hasBlockedRegistries() {
    return blockedRegistries != null && !blockedRegistries.isEmpty();
  }
  public A addToContainerRuntimeSearchRegistries(Integer index,String item) {
    if (this.containerRuntimeSearchRegistries == null) {this.containerRuntimeSearchRegistries = new ArrayList<String>();}
    this.containerRuntimeSearchRegistries.add(index, item);
    return (A)this;
  }
  public A setToContainerRuntimeSearchRegistries(Integer index,String item) {
    if (this.containerRuntimeSearchRegistries == null) {this.containerRuntimeSearchRegistries = new ArrayList<String>();}
    this.containerRuntimeSearchRegistries.set(index, item); return (A)this;
  }
  public A addToContainerRuntimeSearchRegistries(java.lang.String... items) {
    if (this.containerRuntimeSearchRegistries == null) {this.containerRuntimeSearchRegistries = new ArrayList<String>();}
    for (String item : items) {this.containerRuntimeSearchRegistries.add(item);} return (A)this;
  }
  public A addAllToContainerRuntimeSearchRegistries(Collection<String> items) {
    if (this.containerRuntimeSearchRegistries == null) {this.containerRuntimeSearchRegistries = new ArrayList<String>();}
    for (String item : items) {this.containerRuntimeSearchRegistries.add(item);} return (A)this;
  }
  public A removeFromContainerRuntimeSearchRegistries(java.lang.String... items) {
    for (String item : items) {if (this.containerRuntimeSearchRegistries!= null){ this.containerRuntimeSearchRegistries.remove(item);}} return (A)this;
  }
  public A removeAllFromContainerRuntimeSearchRegistries(Collection<String> items) {
    for (String item : items) {if (this.containerRuntimeSearchRegistries!= null){ this.containerRuntimeSearchRegistries.remove(item);}} return (A)this;
  }
  public List<String> getContainerRuntimeSearchRegistries() {
    return this.containerRuntimeSearchRegistries;
  }
  public String getContainerRuntimeSearchRegistry(Integer index) {
    return this.containerRuntimeSearchRegistries.get(index);
  }
  public String getFirstContainerRuntimeSearchRegistry() {
    return this.containerRuntimeSearchRegistries.get(0);
  }
  public String getLastContainerRuntimeSearchRegistry() {
    return this.containerRuntimeSearchRegistries.get(containerRuntimeSearchRegistries.size() - 1);
  }
  public String getMatchingContainerRuntimeSearchRegistry(Predicate<String> predicate) {
    for (String item: containerRuntimeSearchRegistries) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingContainerRuntimeSearchRegistry(Predicate<String> predicate) {
    for (String item: containerRuntimeSearchRegistries) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerRuntimeSearchRegistries(List<String> containerRuntimeSearchRegistries) {
    if (containerRuntimeSearchRegistries != null) {this.containerRuntimeSearchRegistries = new ArrayList(); for (String item : containerRuntimeSearchRegistries){this.addToContainerRuntimeSearchRegistries(item);}} else { this.containerRuntimeSearchRegistries = null;} return (A) this;
  }
  public A withContainerRuntimeSearchRegistries(java.lang.String... containerRuntimeSearchRegistries) {
    if (this.containerRuntimeSearchRegistries != null) {this.containerRuntimeSearchRegistries.clear();}
    if (containerRuntimeSearchRegistries != null) {for (String item :containerRuntimeSearchRegistries){ this.addToContainerRuntimeSearchRegistries(item);}} return (A) this;
  }
  public Boolean hasContainerRuntimeSearchRegistries() {
    return containerRuntimeSearchRegistries != null && !containerRuntimeSearchRegistries.isEmpty();
  }
  public A addToInsecureRegistries(Integer index,String item) {
    if (this.insecureRegistries == null) {this.insecureRegistries = new ArrayList<String>();}
    this.insecureRegistries.add(index, item);
    return (A)this;
  }
  public A setToInsecureRegistries(Integer index,String item) {
    if (this.insecureRegistries == null) {this.insecureRegistries = new ArrayList<String>();}
    this.insecureRegistries.set(index, item); return (A)this;
  }
  public A addToInsecureRegistries(java.lang.String... items) {
    if (this.insecureRegistries == null) {this.insecureRegistries = new ArrayList<String>();}
    for (String item : items) {this.insecureRegistries.add(item);} return (A)this;
  }
  public A addAllToInsecureRegistries(Collection<String> items) {
    if (this.insecureRegistries == null) {this.insecureRegistries = new ArrayList<String>();}
    for (String item : items) {this.insecureRegistries.add(item);} return (A)this;
  }
  public A removeFromInsecureRegistries(java.lang.String... items) {
    for (String item : items) {if (this.insecureRegistries!= null){ this.insecureRegistries.remove(item);}} return (A)this;
  }
  public A removeAllFromInsecureRegistries(Collection<String> items) {
    for (String item : items) {if (this.insecureRegistries!= null){ this.insecureRegistries.remove(item);}} return (A)this;
  }
  public List<String> getInsecureRegistries() {
    return this.insecureRegistries;
  }
  public String getInsecureRegistry(Integer index) {
    return this.insecureRegistries.get(index);
  }
  public String getFirstInsecureRegistry() {
    return this.insecureRegistries.get(0);
  }
  public String getLastInsecureRegistry() {
    return this.insecureRegistries.get(insecureRegistries.size() - 1);
  }
  public String getMatchingInsecureRegistry(Predicate<String> predicate) {
    for (String item: insecureRegistries) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingInsecureRegistry(Predicate<String> predicate) {
    for (String item: insecureRegistries) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInsecureRegistries(List<String> insecureRegistries) {
    if (insecureRegistries != null) {this.insecureRegistries = new ArrayList(); for (String item : insecureRegistries){this.addToInsecureRegistries(item);}} else { this.insecureRegistries = null;} return (A) this;
  }
  public A withInsecureRegistries(java.lang.String... insecureRegistries) {
    if (this.insecureRegistries != null) {this.insecureRegistries.clear();}
    if (insecureRegistries != null) {for (String item :insecureRegistries){ this.addToInsecureRegistries(item);}} return (A) this;
  }
  public Boolean hasInsecureRegistries() {
    return insecureRegistries != null && !insecureRegistries.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RegistrySourcesFluentImpl that = (RegistrySourcesFluentImpl) o;
    if (allowedRegistries != null ? !allowedRegistries.equals(that.allowedRegistries) :that.allowedRegistries != null) return false;
    if (blockedRegistries != null ? !blockedRegistries.equals(that.blockedRegistries) :that.blockedRegistries != null) return false;
    if (containerRuntimeSearchRegistries != null ? !containerRuntimeSearchRegistries.equals(that.containerRuntimeSearchRegistries) :that.containerRuntimeSearchRegistries != null) return false;
    if (insecureRegistries != null ? !insecureRegistries.equals(that.insecureRegistries) :that.insecureRegistries != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowedRegistries,  blockedRegistries,  containerRuntimeSearchRegistries,  insecureRegistries,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowedRegistries != null && !allowedRegistries.isEmpty()) { sb.append("allowedRegistries:"); sb.append(allowedRegistries + ","); }
    if (blockedRegistries != null && !blockedRegistries.isEmpty()) { sb.append("blockedRegistries:"); sb.append(blockedRegistries + ","); }
    if (containerRuntimeSearchRegistries != null && !containerRuntimeSearchRegistries.isEmpty()) { sb.append("containerRuntimeSearchRegistries:"); sb.append(containerRuntimeSearchRegistries + ","); }
    if (insecureRegistries != null && !insecureRegistries.isEmpty()) { sb.append("insecureRegistries:"); sb.append(insecureRegistries + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}