package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UpdateHistoryBuilder extends UpdateHistoryFluentImpl<UpdateHistoryBuilder> implements VisitableBuilder<UpdateHistory,UpdateHistoryBuilder>{
  public UpdateHistoryBuilder() {
    this(false);
  }
  public UpdateHistoryBuilder(Boolean validationEnabled) {
    this(new UpdateHistory(), validationEnabled);
  }
  public UpdateHistoryBuilder(UpdateHistoryFluent<?> fluent) {
    this(fluent, false);
  }
  public UpdateHistoryBuilder(UpdateHistoryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UpdateHistory(), validationEnabled);
  }
  public UpdateHistoryBuilder(UpdateHistoryFluent<?> fluent,UpdateHistory instance) {
    this(fluent, instance, false);
  }
  public UpdateHistoryBuilder(UpdateHistoryFluent<?> fluent,UpdateHistory instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAcceptedRisks(instance.getAcceptedRisks()); 
    fluent.withCompletionTime(instance.getCompletionTime()); 
    fluent.withImage(instance.getImage()); 
    fluent.withStartedTime(instance.getStartedTime()); 
    fluent.withState(instance.getState()); 
    fluent.withVerified(instance.getVerified()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UpdateHistoryBuilder(UpdateHistory instance) {
    this(instance,false);
  }
  public UpdateHistoryBuilder(UpdateHistory instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAcceptedRisks(instance.getAcceptedRisks()); 
    this.withCompletionTime(instance.getCompletionTime()); 
    this.withImage(instance.getImage()); 
    this.withStartedTime(instance.getStartedTime()); 
    this.withState(instance.getState()); 
    this.withVerified(instance.getVerified()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  UpdateHistoryFluent<?> fluent;
  Boolean validationEnabled;
  public UpdateHistory build() {
    UpdateHistory buildable = new UpdateHistory(fluent.getAcceptedRisks(),fluent.getCompletionTime(),fluent.getImage(),fluent.getStartedTime(),fluent.getState(),fluent.getVerified(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}