package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateSpecBuilder extends FeatureGateSpecFluentImpl<FeatureGateSpecBuilder> implements VisitableBuilder<FeatureGateSpec,FeatureGateSpecBuilder>{
  public FeatureGateSpecBuilder() {
    this(false);
  }
  public FeatureGateSpecBuilder(Boolean validationEnabled) {
    this(new FeatureGateSpec(), validationEnabled);
  }
  public FeatureGateSpecBuilder(FeatureGateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateSpecBuilder(FeatureGateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeatureGateSpec(), validationEnabled);
  }
  public FeatureGateSpecBuilder(FeatureGateSpecFluent<?> fluent,FeatureGateSpec instance) {
    this(fluent, instance, false);
  }
  public FeatureGateSpecBuilder(FeatureGateSpecFluent<?> fluent,FeatureGateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCustomNoUpgrade(instance.getCustomNoUpgrade()); 
    fluent.withFeatureSet(instance.getFeatureSet()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateSpecBuilder(FeatureGateSpec instance) {
    this(instance,false);
  }
  public FeatureGateSpecBuilder(FeatureGateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCustomNoUpgrade(instance.getCustomNoUpgrade()); 
    this.withFeatureSet(instance.getFeatureSet()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  FeatureGateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public FeatureGateSpec build() {
    FeatureGateSpec buildable = new FeatureGateSpec(fluent.getCustomNoUpgrade(),fluent.getFeatureSet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}