package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStatusBuilder extends ImageStatusFluentImpl<ImageStatusBuilder> implements VisitableBuilder<ImageStatus,ImageStatusBuilder>{
  public ImageStatusBuilder() {
    this(false);
  }
  public ImageStatusBuilder(Boolean validationEnabled) {
    this(new ImageStatus(), validationEnabled);
  }
  public ImageStatusBuilder(ImageStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStatusBuilder(ImageStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStatus(), validationEnabled);
  }
  public ImageStatusBuilder(ImageStatusFluent<?> fluent,ImageStatus instance) {
    this(fluent, instance, false);
  }
  public ImageStatusBuilder(ImageStatusFluent<?> fluent,ImageStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExternalRegistryHostnames(instance.getExternalRegistryHostnames()); 
    fluent.withInternalRegistryHostname(instance.getInternalRegistryHostname()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStatusBuilder(ImageStatus instance) {
    this(instance,false);
  }
  public ImageStatusBuilder(ImageStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExternalRegistryHostnames(instance.getExternalRegistryHostnames()); 
    this.withInternalRegistryHostname(instance.getInternalRegistryHostname()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ImageStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStatus build() {
    ImageStatus buildable = new ImageStatus(fluent.getExternalRegistryHostnames(),fluent.getInternalRegistryHostname());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}