package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class APIServerSpecFluentImpl<A extends APIServerSpecFluent<A>> extends BaseFluent<A> implements APIServerSpecFluent<A>{
  public APIServerSpecFluentImpl() {
  }
  public APIServerSpecFluentImpl(APIServerSpec instance) {
    if (instance != null) {
      this.withAdditionalCORSAllowedOrigins(instance.getAdditionalCORSAllowedOrigins());
      this.withAudit(instance.getAudit());
      this.withClientCA(instance.getClientCA());
      this.withEncryption(instance.getEncryption());
      this.withServingCerts(instance.getServingCerts());
      this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> additionalCORSAllowedOrigins = new ArrayList<String>();
  private AuditBuilder audit;
  private ConfigMapNameReferenceBuilder clientCA;
  private APIServerEncryptionBuilder encryption;
  private APIServerServingCertsBuilder servingCerts;
  private TLSSecurityProfileBuilder tlsSecurityProfile;
  private Map<String,Object> additionalProperties;
  public A addToAdditionalCORSAllowedOrigins(int index,String item) {
    if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
    this.additionalCORSAllowedOrigins.add(index, item);
    return (A)this;
  }
  public A setToAdditionalCORSAllowedOrigins(int index,String item) {
    if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
    this.additionalCORSAllowedOrigins.set(index, item); return (A)this;
  }
  public A addToAdditionalCORSAllowedOrigins(java.lang.String... items) {
    if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
    for (String item : items) {this.additionalCORSAllowedOrigins.add(item);} return (A)this;
  }
  public A addAllToAdditionalCORSAllowedOrigins(Collection<String> items) {
    if (this.additionalCORSAllowedOrigins == null) {this.additionalCORSAllowedOrigins = new ArrayList<String>();}
    for (String item : items) {this.additionalCORSAllowedOrigins.add(item);} return (A)this;
  }
  public A removeFromAdditionalCORSAllowedOrigins(java.lang.String... items) {
    for (String item : items) {if (this.additionalCORSAllowedOrigins!= null){ this.additionalCORSAllowedOrigins.remove(item);}} return (A)this;
  }
  public A removeAllFromAdditionalCORSAllowedOrigins(Collection<String> items) {
    for (String item : items) {if (this.additionalCORSAllowedOrigins!= null){ this.additionalCORSAllowedOrigins.remove(item);}} return (A)this;
  }
  public List<String> getAdditionalCORSAllowedOrigins() {
    return this.additionalCORSAllowedOrigins;
  }
  public String getAdditionalCORSAllowedOrigin(int index) {
    return this.additionalCORSAllowedOrigins.get(index);
  }
  public String getFirstAdditionalCORSAllowedOrigin() {
    return this.additionalCORSAllowedOrigins.get(0);
  }
  public String getLastAdditionalCORSAllowedOrigin() {
    return this.additionalCORSAllowedOrigins.get(additionalCORSAllowedOrigins.size() - 1);
  }
  public String getMatchingAdditionalCORSAllowedOrigin(Predicate<String> predicate) {
    for (String item: additionalCORSAllowedOrigins) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAdditionalCORSAllowedOrigin(Predicate<String> predicate) {
    for (String item: additionalCORSAllowedOrigins) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalCORSAllowedOrigins(List<String> additionalCORSAllowedOrigins) {
    if (additionalCORSAllowedOrigins != null) {this.additionalCORSAllowedOrigins = new ArrayList(); for (String item : additionalCORSAllowedOrigins){this.addToAdditionalCORSAllowedOrigins(item);}} else { this.additionalCORSAllowedOrigins = null;} return (A) this;
  }
  public A withAdditionalCORSAllowedOrigins(java.lang.String... additionalCORSAllowedOrigins) {
    if (this.additionalCORSAllowedOrigins != null) {this.additionalCORSAllowedOrigins.clear(); _visitables.remove("additionalCORSAllowedOrigins"); }
    if (additionalCORSAllowedOrigins != null) {for (String item :additionalCORSAllowedOrigins){ this.addToAdditionalCORSAllowedOrigins(item);}} return (A) this;
  }
  public Boolean hasAdditionalCORSAllowedOrigins() {
    return additionalCORSAllowedOrigins != null && !additionalCORSAllowedOrigins.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildAudit instead.
   * @return The buildable object.
   */
  @Deprecated
  public Audit getAudit() {
    return this.audit!=null ?this.audit.build():null;
  }
  public Audit buildAudit() {
    return this.audit!=null ?this.audit.build():null;
  }
  public A withAudit(Audit audit) {
    _visitables.get("audit").remove(this.audit);
    if (audit!=null){ this.audit= new AuditBuilder(audit); _visitables.get("audit").add(this.audit);} else { this.audit = null; _visitables.get("audit").remove(this.audit); } return (A) this;
  }
  public Boolean hasAudit() {
    return this.audit != null;
  }
  public APIServerSpecFluentImpl.AuditNested<A> withNewAudit() {
    return new APIServerSpecFluentImpl.AuditNestedImpl();
  }
  public APIServerSpecFluentImpl.AuditNested<A> withNewAuditLike(Audit item) {
    return new APIServerSpecFluentImpl.AuditNestedImpl(item);
  }
  public APIServerSpecFluentImpl.AuditNested<A> editAudit() {
    return withNewAuditLike(getAudit());
  }
  public APIServerSpecFluentImpl.AuditNested<A> editOrNewAudit() {
    return withNewAuditLike(getAudit() != null ? getAudit(): new AuditBuilder().build());
  }
  public APIServerSpecFluentImpl.AuditNested<A> editOrNewAuditLike(Audit item) {
    return withNewAuditLike(getAudit() != null ? getAudit(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildClientCA instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getClientCA() {
    return this.clientCA!=null ?this.clientCA.build():null;
  }
  public ConfigMapNameReference buildClientCA() {
    return this.clientCA!=null ?this.clientCA.build():null;
  }
  public A withClientCA(ConfigMapNameReference clientCA) {
    _visitables.get("clientCA").remove(this.clientCA);
    if (clientCA!=null){ this.clientCA= new ConfigMapNameReferenceBuilder(clientCA); _visitables.get("clientCA").add(this.clientCA);} else { this.clientCA = null; _visitables.get("clientCA").remove(this.clientCA); } return (A) this;
  }
  public Boolean hasClientCA() {
    return this.clientCA != null;
  }
  public A withNewClientCA(String name) {
    return (A)withClientCA(new ConfigMapNameReference(name));
  }
  public APIServerSpecFluentImpl.ClientCANested<A> withNewClientCA() {
    return new APIServerSpecFluentImpl.ClientCANestedImpl();
  }
  public APIServerSpecFluentImpl.ClientCANested<A> withNewClientCALike(ConfigMapNameReference item) {
    return new APIServerSpecFluentImpl.ClientCANestedImpl(item);
  }
  public APIServerSpecFluentImpl.ClientCANested<A> editClientCA() {
    return withNewClientCALike(getClientCA());
  }
  public APIServerSpecFluentImpl.ClientCANested<A> editOrNewClientCA() {
    return withNewClientCALike(getClientCA() != null ? getClientCA(): new ConfigMapNameReferenceBuilder().build());
  }
  public APIServerSpecFluentImpl.ClientCANested<A> editOrNewClientCALike(ConfigMapNameReference item) {
    return withNewClientCALike(getClientCA() != null ? getClientCA(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEncryption instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServerEncryption getEncryption() {
    return this.encryption!=null ?this.encryption.build():null;
  }
  public APIServerEncryption buildEncryption() {
    return this.encryption!=null ?this.encryption.build():null;
  }
  public A withEncryption(APIServerEncryption encryption) {
    _visitables.get("encryption").remove(this.encryption);
    if (encryption!=null){ this.encryption= new APIServerEncryptionBuilder(encryption); _visitables.get("encryption").add(this.encryption);} else { this.encryption = null; _visitables.get("encryption").remove(this.encryption); } return (A) this;
  }
  public Boolean hasEncryption() {
    return this.encryption != null;
  }
  public A withNewEncryption(String type) {
    return (A)withEncryption(new APIServerEncryption(type));
  }
  public APIServerSpecFluentImpl.EncryptionNested<A> withNewEncryption() {
    return new APIServerSpecFluentImpl.EncryptionNestedImpl();
  }
  public APIServerSpecFluentImpl.EncryptionNested<A> withNewEncryptionLike(APIServerEncryption item) {
    return new APIServerSpecFluentImpl.EncryptionNestedImpl(item);
  }
  public APIServerSpecFluentImpl.EncryptionNested<A> editEncryption() {
    return withNewEncryptionLike(getEncryption());
  }
  public APIServerSpecFluentImpl.EncryptionNested<A> editOrNewEncryption() {
    return withNewEncryptionLike(getEncryption() != null ? getEncryption(): new APIServerEncryptionBuilder().build());
  }
  public APIServerSpecFluentImpl.EncryptionNested<A> editOrNewEncryptionLike(APIServerEncryption item) {
    return withNewEncryptionLike(getEncryption() != null ? getEncryption(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServingCerts instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServerServingCerts getServingCerts() {
    return this.servingCerts!=null ?this.servingCerts.build():null;
  }
  public APIServerServingCerts buildServingCerts() {
    return this.servingCerts!=null ?this.servingCerts.build():null;
  }
  public A withServingCerts(APIServerServingCerts servingCerts) {
    _visitables.get("servingCerts").remove(this.servingCerts);
    if (servingCerts!=null){ this.servingCerts= new APIServerServingCertsBuilder(servingCerts); _visitables.get("servingCerts").add(this.servingCerts);} else { this.servingCerts = null; _visitables.get("servingCerts").remove(this.servingCerts); } return (A) this;
  }
  public Boolean hasServingCerts() {
    return this.servingCerts != null;
  }
  public APIServerSpecFluentImpl.ServingCertsNested<A> withNewServingCerts() {
    return new APIServerSpecFluentImpl.ServingCertsNestedImpl();
  }
  public APIServerSpecFluentImpl.ServingCertsNested<A> withNewServingCertsLike(APIServerServingCerts item) {
    return new APIServerSpecFluentImpl.ServingCertsNestedImpl(item);
  }
  public APIServerSpecFluentImpl.ServingCertsNested<A> editServingCerts() {
    return withNewServingCertsLike(getServingCerts());
  }
  public APIServerSpecFluentImpl.ServingCertsNested<A> editOrNewServingCerts() {
    return withNewServingCertsLike(getServingCerts() != null ? getServingCerts(): new APIServerServingCertsBuilder().build());
  }
  public APIServerSpecFluentImpl.ServingCertsNested<A> editOrNewServingCertsLike(APIServerServingCerts item) {
    return withNewServingCertsLike(getServingCerts() != null ? getServingCerts(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTlsSecurityProfile instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSSecurityProfile getTlsSecurityProfile() {
    return this.tlsSecurityProfile!=null ?this.tlsSecurityProfile.build():null;
  }
  public TLSSecurityProfile buildTlsSecurityProfile() {
    return this.tlsSecurityProfile!=null ?this.tlsSecurityProfile.build():null;
  }
  public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
    _visitables.get("tlsSecurityProfile").remove(this.tlsSecurityProfile);
    if (tlsSecurityProfile!=null){ this.tlsSecurityProfile= new TLSSecurityProfileBuilder(tlsSecurityProfile); _visitables.get("tlsSecurityProfile").add(this.tlsSecurityProfile);} else { this.tlsSecurityProfile = null; _visitables.get("tlsSecurityProfile").remove(this.tlsSecurityProfile); } return (A) this;
  }
  public Boolean hasTlsSecurityProfile() {
    return this.tlsSecurityProfile != null;
  }
  public APIServerSpecFluentImpl.TlsSecurityProfileNested<A> withNewTlsSecurityProfile() {
    return new APIServerSpecFluentImpl.TlsSecurityProfileNestedImpl();
  }
  public APIServerSpecFluentImpl.TlsSecurityProfileNested<A> withNewTlsSecurityProfileLike(TLSSecurityProfile item) {
    return new APIServerSpecFluentImpl.TlsSecurityProfileNestedImpl(item);
  }
  public APIServerSpecFluentImpl.TlsSecurityProfileNested<A> editTlsSecurityProfile() {
    return withNewTlsSecurityProfileLike(getTlsSecurityProfile());
  }
  public APIServerSpecFluentImpl.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfile() {
    return withNewTlsSecurityProfileLike(getTlsSecurityProfile() != null ? getTlsSecurityProfile(): new TLSSecurityProfileBuilder().build());
  }
  public APIServerSpecFluentImpl.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfileLike(TLSSecurityProfile item) {
    return withNewTlsSecurityProfileLike(getTlsSecurityProfile() != null ? getTlsSecurityProfile(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    APIServerSpecFluentImpl that = (APIServerSpecFluentImpl) o;
    if (!java.util.Objects.equals(additionalCORSAllowedOrigins, that.additionalCORSAllowedOrigins)) return false;

    if (!java.util.Objects.equals(audit, that.audit)) return false;

    if (!java.util.Objects.equals(clientCA, that.clientCA)) return false;

    if (!java.util.Objects.equals(encryption, that.encryption)) return false;

    if (!java.util.Objects.equals(servingCerts, that.servingCerts)) return false;

    if (!java.util.Objects.equals(tlsSecurityProfile, that.tlsSecurityProfile)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalCORSAllowedOrigins,  audit,  clientCA,  encryption,  servingCerts,  tlsSecurityProfile,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalCORSAllowedOrigins != null && !additionalCORSAllowedOrigins.isEmpty()) { sb.append("additionalCORSAllowedOrigins:"); sb.append(additionalCORSAllowedOrigins + ","); }
    if (audit != null) { sb.append("audit:"); sb.append(audit + ","); }
    if (clientCA != null) { sb.append("clientCA:"); sb.append(clientCA + ","); }
    if (encryption != null) { sb.append("encryption:"); sb.append(encryption + ","); }
    if (servingCerts != null) { sb.append("servingCerts:"); sb.append(servingCerts + ","); }
    if (tlsSecurityProfile != null) { sb.append("tlsSecurityProfile:"); sb.append(tlsSecurityProfile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AuditNestedImpl<N> extends AuditFluentImpl<APIServerSpecFluentImpl.AuditNested<N>> implements APIServerSpecFluentImpl.AuditNested<N>,Nested<N>{
    AuditNestedImpl(Audit item) {
      this.builder = new AuditBuilder(this, item);
    }
    AuditNestedImpl() {
      this.builder = new AuditBuilder(this);
    }
    AuditBuilder builder;
    public N and() {
      return (N) APIServerSpecFluentImpl.this.withAudit(builder.build());
    }
    public N endAudit() {
      return and();
    }
    
  }
  class ClientCANestedImpl<N> extends ConfigMapNameReferenceFluentImpl<APIServerSpecFluentImpl.ClientCANested<N>> implements APIServerSpecFluentImpl.ClientCANested<N>,Nested<N>{
    ClientCANestedImpl(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    ClientCANestedImpl() {
      this.builder = new ConfigMapNameReferenceBuilder(this);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) APIServerSpecFluentImpl.this.withClientCA(builder.build());
    }
    public N endClientCA() {
      return and();
    }
    
  }
  class EncryptionNestedImpl<N> extends APIServerEncryptionFluentImpl<APIServerSpecFluentImpl.EncryptionNested<N>> implements APIServerSpecFluentImpl.EncryptionNested<N>,Nested<N>{
    EncryptionNestedImpl(APIServerEncryption item) {
      this.builder = new APIServerEncryptionBuilder(this, item);
    }
    EncryptionNestedImpl() {
      this.builder = new APIServerEncryptionBuilder(this);
    }
    APIServerEncryptionBuilder builder;
    public N and() {
      return (N) APIServerSpecFluentImpl.this.withEncryption(builder.build());
    }
    public N endEncryption() {
      return and();
    }
    
  }
  class ServingCertsNestedImpl<N> extends APIServerServingCertsFluentImpl<APIServerSpecFluentImpl.ServingCertsNested<N>> implements APIServerSpecFluentImpl.ServingCertsNested<N>,Nested<N>{
    ServingCertsNestedImpl(APIServerServingCerts item) {
      this.builder = new APIServerServingCertsBuilder(this, item);
    }
    ServingCertsNestedImpl() {
      this.builder = new APIServerServingCertsBuilder(this);
    }
    APIServerServingCertsBuilder builder;
    public N and() {
      return (N) APIServerSpecFluentImpl.this.withServingCerts(builder.build());
    }
    public N endServingCerts() {
      return and();
    }
    
  }
  class TlsSecurityProfileNestedImpl<N> extends TLSSecurityProfileFluentImpl<APIServerSpecFluentImpl.TlsSecurityProfileNested<N>> implements APIServerSpecFluentImpl.TlsSecurityProfileNested<N>,Nested<N>{
    TlsSecurityProfileNestedImpl(TLSSecurityProfile item) {
      this.builder = new TLSSecurityProfileBuilder(this, item);
    }
    TlsSecurityProfileNestedImpl() {
      this.builder = new TLSSecurityProfileBuilder(this);
    }
    TLSSecurityProfileBuilder builder;
    public N and() {
      return (N) APIServerSpecFluentImpl.this.withTlsSecurityProfile(builder.build());
    }
    public N endTlsSecurityProfile() {
      return and();
    }
    
  }
  
}