package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterOperatorStatusBuilder extends ClusterOperatorStatusFluentImpl<ClusterOperatorStatusBuilder> implements VisitableBuilder<ClusterOperatorStatus,ClusterOperatorStatusBuilder>{
  public ClusterOperatorStatusBuilder() {
    this(false);
  }
  public ClusterOperatorStatusBuilder(Boolean validationEnabled) {
    this(new ClusterOperatorStatus(), validationEnabled);
  }
  public ClusterOperatorStatusBuilder(ClusterOperatorStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterOperatorStatusBuilder(ClusterOperatorStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterOperatorStatus(), validationEnabled);
  }
  public ClusterOperatorStatusBuilder(ClusterOperatorStatusFluent<?> fluent,ClusterOperatorStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterOperatorStatusBuilder(ClusterOperatorStatusFluent<?> fluent,ClusterOperatorStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withExtension(instance.getExtension());
      fluent.withRelatedObjects(instance.getRelatedObjects());
      fluent.withVersions(instance.getVersions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterOperatorStatusBuilder(ClusterOperatorStatus instance) {
    this(instance,false);
  }
  public ClusterOperatorStatusBuilder(ClusterOperatorStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withExtension(instance.getExtension());
      this.withRelatedObjects(instance.getRelatedObjects());
      this.withVersions(instance.getVersions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterOperatorStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterOperatorStatus build() {
    ClusterOperatorStatus buildable = new ClusterOperatorStatus(fluent.getConditions(),fluent.getExtension(),fluent.getRelatedObjects(),fluent.getVersions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}