package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterOperatorStatusFluentImpl<A extends ClusterOperatorStatusFluent<A>> extends BaseFluent<A> implements ClusterOperatorStatusFluent<A>{
  public ClusterOperatorStatusFluentImpl() {
  }
  public ClusterOperatorStatusFluentImpl(ClusterOperatorStatus instance) {
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withExtension(instance.getExtension());
      this.withRelatedObjects(instance.getRelatedObjects());
      this.withVersions(instance.getVersions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ClusterOperatorStatusConditionBuilder> conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();
  private RawExtension extension;
  private ArrayList<ObjectReferenceBuilder> relatedObjects = new ArrayList<ObjectReferenceBuilder>();
  private ArrayList<OperandVersionBuilder> versions = new ArrayList<OperandVersionBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToConditions(int index,ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items) {
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items) {
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ClusterOperatorStatusConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ClusterOperatorStatusConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterOperatorStatusCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ClusterOperatorStatusCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ClusterOperatorStatusCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public ClusterOperatorStatusCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ClusterOperatorStatusCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    for (ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    for (ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ClusterOperatorStatusCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ClusterOperatorStatusCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ClusterOperatorStatusCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
  }
  public ClusterOperatorStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new ClusterOperatorStatusFluentImpl.ConditionsNestedImpl();
  }
  public ClusterOperatorStatusFluentImpl.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item) {
    return new ClusterOperatorStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ClusterOperatorStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,ClusterOperatorStatusCondition item) {
    return new ClusterOperatorStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ClusterOperatorStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterOperatorStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ClusterOperatorStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterOperatorStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public RawExtension getExtension() {
    return this.extension;
  }
  public A withExtension(RawExtension extension) {
    this.extension=extension; return (A) this;
  }
  public Boolean hasExtension() {
    return this.extension != null;
  }
  public A withNewExtension(Object value) {
    return (A)withExtension(new RawExtension(value));
  }
  public A addToRelatedObjects(int index,ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= relatedObjects.size()) { _visitables.get("relatedObjects").add(builder); relatedObjects.add(builder); } else { _visitables.get("relatedObjects").add(index, builder); relatedObjects.add(index, builder);}
    return (A)this;
  }
  public A setToRelatedObjects(int index,ObjectReference item) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
    if (index < 0 || index >= relatedObjects.size()) { _visitables.get("relatedObjects").add(builder); relatedObjects.add(builder); } else { _visitables.get("relatedObjects").set(index, builder); relatedObjects.set(index, builder);}
    return (A)this;
  }
  public A addToRelatedObjects(io.fabric8.openshift.api.model.config.v1.ObjectReference... items) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  public A addAllToRelatedObjects(Collection<ObjectReference> items) {
    if (this.relatedObjects == null) {this.relatedObjects = new ArrayList<ObjectReferenceBuilder>();}
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").add(builder);this.relatedObjects.add(builder);} return (A)this;
  }
  public A removeFromRelatedObjects(io.fabric8.openshift.api.model.config.v1.ObjectReference... items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelatedObjects(Collection<ObjectReference> items) {
    for (ObjectReference item : items) {ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);_visitables.get("relatedObjects").remove(builder);if (this.relatedObjects != null) {this.relatedObjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelatedObjects(Predicate<ObjectReferenceBuilder> predicate) {
    if (relatedObjects == null) return (A) this;
    final Iterator<ObjectReferenceBuilder> each = relatedObjects.iterator();
    final List visitables = _visitables.get("relatedObjects");
    while (each.hasNext()) {
      ObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelatedObjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ObjectReference> getRelatedObjects() {
    return relatedObjects != null ? build(relatedObjects) : null;
  }
  public List<ObjectReference> buildRelatedObjects() {
    return relatedObjects != null ? build(relatedObjects) : null;
  }
  public ObjectReference buildRelatedObject(int index) {
    return this.relatedObjects.get(index).build();
  }
  public ObjectReference buildFirstRelatedObject() {
    return this.relatedObjects.get(0).build();
  }
  public ObjectReference buildLastRelatedObject() {
    return this.relatedObjects.get(relatedObjects.size() - 1).build();
  }
  public ObjectReference buildMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
    for (ObjectReferenceBuilder item: relatedObjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelatedObjects(List<ObjectReference> relatedObjects) {
    if (this.relatedObjects != null) { _visitables.get("relatedObjects").clear();}
    if (relatedObjects != null) {this.relatedObjects = new ArrayList(); for (ObjectReference item : relatedObjects){this.addToRelatedObjects(item);}} else { this.relatedObjects = null;} return (A) this;
  }
  public A withRelatedObjects(io.fabric8.openshift.api.model.config.v1.ObjectReference... relatedObjects) {
    if (this.relatedObjects != null) {this.relatedObjects.clear(); _visitables.remove("relatedObjects"); }
    if (relatedObjects != null) {for (ObjectReference item :relatedObjects){ this.addToRelatedObjects(item);}} return (A) this;
  }
  public Boolean hasRelatedObjects() {
    return relatedObjects != null && !relatedObjects.isEmpty();
  }
  public A addNewRelatedObject(String group,String name,String namespace,String resource) {
    return (A)addToRelatedObjects(new ObjectReference(group, name, namespace, resource));
  }
  public ClusterOperatorStatusFluentImpl.RelatedObjectsNested<A> addNewRelatedObject() {
    return new ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl();
  }
  public ClusterOperatorStatusFluentImpl.RelatedObjectsNested<A> addNewRelatedObjectLike(ObjectReference item) {
    return new ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl(-1, item);
  }
  public ClusterOperatorStatusFluentImpl.RelatedObjectsNested<A> setNewRelatedObjectLike(int index,ObjectReference item) {
    return new ClusterOperatorStatusFluentImpl.RelatedObjectsNestedImpl(index, item);
  }
  public ClusterOperatorStatusFluentImpl.RelatedObjectsNested<A> editRelatedObject(int index) {
    if (relatedObjects.size() <= index) throw new RuntimeException("Can't edit relatedObjects. Index exceeds size.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public ClusterOperatorStatusFluentImpl.RelatedObjectsNested<A> editFirstRelatedObject() {
    if (relatedObjects.size() == 0) throw new RuntimeException("Can't edit first relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(0, buildRelatedObject(0));
  }
  public ClusterOperatorStatusFluentImpl.RelatedObjectsNested<A> editLastRelatedObject() {
    int index = relatedObjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relatedObjects. The list is empty.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public ClusterOperatorStatusFluentImpl.RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relatedObjects.size();i++) { 
    if (predicate.test(relatedObjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relatedObjects. No match found.");
    return setNewRelatedObjectLike(index, buildRelatedObject(index));
  }
  public A addToVersions(int index,OperandVersion item) {
    if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
    OperandVersionBuilder builder = new OperandVersionBuilder(item);
    if (index < 0 || index >= versions.size()) { _visitables.get("versions").add(builder); versions.add(builder); } else { _visitables.get("versions").add(index, builder); versions.add(index, builder);}
    return (A)this;
  }
  public A setToVersions(int index,OperandVersion item) {
    if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
    OperandVersionBuilder builder = new OperandVersionBuilder(item);
    if (index < 0 || index >= versions.size()) { _visitables.get("versions").add(builder); versions.add(builder); } else { _visitables.get("versions").set(index, builder); versions.set(index, builder);}
    return (A)this;
  }
  public A addToVersions(io.fabric8.openshift.api.model.config.v1.OperandVersion... items) {
    if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
    for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A addAllToVersions(Collection<OperandVersion> items) {
    if (this.versions == null) {this.versions = new ArrayList<OperandVersionBuilder>();}
    for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A removeFromVersions(io.fabric8.openshift.api.model.config.v1.OperandVersion... items) {
    for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeAllFromVersions(Collection<OperandVersion> items) {
    for (OperandVersion item : items) {OperandVersionBuilder builder = new OperandVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVersions(Predicate<OperandVersionBuilder> predicate) {
    if (versions == null) return (A) this;
    final Iterator<OperandVersionBuilder> each = versions.iterator();
    final List visitables = _visitables.get("versions");
    while (each.hasNext()) {
      OperandVersionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVersions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<OperandVersion> getVersions() {
    return versions != null ? build(versions) : null;
  }
  public List<OperandVersion> buildVersions() {
    return versions != null ? build(versions) : null;
  }
  public OperandVersion buildVersion(int index) {
    return this.versions.get(index).build();
  }
  public OperandVersion buildFirstVersion() {
    return this.versions.get(0).build();
  }
  public OperandVersion buildLastVersion() {
    return this.versions.get(versions.size() - 1).build();
  }
  public OperandVersion buildMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
    for (OperandVersionBuilder item: versions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
    for (OperandVersionBuilder item: versions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVersions(List<OperandVersion> versions) {
    if (this.versions != null) { _visitables.get("versions").clear();}
    if (versions != null) {this.versions = new ArrayList(); for (OperandVersion item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
  }
  public A withVersions(io.fabric8.openshift.api.model.config.v1.OperandVersion... versions) {
    if (this.versions != null) {this.versions.clear(); _visitables.remove("versions"); }
    if (versions != null) {for (OperandVersion item :versions){ this.addToVersions(item);}} return (A) this;
  }
  public Boolean hasVersions() {
    return versions != null && !versions.isEmpty();
  }
  public A addNewVersion(String name,String version) {
    return (A)addToVersions(new OperandVersion(name, version));
  }
  public ClusterOperatorStatusFluentImpl.VersionsNested<A> addNewVersion() {
    return new ClusterOperatorStatusFluentImpl.VersionsNestedImpl();
  }
  public ClusterOperatorStatusFluentImpl.VersionsNested<A> addNewVersionLike(OperandVersion item) {
    return new ClusterOperatorStatusFluentImpl.VersionsNestedImpl(-1, item);
  }
  public ClusterOperatorStatusFluentImpl.VersionsNested<A> setNewVersionLike(int index,OperandVersion item) {
    return new ClusterOperatorStatusFluentImpl.VersionsNestedImpl(index, item);
  }
  public ClusterOperatorStatusFluentImpl.VersionsNested<A> editVersion(int index) {
    if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public ClusterOperatorStatusFluentImpl.VersionsNested<A> editFirstVersion() {
    if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
    return setNewVersionLike(0, buildVersion(0));
  }
  public ClusterOperatorStatusFluentImpl.VersionsNested<A> editLastVersion() {
    int index = versions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public ClusterOperatorStatusFluentImpl.VersionsNested<A> editMatchingVersion(Predicate<OperandVersionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<versions.size();i++) { 
    if (predicate.test(versions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterOperatorStatusFluentImpl that = (ClusterOperatorStatusFluentImpl) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(extension, that.extension)) return false;

    if (!java.util.Objects.equals(relatedObjects, that.relatedObjects)) return false;

    if (!java.util.Objects.equals(versions, that.versions)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  extension,  relatedObjects,  versions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (extension != null) { sb.append("extension:"); sb.append(extension + ","); }
    if (relatedObjects != null) { sb.append("relatedObjects:"); sb.append(relatedObjects + ","); }
    if (versions != null) { sb.append("versions:"); sb.append(versions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ClusterOperatorStatusConditionFluentImpl<ClusterOperatorStatusFluentImpl.ConditionsNested<N>> implements ClusterOperatorStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,ClusterOperatorStatusCondition item) {
      this.index = index;
      this.builder = new ClusterOperatorStatusConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterOperatorStatusConditionBuilder(this);
    }
    ClusterOperatorStatusConditionBuilder builder;
    int index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class RelatedObjectsNestedImpl<N> extends ObjectReferenceFluentImpl<ClusterOperatorStatusFluentImpl.RelatedObjectsNested<N>> implements ClusterOperatorStatusFluentImpl.RelatedObjectsNested<N>,Nested<N>{
    RelatedObjectsNestedImpl(int index,ObjectReference item) {
      this.index = index;
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    RelatedObjectsNestedImpl() {
      this.index = -1;
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    int index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToRelatedObjects(index,builder.build());
    }
    public N endRelatedObject() {
      return and();
    }
    
  }
  class VersionsNestedImpl<N> extends OperandVersionFluentImpl<ClusterOperatorStatusFluentImpl.VersionsNested<N>> implements ClusterOperatorStatusFluentImpl.VersionsNested<N>,Nested<N>{
    VersionsNestedImpl(int index,OperandVersion item) {
      this.index = index;
      this.builder = new OperandVersionBuilder(this, item);
    }
    VersionsNestedImpl() {
      this.index = -1;
      this.builder = new OperandVersionBuilder(this);
    }
    OperandVersionBuilder builder;
    int index;
    public N and() {
      return (N) ClusterOperatorStatusFluentImpl.this.setToVersions(index,builder.build());
    }
    public N endVersion() {
      return and();
    }
    
  }
  
}