package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterVersionSpecBuilder extends ClusterVersionSpecFluentImpl<ClusterVersionSpecBuilder> implements VisitableBuilder<ClusterVersionSpec,ClusterVersionSpecBuilder>{
  public ClusterVersionSpecBuilder() {
    this(false);
  }
  public ClusterVersionSpecBuilder(Boolean validationEnabled) {
    this(new ClusterVersionSpec(), validationEnabled);
  }
  public ClusterVersionSpecBuilder(ClusterVersionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionSpecBuilder(ClusterVersionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterVersionSpec(), validationEnabled);
  }
  public ClusterVersionSpecBuilder(ClusterVersionSpecFluent<?> fluent,ClusterVersionSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionSpecBuilder(ClusterVersionSpecFluent<?> fluent,ClusterVersionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withChannel(instance.getChannel());
      fluent.withClusterID(instance.getClusterID());
      fluent.withDesiredUpdate(instance.getDesiredUpdate());
      fluent.withOverrides(instance.getOverrides());
      fluent.withUpstream(instance.getUpstream());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionSpecBuilder(ClusterVersionSpec instance) {
    this(instance,false);
  }
  public ClusterVersionSpecBuilder(ClusterVersionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withChannel(instance.getChannel());
      this.withClusterID(instance.getClusterID());
      this.withDesiredUpdate(instance.getDesiredUpdate());
      this.withOverrides(instance.getOverrides());
      this.withUpstream(instance.getUpstream());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterVersionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterVersionSpec build() {
    ClusterVersionSpec buildable = new ClusterVersionSpec(fluent.getChannel(),fluent.getClusterID(),fluent.getDesiredUpdate(),fluent.getOverrides(),fluent.getUpstream());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}