package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterVersionStatusFluentImpl<A extends ClusterVersionStatusFluent<A>> extends BaseFluent<A> implements ClusterVersionStatusFluent<A>{
  public ClusterVersionStatusFluentImpl() {
  }
  public ClusterVersionStatusFluentImpl(ClusterVersionStatus instance) {
    if (instance != null) {
      this.withAvailableUpdates(instance.getAvailableUpdates());
      this.withConditionalUpdates(instance.getConditionalUpdates());
      this.withConditions(instance.getConditions());
      this.withDesired(instance.getDesired());
      this.withHistory(instance.getHistory());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withVersionHash(instance.getVersionHash());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ReleaseBuilder> availableUpdates = new ArrayList<ReleaseBuilder>();
  private ArrayList<ConditionalUpdateBuilder> conditionalUpdates = new ArrayList<ConditionalUpdateBuilder>();
  private ArrayList<ClusterOperatorStatusConditionBuilder> conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();
  private ReleaseBuilder desired;
  private ArrayList<UpdateHistoryBuilder> history = new ArrayList<UpdateHistoryBuilder>();
  private Long observedGeneration;
  private String versionHash;
  private Map<String,Object> additionalProperties;
  public A addToAvailableUpdates(int index,Release item) {
    if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
    ReleaseBuilder builder = new ReleaseBuilder(item);
    if (index < 0 || index >= availableUpdates.size()) { _visitables.get("availableUpdates").add(builder); availableUpdates.add(builder); } else { _visitables.get("availableUpdates").add(index, builder); availableUpdates.add(index, builder);}
    return (A)this;
  }
  public A setToAvailableUpdates(int index,Release item) {
    if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
    ReleaseBuilder builder = new ReleaseBuilder(item);
    if (index < 0 || index >= availableUpdates.size()) { _visitables.get("availableUpdates").add(builder); availableUpdates.add(builder); } else { _visitables.get("availableUpdates").set(index, builder); availableUpdates.set(index, builder);}
    return (A)this;
  }
  public A addToAvailableUpdates(io.fabric8.openshift.api.model.config.v1.Release... items) {
    if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
    for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").add(builder);this.availableUpdates.add(builder);} return (A)this;
  }
  public A addAllToAvailableUpdates(Collection<Release> items) {
    if (this.availableUpdates == null) {this.availableUpdates = new ArrayList<ReleaseBuilder>();}
    for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").add(builder);this.availableUpdates.add(builder);} return (A)this;
  }
  public A removeFromAvailableUpdates(io.fabric8.openshift.api.model.config.v1.Release... items) {
    for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").remove(builder);if (this.availableUpdates != null) {this.availableUpdates.remove(builder);}} return (A)this;
  }
  public A removeAllFromAvailableUpdates(Collection<Release> items) {
    for (Release item : items) {ReleaseBuilder builder = new ReleaseBuilder(item);_visitables.get("availableUpdates").remove(builder);if (this.availableUpdates != null) {this.availableUpdates.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAvailableUpdates(Predicate<ReleaseBuilder> predicate) {
    if (availableUpdates == null) return (A) this;
    final Iterator<ReleaseBuilder> each = availableUpdates.iterator();
    final List visitables = _visitables.get("availableUpdates");
    while (each.hasNext()) {
      ReleaseBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAvailableUpdates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Release> getAvailableUpdates() {
    return availableUpdates != null ? build(availableUpdates) : null;
  }
  public List<Release> buildAvailableUpdates() {
    return availableUpdates != null ? build(availableUpdates) : null;
  }
  public Release buildAvailableUpdate(int index) {
    return this.availableUpdates.get(index).build();
  }
  public Release buildFirstAvailableUpdate() {
    return this.availableUpdates.get(0).build();
  }
  public Release buildLastAvailableUpdate() {
    return this.availableUpdates.get(availableUpdates.size() - 1).build();
  }
  public Release buildMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
    for (ReleaseBuilder item: availableUpdates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
    for (ReleaseBuilder item: availableUpdates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAvailableUpdates(List<Release> availableUpdates) {
    if (this.availableUpdates != null) { _visitables.get("availableUpdates").clear();}
    if (availableUpdates != null) {this.availableUpdates = new ArrayList(); for (Release item : availableUpdates){this.addToAvailableUpdates(item);}} else { this.availableUpdates = null;} return (A) this;
  }
  public A withAvailableUpdates(io.fabric8.openshift.api.model.config.v1.Release... availableUpdates) {
    if (this.availableUpdates != null) {this.availableUpdates.clear(); _visitables.remove("availableUpdates"); }
    if (availableUpdates != null) {for (Release item :availableUpdates){ this.addToAvailableUpdates(item);}} return (A) this;
  }
  public Boolean hasAvailableUpdates() {
    return availableUpdates != null && !availableUpdates.isEmpty();
  }
  public ClusterVersionStatusFluentImpl.AvailableUpdatesNested<A> addNewAvailableUpdate() {
    return new ClusterVersionStatusFluentImpl.AvailableUpdatesNestedImpl();
  }
  public ClusterVersionStatusFluentImpl.AvailableUpdatesNested<A> addNewAvailableUpdateLike(Release item) {
    return new ClusterVersionStatusFluentImpl.AvailableUpdatesNestedImpl(-1, item);
  }
  public ClusterVersionStatusFluentImpl.AvailableUpdatesNested<A> setNewAvailableUpdateLike(int index,Release item) {
    return new ClusterVersionStatusFluentImpl.AvailableUpdatesNestedImpl(index, item);
  }
  public ClusterVersionStatusFluentImpl.AvailableUpdatesNested<A> editAvailableUpdate(int index) {
    if (availableUpdates.size() <= index) throw new RuntimeException("Can't edit availableUpdates. Index exceeds size.");
    return setNewAvailableUpdateLike(index, buildAvailableUpdate(index));
  }
  public ClusterVersionStatusFluentImpl.AvailableUpdatesNested<A> editFirstAvailableUpdate() {
    if (availableUpdates.size() == 0) throw new RuntimeException("Can't edit first availableUpdates. The list is empty.");
    return setNewAvailableUpdateLike(0, buildAvailableUpdate(0));
  }
  public ClusterVersionStatusFluentImpl.AvailableUpdatesNested<A> editLastAvailableUpdate() {
    int index = availableUpdates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last availableUpdates. The list is empty.");
    return setNewAvailableUpdateLike(index, buildAvailableUpdate(index));
  }
  public ClusterVersionStatusFluentImpl.AvailableUpdatesNested<A> editMatchingAvailableUpdate(Predicate<ReleaseBuilder> predicate) {
    int index = -1;
    for (int i=0;i<availableUpdates.size();i++) { 
    if (predicate.test(availableUpdates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching availableUpdates. No match found.");
    return setNewAvailableUpdateLike(index, buildAvailableUpdate(index));
  }
  public A addToConditionalUpdates(int index,ConditionalUpdate item) {
    if (this.conditionalUpdates == null) {this.conditionalUpdates = new ArrayList<ConditionalUpdateBuilder>();}
    ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
    if (index < 0 || index >= conditionalUpdates.size()) { _visitables.get("conditionalUpdates").add(builder); conditionalUpdates.add(builder); } else { _visitables.get("conditionalUpdates").add(index, builder); conditionalUpdates.add(index, builder);}
    return (A)this;
  }
  public A setToConditionalUpdates(int index,ConditionalUpdate item) {
    if (this.conditionalUpdates == null) {this.conditionalUpdates = new ArrayList<ConditionalUpdateBuilder>();}
    ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);
    if (index < 0 || index >= conditionalUpdates.size()) { _visitables.get("conditionalUpdates").add(builder); conditionalUpdates.add(builder); } else { _visitables.get("conditionalUpdates").set(index, builder); conditionalUpdates.set(index, builder);}
    return (A)this;
  }
  public A addToConditionalUpdates(io.fabric8.openshift.api.model.config.v1.ConditionalUpdate... items) {
    if (this.conditionalUpdates == null) {this.conditionalUpdates = new ArrayList<ConditionalUpdateBuilder>();}
    for (ConditionalUpdate item : items) {ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);_visitables.get("conditionalUpdates").add(builder);this.conditionalUpdates.add(builder);} return (A)this;
  }
  public A addAllToConditionalUpdates(Collection<ConditionalUpdate> items) {
    if (this.conditionalUpdates == null) {this.conditionalUpdates = new ArrayList<ConditionalUpdateBuilder>();}
    for (ConditionalUpdate item : items) {ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);_visitables.get("conditionalUpdates").add(builder);this.conditionalUpdates.add(builder);} return (A)this;
  }
  public A removeFromConditionalUpdates(io.fabric8.openshift.api.model.config.v1.ConditionalUpdate... items) {
    for (ConditionalUpdate item : items) {ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);_visitables.get("conditionalUpdates").remove(builder);if (this.conditionalUpdates != null) {this.conditionalUpdates.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditionalUpdates(Collection<ConditionalUpdate> items) {
    for (ConditionalUpdate item : items) {ConditionalUpdateBuilder builder = new ConditionalUpdateBuilder(item);_visitables.get("conditionalUpdates").remove(builder);if (this.conditionalUpdates != null) {this.conditionalUpdates.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditionalUpdates(Predicate<ConditionalUpdateBuilder> predicate) {
    if (conditionalUpdates == null) return (A) this;
    final Iterator<ConditionalUpdateBuilder> each = conditionalUpdates.iterator();
    final List visitables = _visitables.get("conditionalUpdates");
    while (each.hasNext()) {
      ConditionalUpdateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditionalUpdates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ConditionalUpdate> getConditionalUpdates() {
    return conditionalUpdates != null ? build(conditionalUpdates) : null;
  }
  public List<ConditionalUpdate> buildConditionalUpdates() {
    return conditionalUpdates != null ? build(conditionalUpdates) : null;
  }
  public ConditionalUpdate buildConditionalUpdate(int index) {
    return this.conditionalUpdates.get(index).build();
  }
  public ConditionalUpdate buildFirstConditionalUpdate() {
    return this.conditionalUpdates.get(0).build();
  }
  public ConditionalUpdate buildLastConditionalUpdate() {
    return this.conditionalUpdates.get(conditionalUpdates.size() - 1).build();
  }
  public ConditionalUpdate buildMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
    for (ConditionalUpdateBuilder item: conditionalUpdates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
    for (ConditionalUpdateBuilder item: conditionalUpdates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditionalUpdates(List<ConditionalUpdate> conditionalUpdates) {
    if (this.conditionalUpdates != null) { _visitables.get("conditionalUpdates").clear();}
    if (conditionalUpdates != null) {this.conditionalUpdates = new ArrayList(); for (ConditionalUpdate item : conditionalUpdates){this.addToConditionalUpdates(item);}} else { this.conditionalUpdates = null;} return (A) this;
  }
  public A withConditionalUpdates(io.fabric8.openshift.api.model.config.v1.ConditionalUpdate... conditionalUpdates) {
    if (this.conditionalUpdates != null) {this.conditionalUpdates.clear(); _visitables.remove("conditionalUpdates"); }
    if (conditionalUpdates != null) {for (ConditionalUpdate item :conditionalUpdates){ this.addToConditionalUpdates(item);}} return (A) this;
  }
  public Boolean hasConditionalUpdates() {
    return conditionalUpdates != null && !conditionalUpdates.isEmpty();
  }
  public ClusterVersionStatusFluentImpl.ConditionalUpdatesNested<A> addNewConditionalUpdate() {
    return new ClusterVersionStatusFluentImpl.ConditionalUpdatesNestedImpl();
  }
  public ClusterVersionStatusFluentImpl.ConditionalUpdatesNested<A> addNewConditionalUpdateLike(ConditionalUpdate item) {
    return new ClusterVersionStatusFluentImpl.ConditionalUpdatesNestedImpl(-1, item);
  }
  public ClusterVersionStatusFluentImpl.ConditionalUpdatesNested<A> setNewConditionalUpdateLike(int index,ConditionalUpdate item) {
    return new ClusterVersionStatusFluentImpl.ConditionalUpdatesNestedImpl(index, item);
  }
  public ClusterVersionStatusFluentImpl.ConditionalUpdatesNested<A> editConditionalUpdate(int index) {
    if (conditionalUpdates.size() <= index) throw new RuntimeException("Can't edit conditionalUpdates. Index exceeds size.");
    return setNewConditionalUpdateLike(index, buildConditionalUpdate(index));
  }
  public ClusterVersionStatusFluentImpl.ConditionalUpdatesNested<A> editFirstConditionalUpdate() {
    if (conditionalUpdates.size() == 0) throw new RuntimeException("Can't edit first conditionalUpdates. The list is empty.");
    return setNewConditionalUpdateLike(0, buildConditionalUpdate(0));
  }
  public ClusterVersionStatusFluentImpl.ConditionalUpdatesNested<A> editLastConditionalUpdate() {
    int index = conditionalUpdates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditionalUpdates. The list is empty.");
    return setNewConditionalUpdateLike(index, buildConditionalUpdate(index));
  }
  public ClusterVersionStatusFluentImpl.ConditionalUpdatesNested<A> editMatchingConditionalUpdate(Predicate<ConditionalUpdateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditionalUpdates.size();i++) { 
    if (predicate.test(conditionalUpdates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditionalUpdates. No match found.");
    return setNewConditionalUpdateLike(index, buildConditionalUpdate(index));
  }
  public A addToConditions(int index,ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusConditionBuilder>();}
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items) {
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items) {
    for (ClusterOperatorStatusCondition item : items) {ClusterOperatorStatusConditionBuilder builder = new ClusterOperatorStatusConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ClusterOperatorStatusConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ClusterOperatorStatusConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterOperatorStatusCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<ClusterOperatorStatusCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public ClusterOperatorStatusCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public ClusterOperatorStatusCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public ClusterOperatorStatusCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public ClusterOperatorStatusCondition buildMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    for (ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    for (ClusterOperatorStatusConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ClusterOperatorStatusCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (ClusterOperatorStatusCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (ClusterOperatorStatusCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
  }
  public ClusterVersionStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new ClusterVersionStatusFluentImpl.ConditionsNestedImpl();
  }
  public ClusterVersionStatusFluentImpl.ConditionsNested<A> addNewConditionLike(ClusterOperatorStatusCondition item) {
    return new ClusterVersionStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public ClusterVersionStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,ClusterOperatorStatusCondition item) {
    return new ClusterVersionStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public ClusterVersionStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterVersionStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ClusterVersionStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ClusterVersionStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<ClusterOperatorStatusConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDesired instead.
   * @return The buildable object.
   */
  @Deprecated
  public Release getDesired() {
    return this.desired!=null ?this.desired.build():null;
  }
  public Release buildDesired() {
    return this.desired!=null ?this.desired.build():null;
  }
  public A withDesired(Release desired) {
    _visitables.get("desired").remove(this.desired);
    if (desired!=null){ this.desired= new ReleaseBuilder(desired); _visitables.get("desired").add(this.desired);} else { this.desired = null; _visitables.get("desired").remove(this.desired); } return (A) this;
  }
  public Boolean hasDesired() {
    return this.desired != null;
  }
  public ClusterVersionStatusFluentImpl.DesiredNested<A> withNewDesired() {
    return new ClusterVersionStatusFluentImpl.DesiredNestedImpl();
  }
  public ClusterVersionStatusFluentImpl.DesiredNested<A> withNewDesiredLike(Release item) {
    return new ClusterVersionStatusFluentImpl.DesiredNestedImpl(item);
  }
  public ClusterVersionStatusFluentImpl.DesiredNested<A> editDesired() {
    return withNewDesiredLike(getDesired());
  }
  public ClusterVersionStatusFluentImpl.DesiredNested<A> editOrNewDesired() {
    return withNewDesiredLike(getDesired() != null ? getDesired(): new ReleaseBuilder().build());
  }
  public ClusterVersionStatusFluentImpl.DesiredNested<A> editOrNewDesiredLike(Release item) {
    return withNewDesiredLike(getDesired() != null ? getDesired(): item);
  }
  public A addToHistory(int index,UpdateHistory item) {
    if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
    UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
    if (index < 0 || index >= history.size()) { _visitables.get("history").add(builder); history.add(builder); } else { _visitables.get("history").add(index, builder); history.add(index, builder);}
    return (A)this;
  }
  public A setToHistory(int index,UpdateHistory item) {
    if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
    UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);
    if (index < 0 || index >= history.size()) { _visitables.get("history").add(builder); history.add(builder); } else { _visitables.get("history").set(index, builder); history.set(index, builder);}
    return (A)this;
  }
  public A addToHistory(io.fabric8.openshift.api.model.config.v1.UpdateHistory... items) {
    if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
    for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
  }
  public A addAllToHistory(Collection<UpdateHistory> items) {
    if (this.history == null) {this.history = new ArrayList<UpdateHistoryBuilder>();}
    for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").add(builder);this.history.add(builder);} return (A)this;
  }
  public A removeFromHistory(io.fabric8.openshift.api.model.config.v1.UpdateHistory... items) {
    for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").remove(builder);if (this.history != null) {this.history.remove(builder);}} return (A)this;
  }
  public A removeAllFromHistory(Collection<UpdateHistory> items) {
    for (UpdateHistory item : items) {UpdateHistoryBuilder builder = new UpdateHistoryBuilder(item);_visitables.get("history").remove(builder);if (this.history != null) {this.history.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHistory(Predicate<UpdateHistoryBuilder> predicate) {
    if (history == null) return (A) this;
    final Iterator<UpdateHistoryBuilder> each = history.iterator();
    final List visitables = _visitables.get("history");
    while (each.hasNext()) {
      UpdateHistoryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHistory instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<UpdateHistory> getHistory() {
    return history != null ? build(history) : null;
  }
  public List<UpdateHistory> buildHistory() {
    return history != null ? build(history) : null;
  }
  public UpdateHistory buildHistory(int index) {
    return this.history.get(index).build();
  }
  public UpdateHistory buildFirstHistory() {
    return this.history.get(0).build();
  }
  public UpdateHistory buildLastHistory() {
    return this.history.get(history.size() - 1).build();
  }
  public UpdateHistory buildMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
    for (UpdateHistoryBuilder item: history) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
    for (UpdateHistoryBuilder item: history) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHistory(List<UpdateHistory> history) {
    if (this.history != null) { _visitables.get("history").clear();}
    if (history != null) {this.history = new ArrayList(); for (UpdateHistory item : history){this.addToHistory(item);}} else { this.history = null;} return (A) this;
  }
  public A withHistory(io.fabric8.openshift.api.model.config.v1.UpdateHistory... history) {
    if (this.history != null) {this.history.clear(); _visitables.remove("history"); }
    if (history != null) {for (UpdateHistory item :history){ this.addToHistory(item);}} return (A) this;
  }
  public Boolean hasHistory() {
    return history != null && !history.isEmpty();
  }
  public ClusterVersionStatusFluentImpl.HistoryNested<A> addNewHistory() {
    return new ClusterVersionStatusFluentImpl.HistoryNestedImpl();
  }
  public ClusterVersionStatusFluentImpl.HistoryNested<A> addNewHistoryLike(UpdateHistory item) {
    return new ClusterVersionStatusFluentImpl.HistoryNestedImpl(-1, item);
  }
  public ClusterVersionStatusFluentImpl.HistoryNested<A> setNewHistoryLike(int index,UpdateHistory item) {
    return new ClusterVersionStatusFluentImpl.HistoryNestedImpl(index, item);
  }
  public ClusterVersionStatusFluentImpl.HistoryNested<A> editHistory(int index) {
    if (history.size() <= index) throw new RuntimeException("Can't edit history. Index exceeds size.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  public ClusterVersionStatusFluentImpl.HistoryNested<A> editFirstHistory() {
    if (history.size() == 0) throw new RuntimeException("Can't edit first history. The list is empty.");
    return setNewHistoryLike(0, buildHistory(0));
  }
  public ClusterVersionStatusFluentImpl.HistoryNested<A> editLastHistory() {
    int index = history.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last history. The list is empty.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  public ClusterVersionStatusFluentImpl.HistoryNested<A> editMatchingHistory(Predicate<UpdateHistoryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<history.size();i++) { 
    if (predicate.test(history.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching history. No match found.");
    return setNewHistoryLike(index, buildHistory(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public String getVersionHash() {
    return this.versionHash;
  }
  public A withVersionHash(String versionHash) {
    this.versionHash=versionHash; return (A) this;
  }
  public Boolean hasVersionHash() {
    return this.versionHash != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterVersionStatusFluentImpl that = (ClusterVersionStatusFluentImpl) o;
    if (!java.util.Objects.equals(availableUpdates, that.availableUpdates)) return false;

    if (!java.util.Objects.equals(conditionalUpdates, that.conditionalUpdates)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(desired, that.desired)) return false;

    if (!java.util.Objects.equals(history, that.history)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(versionHash, that.versionHash)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableUpdates,  conditionalUpdates,  conditions,  desired,  history,  observedGeneration,  versionHash,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availableUpdates != null) { sb.append("availableUpdates:"); sb.append(availableUpdates + ","); }
    if (conditionalUpdates != null) { sb.append("conditionalUpdates:"); sb.append(conditionalUpdates + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (desired != null) { sb.append("desired:"); sb.append(desired + ","); }
    if (history != null) { sb.append("history:"); sb.append(history + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (versionHash != null) { sb.append("versionHash:"); sb.append(versionHash + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AvailableUpdatesNestedImpl<N> extends ReleaseFluentImpl<ClusterVersionStatusFluentImpl.AvailableUpdatesNested<N>> implements ClusterVersionStatusFluentImpl.AvailableUpdatesNested<N>,Nested<N>{
    AvailableUpdatesNestedImpl(int index,Release item) {
      this.index = index;
      this.builder = new ReleaseBuilder(this, item);
    }
    AvailableUpdatesNestedImpl() {
      this.index = -1;
      this.builder = new ReleaseBuilder(this);
    }
    ReleaseBuilder builder;
    int index;
    public N and() {
      return (N) ClusterVersionStatusFluentImpl.this.setToAvailableUpdates(index,builder.build());
    }
    public N endAvailableUpdate() {
      return and();
    }
    
  }
  class ConditionalUpdatesNestedImpl<N> extends ConditionalUpdateFluentImpl<ClusterVersionStatusFluentImpl.ConditionalUpdatesNested<N>> implements ClusterVersionStatusFluentImpl.ConditionalUpdatesNested<N>,Nested<N>{
    ConditionalUpdatesNestedImpl(int index,ConditionalUpdate item) {
      this.index = index;
      this.builder = new ConditionalUpdateBuilder(this, item);
    }
    ConditionalUpdatesNestedImpl() {
      this.index = -1;
      this.builder = new ConditionalUpdateBuilder(this);
    }
    ConditionalUpdateBuilder builder;
    int index;
    public N and() {
      return (N) ClusterVersionStatusFluentImpl.this.setToConditionalUpdates(index,builder.build());
    }
    public N endConditionalUpdate() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends ClusterOperatorStatusConditionFluentImpl<ClusterVersionStatusFluentImpl.ConditionsNested<N>> implements ClusterVersionStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,ClusterOperatorStatusCondition item) {
      this.index = index;
      this.builder = new ClusterOperatorStatusConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterOperatorStatusConditionBuilder(this);
    }
    ClusterOperatorStatusConditionBuilder builder;
    int index;
    public N and() {
      return (N) ClusterVersionStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class DesiredNestedImpl<N> extends ReleaseFluentImpl<ClusterVersionStatusFluentImpl.DesiredNested<N>> implements ClusterVersionStatusFluentImpl.DesiredNested<N>,Nested<N>{
    DesiredNestedImpl(Release item) {
      this.builder = new ReleaseBuilder(this, item);
    }
    DesiredNestedImpl() {
      this.builder = new ReleaseBuilder(this);
    }
    ReleaseBuilder builder;
    public N and() {
      return (N) ClusterVersionStatusFluentImpl.this.withDesired(builder.build());
    }
    public N endDesired() {
      return and();
    }
    
  }
  class HistoryNestedImpl<N> extends UpdateHistoryFluentImpl<ClusterVersionStatusFluentImpl.HistoryNested<N>> implements ClusterVersionStatusFluentImpl.HistoryNested<N>,Nested<N>{
    HistoryNestedImpl(int index,UpdateHistory item) {
      this.index = index;
      this.builder = new UpdateHistoryBuilder(this, item);
    }
    HistoryNestedImpl() {
      this.index = -1;
      this.builder = new UpdateHistoryBuilder(this);
    }
    UpdateHistoryBuilder builder;
    int index;
    public N and() {
      return (N) ClusterVersionStatusFluentImpl.this.setToHistory(index,builder.build());
    }
    public N endHistory() {
      return and();
    }
    
  }
  
}