package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapNameReferenceBuilder extends ConfigMapNameReferenceFluentImpl<ConfigMapNameReferenceBuilder> implements VisitableBuilder<ConfigMapNameReference,ConfigMapNameReferenceBuilder>{
  public ConfigMapNameReferenceBuilder() {
    this(false);
  }
  public ConfigMapNameReferenceBuilder(Boolean validationEnabled) {
    this(new ConfigMapNameReference(), validationEnabled);
  }
  public ConfigMapNameReferenceBuilder(ConfigMapNameReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapNameReferenceBuilder(ConfigMapNameReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapNameReference(), validationEnabled);
  }
  public ConfigMapNameReferenceBuilder(ConfigMapNameReferenceFluent<?> fluent,ConfigMapNameReference instance) {
    this(fluent, instance, false);
  }
  public ConfigMapNameReferenceBuilder(ConfigMapNameReferenceFluent<?> fluent,ConfigMapNameReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapNameReferenceBuilder(ConfigMapNameReference instance) {
    this(instance,false);
  }
  public ConfigMapNameReferenceBuilder(ConfigMapNameReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapNameReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapNameReference build() {
    ConfigMapNameReference buildable = new ConfigMapNameReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}