package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleStatusBuilder extends ConsoleStatusFluentImpl<ConsoleStatusBuilder> implements VisitableBuilder<ConsoleStatus,ConsoleStatusBuilder>{
  public ConsoleStatusBuilder() {
    this(false);
  }
  public ConsoleStatusBuilder(Boolean validationEnabled) {
    this(new ConsoleStatus(), validationEnabled);
  }
  public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleStatus(), validationEnabled);
  }
  public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent,ConsoleStatus instance) {
    this(fluent, instance, false);
  }
  public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent,ConsoleStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConsoleURL(instance.getConsoleURL());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleStatusBuilder(ConsoleStatus instance) {
    this(instance,false);
  }
  public ConsoleStatusBuilder(ConsoleStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConsoleURL(instance.getConsoleURL());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleStatus build() {
    ConsoleStatus buildable = new ConsoleStatus(fluent.getConsoleURL());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}