package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface DNSFluent<A extends DNSFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public DNSFluent.MetadataNested<A> withNewMetadata();
  public DNSFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public DNSFluent.MetadataNested<A> editMetadata();
  public DNSFluent.MetadataNested<A> editOrNewMetadata();
  public DNSFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public DNSSpec getSpec();
  public DNSSpec buildSpec();
  public A withSpec(DNSSpec spec);
  public Boolean hasSpec();
  public DNSFluent.SpecNested<A> withNewSpec();
  public DNSFluent.SpecNested<A> withNewSpecLike(DNSSpec item);
  public DNSFluent.SpecNested<A> editSpec();
  public DNSFluent.SpecNested<A> editOrNewSpec();
  public DNSFluent.SpecNested<A> editOrNewSpecLike(DNSSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public DNSStatus getStatus();
  public DNSStatus buildStatus();
  public A withStatus(DNSStatus status);
  public Boolean hasStatus();
  public DNSFluent.StatusNested<A> withNewStatus();
  public DNSFluent.StatusNested<A> withNewStatusLike(DNSStatus item);
  public DNSFluent.StatusNested<A> editStatus();
  public DNSFluent.StatusNested<A> editOrNewStatus();
  public DNSFluent.StatusNested<A> editOrNewStatusLike(DNSStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<DNSFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,DNSSpecFluent<DNSFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,DNSStatusFluent<DNSFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}