package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSStatusBuilder extends DNSStatusFluentImpl<DNSStatusBuilder> implements VisitableBuilder<DNSStatus,DNSStatusBuilder>{
  public DNSStatusBuilder() {
    this(false);
  }
  public DNSStatusBuilder(Boolean validationEnabled) {
    this(new DNSStatus(), validationEnabled);
  }
  public DNSStatusBuilder(DNSStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSStatusBuilder(DNSStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSStatus(), validationEnabled);
  }
  public DNSStatusBuilder(DNSStatusFluent<?> fluent,DNSStatus instance) {
    this(fluent, instance, false);
  }
  public DNSStatusBuilder(DNSStatusFluent<?> fluent,DNSStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSStatusBuilder(DNSStatus instance) {
    this(instance,false);
  }
  public DNSStatusBuilder(DNSStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSStatusFluent<?> fluent;
  Boolean validationEnabled;
  public DNSStatus build() {
    DNSStatus buildable = new DNSStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}