package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateBuilder extends FeatureGateFluentImpl<FeatureGateBuilder> implements VisitableBuilder<FeatureGate,FeatureGateBuilder>{
  public FeatureGateBuilder() {
    this(false);
  }
  public FeatureGateBuilder(Boolean validationEnabled) {
    this(new FeatureGate(), validationEnabled);
  }
  public FeatureGateBuilder(FeatureGateFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateBuilder(FeatureGateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeatureGate(), validationEnabled);
  }
  public FeatureGateBuilder(FeatureGateFluent<?> fluent,FeatureGate instance) {
    this(fluent, instance, false);
  }
  public FeatureGateBuilder(FeatureGateFluent<?> fluent,FeatureGate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateBuilder(FeatureGate instance) {
    this(instance,false);
  }
  public FeatureGateBuilder(FeatureGate instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FeatureGateFluent<?> fluent;
  Boolean validationEnabled;
  public FeatureGate build() {
    FeatureGate buildable = new FeatureGate(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}