package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateListBuilder extends FeatureGateListFluentImpl<FeatureGateListBuilder> implements VisitableBuilder<FeatureGateList,FeatureGateListBuilder>{
  public FeatureGateListBuilder() {
    this(false);
  }
  public FeatureGateListBuilder(Boolean validationEnabled) {
    this(new FeatureGateList(), validationEnabled);
  }
  public FeatureGateListBuilder(FeatureGateListFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateListBuilder(FeatureGateListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeatureGateList(), validationEnabled);
  }
  public FeatureGateListBuilder(FeatureGateListFluent<?> fluent,FeatureGateList instance) {
    this(fluent, instance, false);
  }
  public FeatureGateListBuilder(FeatureGateListFluent<?> fluent,FeatureGateList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateListBuilder(FeatureGateList instance) {
    this(instance,false);
  }
  public FeatureGateListBuilder(FeatureGateList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FeatureGateListFluent<?> fluent;
  Boolean validationEnabled;
  public FeatureGateList build() {
    FeatureGateList buildable = new FeatureGateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}