package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubIdentityProviderBuilder extends GitHubIdentityProviderFluentImpl<GitHubIdentityProviderBuilder> implements VisitableBuilder<GitHubIdentityProvider,GitHubIdentityProviderBuilder>{
  public GitHubIdentityProviderBuilder() {
    this(false);
  }
  public GitHubIdentityProviderBuilder(Boolean validationEnabled) {
    this(new GitHubIdentityProvider(), validationEnabled);
  }
  public GitHubIdentityProviderBuilder(GitHubIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubIdentityProviderBuilder(GitHubIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHubIdentityProvider(), validationEnabled);
  }
  public GitHubIdentityProviderBuilder(GitHubIdentityProviderFluent<?> fluent,GitHubIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public GitHubIdentityProviderBuilder(GitHubIdentityProviderFluent<?> fluent,GitHubIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCa(instance.getCa());
      fluent.withClientID(instance.getClientID());
      fluent.withClientSecret(instance.getClientSecret());
      fluent.withHostname(instance.getHostname());
      fluent.withOrganizations(instance.getOrganizations());
      fluent.withTeams(instance.getTeams());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitHubIdentityProviderBuilder(GitHubIdentityProvider instance) {
    this(instance,false);
  }
  public GitHubIdentityProviderBuilder(GitHubIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCa(instance.getCa());
      this.withClientID(instance.getClientID());
      this.withClientSecret(instance.getClientSecret());
      this.withHostname(instance.getHostname());
      this.withOrganizations(instance.getOrganizations());
      this.withTeams(instance.getTeams());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitHubIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public GitHubIdentityProvider build() {
    GitHubIdentityProvider buildable = new GitHubIdentityProvider(fluent.getCa(),fluent.getClientID(),fluent.getClientSecret(),fluent.getHostname(),fluent.getOrganizations(),fluent.getTeams());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}