package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStatusFluentImpl<A extends ImageStatusFluent<A>> extends BaseFluent<A> implements ImageStatusFluent<A>{
  public ImageStatusFluentImpl() {
  }
  public ImageStatusFluentImpl(ImageStatus instance) {
    if (instance != null) {
      this.withExternalRegistryHostnames(instance.getExternalRegistryHostnames());
      this.withInternalRegistryHostname(instance.getInternalRegistryHostname());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> externalRegistryHostnames = new ArrayList<String>();
  private String internalRegistryHostname;
  private Map<String,Object> additionalProperties;
  public A addToExternalRegistryHostnames(int index,String item) {
    if (this.externalRegistryHostnames == null) {this.externalRegistryHostnames = new ArrayList<String>();}
    this.externalRegistryHostnames.add(index, item);
    return (A)this;
  }
  public A setToExternalRegistryHostnames(int index,String item) {
    if (this.externalRegistryHostnames == null) {this.externalRegistryHostnames = new ArrayList<String>();}
    this.externalRegistryHostnames.set(index, item); return (A)this;
  }
  public A addToExternalRegistryHostnames(java.lang.String... items) {
    if (this.externalRegistryHostnames == null) {this.externalRegistryHostnames = new ArrayList<String>();}
    for (String item : items) {this.externalRegistryHostnames.add(item);} return (A)this;
  }
  public A addAllToExternalRegistryHostnames(Collection<String> items) {
    if (this.externalRegistryHostnames == null) {this.externalRegistryHostnames = new ArrayList<String>();}
    for (String item : items) {this.externalRegistryHostnames.add(item);} return (A)this;
  }
  public A removeFromExternalRegistryHostnames(java.lang.String... items) {
    for (String item : items) {if (this.externalRegistryHostnames!= null){ this.externalRegistryHostnames.remove(item);}} return (A)this;
  }
  public A removeAllFromExternalRegistryHostnames(Collection<String> items) {
    for (String item : items) {if (this.externalRegistryHostnames!= null){ this.externalRegistryHostnames.remove(item);}} return (A)this;
  }
  public List<String> getExternalRegistryHostnames() {
    return this.externalRegistryHostnames;
  }
  public String getExternalRegistryHostname(int index) {
    return this.externalRegistryHostnames.get(index);
  }
  public String getFirstExternalRegistryHostname() {
    return this.externalRegistryHostnames.get(0);
  }
  public String getLastExternalRegistryHostname() {
    return this.externalRegistryHostnames.get(externalRegistryHostnames.size() - 1);
  }
  public String getMatchingExternalRegistryHostname(Predicate<String> predicate) {
    for (String item: externalRegistryHostnames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExternalRegistryHostname(Predicate<String> predicate) {
    for (String item: externalRegistryHostnames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExternalRegistryHostnames(List<String> externalRegistryHostnames) {
    if (externalRegistryHostnames != null) {this.externalRegistryHostnames = new ArrayList(); for (String item : externalRegistryHostnames){this.addToExternalRegistryHostnames(item);}} else { this.externalRegistryHostnames = null;} return (A) this;
  }
  public A withExternalRegistryHostnames(java.lang.String... externalRegistryHostnames) {
    if (this.externalRegistryHostnames != null) {this.externalRegistryHostnames.clear(); _visitables.remove("externalRegistryHostnames"); }
    if (externalRegistryHostnames != null) {for (String item :externalRegistryHostnames){ this.addToExternalRegistryHostnames(item);}} return (A) this;
  }
  public Boolean hasExternalRegistryHostnames() {
    return externalRegistryHostnames != null && !externalRegistryHostnames.isEmpty();
  }
  public String getInternalRegistryHostname() {
    return this.internalRegistryHostname;
  }
  public A withInternalRegistryHostname(String internalRegistryHostname) {
    this.internalRegistryHostname=internalRegistryHostname; return (A) this;
  }
  public Boolean hasInternalRegistryHostname() {
    return this.internalRegistryHostname != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStatusFluentImpl that = (ImageStatusFluentImpl) o;
    if (!java.util.Objects.equals(externalRegistryHostnames, that.externalRegistryHostnames)) return false;

    if (!java.util.Objects.equals(internalRegistryHostname, that.internalRegistryHostname)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(externalRegistryHostnames,  internalRegistryHostname,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (externalRegistryHostnames != null && !externalRegistryHostnames.isEmpty()) { sb.append("externalRegistryHostnames:"); sb.append(externalRegistryHostnames + ","); }
    if (internalRegistryHostname != null) { sb.append("internalRegistryHostname:"); sb.append(internalRegistryHostname + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}