package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface IngressSpecFluent<A extends IngressSpecFluent<A>> extends Fluent<A>{
  public String getAppsDomain();
  public A withAppsDomain(String appsDomain);
  public Boolean hasAppsDomain();
  public A addToComponentRoutes(int index,ComponentRouteSpec item);
  public A setToComponentRoutes(int index,ComponentRouteSpec item);
  public A addToComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteSpec... items);
  public A addAllToComponentRoutes(Collection<ComponentRouteSpec> items);
  public A removeFromComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteSpec... items);
  public A removeAllFromComponentRoutes(Collection<ComponentRouteSpec> items);
  public A removeMatchingFromComponentRoutes(Predicate<ComponentRouteSpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildComponentRoutes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ComponentRouteSpec> getComponentRoutes();
  public List<ComponentRouteSpec> buildComponentRoutes();
  public ComponentRouteSpec buildComponentRoute(int index);
  public ComponentRouteSpec buildFirstComponentRoute();
  public ComponentRouteSpec buildLastComponentRoute();
  public ComponentRouteSpec buildMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate);
  public Boolean hasMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate);
  public A withComponentRoutes(List<ComponentRouteSpec> componentRoutes);
  public A withComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteSpec... componentRoutes);
  public Boolean hasComponentRoutes();
  public IngressSpecFluent.ComponentRoutesNested<A> addNewComponentRoute();
  public IngressSpecFluent.ComponentRoutesNested<A> addNewComponentRouteLike(ComponentRouteSpec item);
  public IngressSpecFluent.ComponentRoutesNested<A> setNewComponentRouteLike(int index,ComponentRouteSpec item);
  public IngressSpecFluent.ComponentRoutesNested<A> editComponentRoute(int index);
  public IngressSpecFluent.ComponentRoutesNested<A> editFirstComponentRoute();
  public IngressSpecFluent.ComponentRoutesNested<A> editLastComponentRoute();
  public IngressSpecFluent.ComponentRoutesNested<A> editMatchingComponentRoute(Predicate<ComponentRouteSpecBuilder> predicate);
  public String getDomain();
  public A withDomain(String domain);
  public Boolean hasDomain();
  public A addToRequiredHSTSPolicies(int index,RequiredHSTSPolicy item);
  public A setToRequiredHSTSPolicies(int index,RequiredHSTSPolicy item);
  public A addToRequiredHSTSPolicies(io.fabric8.openshift.api.model.config.v1.RequiredHSTSPolicy... items);
  public A addAllToRequiredHSTSPolicies(Collection<RequiredHSTSPolicy> items);
  public A removeFromRequiredHSTSPolicies(io.fabric8.openshift.api.model.config.v1.RequiredHSTSPolicy... items);
  public A removeAllFromRequiredHSTSPolicies(Collection<RequiredHSTSPolicy> items);
  public A removeMatchingFromRequiredHSTSPolicies(Predicate<RequiredHSTSPolicyBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildRequiredHSTSPolicies instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RequiredHSTSPolicy> getRequiredHSTSPolicies();
  public List<RequiredHSTSPolicy> buildRequiredHSTSPolicies();
  public RequiredHSTSPolicy buildRequiredHSTSPolicy(int index);
  public RequiredHSTSPolicy buildFirstRequiredHSTSPolicy();
  public RequiredHSTSPolicy buildLastRequiredHSTSPolicy();
  public RequiredHSTSPolicy buildMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate);
  public Boolean hasMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate);
  public A withRequiredHSTSPolicies(List<RequiredHSTSPolicy> requiredHSTSPolicies);
  public A withRequiredHSTSPolicies(io.fabric8.openshift.api.model.config.v1.RequiredHSTSPolicy... requiredHSTSPolicies);
  public Boolean hasRequiredHSTSPolicies();
  public IngressSpecFluent.RequiredHSTSPoliciesNested<A> addNewRequiredHSTSPolicy();
  public IngressSpecFluent.RequiredHSTSPoliciesNested<A> addNewRequiredHSTSPolicyLike(RequiredHSTSPolicy item);
  public IngressSpecFluent.RequiredHSTSPoliciesNested<A> setNewRequiredHSTSPolicyLike(int index,RequiredHSTSPolicy item);
  public IngressSpecFluent.RequiredHSTSPoliciesNested<A> editRequiredHSTSPolicy(int index);
  public IngressSpecFluent.RequiredHSTSPoliciesNested<A> editFirstRequiredHSTSPolicy();
  public IngressSpecFluent.RequiredHSTSPoliciesNested<A> editLastRequiredHSTSPolicy();
  public IngressSpecFluent.RequiredHSTSPoliciesNested<A> editMatchingRequiredHSTSPolicy(Predicate<RequiredHSTSPolicyBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ComponentRoutesNested<N> extends Nested<N>,ComponentRouteSpecFluent<IngressSpecFluent.ComponentRoutesNested<N>>{
    public N and();
    public N endComponentRoute();
    
  }
  public interface RequiredHSTSPoliciesNested<N> extends Nested<N>,RequiredHSTSPolicyFluent<IngressSpecFluent.RequiredHSTSPoliciesNested<N>>{
    public N and();
    public N endRequiredHSTSPolicy();
    
  }
  
}