package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubevirtPlatformSpecBuilder extends KubevirtPlatformSpecFluentImpl<KubevirtPlatformSpecBuilder> implements VisitableBuilder<KubevirtPlatformSpec,KubevirtPlatformSpecBuilder>{
  public KubevirtPlatformSpecBuilder() {
    this(false);
  }
  public KubevirtPlatformSpecBuilder(Boolean validationEnabled) {
    this(new KubevirtPlatformSpec(), validationEnabled);
  }
  public KubevirtPlatformSpecBuilder(KubevirtPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KubevirtPlatformSpecBuilder(KubevirtPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubevirtPlatformSpec(), validationEnabled);
  }
  public KubevirtPlatformSpecBuilder(KubevirtPlatformSpecFluent<?> fluent,KubevirtPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public KubevirtPlatformSpecBuilder(KubevirtPlatformSpecFluent<?> fluent,KubevirtPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubevirtPlatformSpecBuilder(KubevirtPlatformSpec instance) {
    this(instance,false);
  }
  public KubevirtPlatformSpecBuilder(KubevirtPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubevirtPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KubevirtPlatformSpec build() {
    KubevirtPlatformSpec buildable = new KubevirtPlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}