package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface NetworkSpecFluent<A extends NetworkSpecFluent<A>> extends Fluent<A>{
  public A addToClusterNetwork(int index,ClusterNetworkEntry item);
  public A setToClusterNetwork(int index,ClusterNetworkEntry item);
  public A addToClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... items);
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items);
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... items);
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items);
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getClusterNetwork();
  public List<ClusterNetworkEntry> buildClusterNetwork();
  public ClusterNetworkEntry buildClusterNetwork(int index);
  public ClusterNetworkEntry buildFirstClusterNetwork();
  public ClusterNetworkEntry buildLastClusterNetwork();
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork);
  public A withClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... clusterNetwork);
  public Boolean hasClusterNetwork();
  public A addNewClusterNetwork(String cidr,Integer hostPrefix);
  public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork();
  public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item);
  public NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item);
  public NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(int index);
  public NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork();
  public NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork();
  public NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildExternalIP instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExternalIPConfig getExternalIP();
  public ExternalIPConfig buildExternalIP();
  public A withExternalIP(ExternalIPConfig externalIP);
  public Boolean hasExternalIP();
  public NetworkSpecFluent.ExternalIPNested<A> withNewExternalIP();
  public NetworkSpecFluent.ExternalIPNested<A> withNewExternalIPLike(ExternalIPConfig item);
  public NetworkSpecFluent.ExternalIPNested<A> editExternalIP();
  public NetworkSpecFluent.ExternalIPNested<A> editOrNewExternalIP();
  public NetworkSpecFluent.ExternalIPNested<A> editOrNewExternalIPLike(ExternalIPConfig item);
  public String getNetworkType();
  public A withNetworkType(String networkType);
  public Boolean hasNetworkType();
  public A addToServiceNetwork(int index,String item);
  public A setToServiceNetwork(int index,String item);
  public A addToServiceNetwork(java.lang.String... items);
  public A addAllToServiceNetwork(Collection<String> items);
  public A removeFromServiceNetwork(java.lang.String... items);
  public A removeAllFromServiceNetwork(Collection<String> items);
  public List<String> getServiceNetwork();
  public String getServiceNetwork(int index);
  public String getFirstServiceNetwork();
  public String getLastServiceNetwork();
  public String getMatchingServiceNetwork(Predicate<String> predicate);
  public Boolean hasMatchingServiceNetwork(Predicate<String> predicate);
  public A withServiceNetwork(List<String> serviceNetwork);
  public A withServiceNetwork(java.lang.String... serviceNetwork);
  public Boolean hasServiceNetwork();
  public String getServiceNodePortRange();
  public A withServiceNodePortRange(String serviceNodePortRange);
  public Boolean hasServiceNodePortRange();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ClusterNetworkNested<N> extends Nested<N>,ClusterNetworkEntryFluent<NetworkSpecFluent.ClusterNetworkNested<N>>{
    public N and();
    public N endClusterNetwork();
    
  }
  public interface ExternalIPNested<N> extends Nested<N>,ExternalIPConfigFluent<NetworkSpecFluent.ExternalIPNested<N>>{
    public N and();
    public N endExternalIP();
    
  }
  
}