package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkSpecFluentImpl<A extends NetworkSpecFluent<A>> extends BaseFluent<A> implements NetworkSpecFluent<A>{
  public NetworkSpecFluentImpl() {
  }
  public NetworkSpecFluentImpl(NetworkSpec instance) {
    if (instance != null) {
      this.withClusterNetwork(instance.getClusterNetwork());
      this.withExternalIP(instance.getExternalIP());
      this.withNetworkType(instance.getNetworkType());
      this.withServiceNetwork(instance.getServiceNetwork());
      this.withServiceNodePortRange(instance.getServiceNodePortRange());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
  private ExternalIPConfigBuilder externalIP;
  private String networkType;
  private List<String> serviceNetwork = new ArrayList<String>();
  private String serviceNodePortRange;
  private Map<String,Object> additionalProperties;
  public A addToClusterNetwork(int index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetwork.size()) { _visitables.get("clusterNetwork").add(builder); clusterNetwork.add(builder); } else { _visitables.get("clusterNetwork").add(index, builder); clusterNetwork.add(index, builder);}
    return (A)this;
  }
  public A setToClusterNetwork(int index,ClusterNetworkEntry item) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
    if (index < 0 || index >= clusterNetwork.size()) { _visitables.get("clusterNetwork").add(builder); clusterNetwork.add(builder); } else { _visitables.get("clusterNetwork").set(index, builder); clusterNetwork.set(index, builder);}
    return (A)this;
  }
  public A addToClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
    if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
  }
  public A removeFromClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
    for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    if (clusterNetwork == null) return (A) this;
    final Iterator<ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
    final List visitables = _visitables.get("clusterNetwork");
    while (each.hasNext()) {
      ClusterNetworkEntryBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterNetwork instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterNetworkEntry> getClusterNetwork() {
    return clusterNetwork != null ? build(clusterNetwork) : null;
  }
  public List<ClusterNetworkEntry> buildClusterNetwork() {
    return clusterNetwork != null ? build(clusterNetwork) : null;
  }
  public ClusterNetworkEntry buildClusterNetwork(int index) {
    return this.clusterNetwork.get(index).build();
  }
  public ClusterNetworkEntry buildFirstClusterNetwork() {
    return this.clusterNetwork.get(0).build();
  }
  public ClusterNetworkEntry buildLastClusterNetwork() {
    return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
  }
  public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    for (ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
    if (this.clusterNetwork != null) { _visitables.get("clusterNetwork").clear();}
    if (clusterNetwork != null) {this.clusterNetwork = new ArrayList(); for (ClusterNetworkEntry item : clusterNetwork){this.addToClusterNetwork(item);}} else { this.clusterNetwork = null;} return (A) this;
  }
  public A withClusterNetwork(io.fabric8.openshift.api.model.config.v1.ClusterNetworkEntry... clusterNetwork) {
    if (this.clusterNetwork != null) {this.clusterNetwork.clear(); _visitables.remove("clusterNetwork"); }
    if (clusterNetwork != null) {for (ClusterNetworkEntry item :clusterNetwork){ this.addToClusterNetwork(item);}} return (A) this;
  }
  public Boolean hasClusterNetwork() {
    return clusterNetwork != null && !clusterNetwork.isEmpty();
  }
  public A addNewClusterNetwork(String cidr,Integer hostPrefix) {
    return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  public NetworkSpecFluentImpl.ClusterNetworkNested<A> addNewClusterNetwork() {
    return new NetworkSpecFluentImpl.ClusterNetworkNestedImpl();
  }
  public NetworkSpecFluentImpl.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
    return new NetworkSpecFluentImpl.ClusterNetworkNestedImpl(-1, item);
  }
  public NetworkSpecFluentImpl.ClusterNetworkNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item) {
    return new NetworkSpecFluentImpl.ClusterNetworkNestedImpl(index, item);
  }
  public NetworkSpecFluentImpl.ClusterNetworkNested<A> editClusterNetwork(int index) {
    if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public NetworkSpecFluentImpl.ClusterNetworkNested<A> editFirstClusterNetwork() {
    if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(0, buildClusterNetwork(0));
  }
  public NetworkSpecFluentImpl.ClusterNetworkNested<A> editLastClusterNetwork() {
    int index = clusterNetwork.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  public NetworkSpecFluentImpl.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterNetwork.size();i++) { 
    if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
    return setNewClusterNetworkLike(index, buildClusterNetwork(index));
  }
  
  /**
   * This method has been deprecated, please use method buildExternalIP instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExternalIPConfig getExternalIP() {
    return this.externalIP!=null ?this.externalIP.build():null;
  }
  public ExternalIPConfig buildExternalIP() {
    return this.externalIP!=null ?this.externalIP.build():null;
  }
  public A withExternalIP(ExternalIPConfig externalIP) {
    _visitables.get("externalIP").remove(this.externalIP);
    if (externalIP!=null){ this.externalIP= new ExternalIPConfigBuilder(externalIP); _visitables.get("externalIP").add(this.externalIP);} else { this.externalIP = null; _visitables.get("externalIP").remove(this.externalIP); } return (A) this;
  }
  public Boolean hasExternalIP() {
    return this.externalIP != null;
  }
  public NetworkSpecFluentImpl.ExternalIPNested<A> withNewExternalIP() {
    return new NetworkSpecFluentImpl.ExternalIPNestedImpl();
  }
  public NetworkSpecFluentImpl.ExternalIPNested<A> withNewExternalIPLike(ExternalIPConfig item) {
    return new NetworkSpecFluentImpl.ExternalIPNestedImpl(item);
  }
  public NetworkSpecFluentImpl.ExternalIPNested<A> editExternalIP() {
    return withNewExternalIPLike(getExternalIP());
  }
  public NetworkSpecFluentImpl.ExternalIPNested<A> editOrNewExternalIP() {
    return withNewExternalIPLike(getExternalIP() != null ? getExternalIP(): new ExternalIPConfigBuilder().build());
  }
  public NetworkSpecFluentImpl.ExternalIPNested<A> editOrNewExternalIPLike(ExternalIPConfig item) {
    return withNewExternalIPLike(getExternalIP() != null ? getExternalIP(): item);
  }
  public String getNetworkType() {
    return this.networkType;
  }
  public A withNetworkType(String networkType) {
    this.networkType=networkType; return (A) this;
  }
  public Boolean hasNetworkType() {
    return this.networkType != null;
  }
  public A addToServiceNetwork(int index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.add(index, item);
    return (A)this;
  }
  public A setToServiceNetwork(int index,String item) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    this.serviceNetwork.set(index, item); return (A)this;
  }
  public A addToServiceNetwork(java.lang.String... items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A addAllToServiceNetwork(Collection<String> items) {
    if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
    for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
  }
  public A removeFromServiceNetwork(java.lang.String... items) {
    for (String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public A removeAllFromServiceNetwork(Collection<String> items) {
    for (String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
  }
  public List<String> getServiceNetwork() {
    return this.serviceNetwork;
  }
  public String getServiceNetwork(int index) {
    return this.serviceNetwork.get(index);
  }
  public String getFirstServiceNetwork() {
    return this.serviceNetwork.get(0);
  }
  public String getLastServiceNetwork() {
    return this.serviceNetwork.get(serviceNetwork.size() - 1);
  }
  public String getMatchingServiceNetwork(Predicate<String> predicate) {
    for (String item: serviceNetwork) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
    for (String item: serviceNetwork) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceNetwork(List<String> serviceNetwork) {
    if (serviceNetwork != null) {this.serviceNetwork = new ArrayList(); for (String item : serviceNetwork){this.addToServiceNetwork(item);}} else { this.serviceNetwork = null;} return (A) this;
  }
  public A withServiceNetwork(java.lang.String... serviceNetwork) {
    if (this.serviceNetwork != null) {this.serviceNetwork.clear(); _visitables.remove("serviceNetwork"); }
    if (serviceNetwork != null) {for (String item :serviceNetwork){ this.addToServiceNetwork(item);}} return (A) this;
  }
  public Boolean hasServiceNetwork() {
    return serviceNetwork != null && !serviceNetwork.isEmpty();
  }
  public String getServiceNodePortRange() {
    return this.serviceNodePortRange;
  }
  public A withServiceNodePortRange(String serviceNodePortRange) {
    this.serviceNodePortRange=serviceNodePortRange; return (A) this;
  }
  public Boolean hasServiceNodePortRange() {
    return this.serviceNodePortRange != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkSpecFluentImpl that = (NetworkSpecFluentImpl) o;
    if (!java.util.Objects.equals(clusterNetwork, that.clusterNetwork)) return false;

    if (!java.util.Objects.equals(externalIP, that.externalIP)) return false;

    if (!java.util.Objects.equals(networkType, that.networkType)) return false;

    if (!java.util.Objects.equals(serviceNetwork, that.serviceNetwork)) return false;

    if (!java.util.Objects.equals(serviceNodePortRange, that.serviceNodePortRange)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterNetwork,  externalIP,  networkType,  serviceNetwork,  serviceNodePortRange,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterNetwork != null) { sb.append("clusterNetwork:"); sb.append(clusterNetwork + ","); }
    if (externalIP != null) { sb.append("externalIP:"); sb.append(externalIP + ","); }
    if (networkType != null) { sb.append("networkType:"); sb.append(networkType + ","); }
    if (serviceNetwork != null && !serviceNetwork.isEmpty()) { sb.append("serviceNetwork:"); sb.append(serviceNetwork + ","); }
    if (serviceNodePortRange != null) { sb.append("serviceNodePortRange:"); sb.append(serviceNodePortRange + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterNetworkNestedImpl<N> extends ClusterNetworkEntryFluentImpl<NetworkSpecFluentImpl.ClusterNetworkNested<N>> implements NetworkSpecFluentImpl.ClusterNetworkNested<N>,Nested<N>{
    ClusterNetworkNestedImpl(int index,ClusterNetworkEntry item) {
      this.index = index;
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkNestedImpl() {
      this.index = -1;
      this.builder = new ClusterNetworkEntryBuilder(this);
    }
    ClusterNetworkEntryBuilder builder;
    int index;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.setToClusterNetwork(index,builder.build());
    }
    public N endClusterNetwork() {
      return and();
    }
    
  }
  class ExternalIPNestedImpl<N> extends ExternalIPConfigFluentImpl<NetworkSpecFluentImpl.ExternalIPNested<N>> implements NetworkSpecFluentImpl.ExternalIPNested<N>,Nested<N>{
    ExternalIPNestedImpl(ExternalIPConfig item) {
      this.builder = new ExternalIPConfigBuilder(this, item);
    }
    ExternalIPNestedImpl() {
      this.builder = new ExternalIPConfigBuilder(this);
    }
    ExternalIPConfigBuilder builder;
    public N and() {
      return (N) NetworkSpecFluentImpl.this.withExternalIP(builder.build());
    }
    public N endExternalIP() {
      return and();
    }
    
  }
  
}