package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenIDIdentityProviderBuilder extends OpenIDIdentityProviderFluentImpl<OpenIDIdentityProviderBuilder> implements VisitableBuilder<OpenIDIdentityProvider,OpenIDIdentityProviderBuilder>{
  public OpenIDIdentityProviderBuilder() {
    this(false);
  }
  public OpenIDIdentityProviderBuilder(Boolean validationEnabled) {
    this(new OpenIDIdentityProvider(), validationEnabled);
  }
  public OpenIDIdentityProviderBuilder(OpenIDIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenIDIdentityProviderBuilder(OpenIDIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenIDIdentityProvider(), validationEnabled);
  }
  public OpenIDIdentityProviderBuilder(OpenIDIdentityProviderFluent<?> fluent,OpenIDIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public OpenIDIdentityProviderBuilder(OpenIDIdentityProviderFluent<?> fluent,OpenIDIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCa(instance.getCa());
      fluent.withClaims(instance.getClaims());
      fluent.withClientID(instance.getClientID());
      fluent.withClientSecret(instance.getClientSecret());
      fluent.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters());
      fluent.withExtraScopes(instance.getExtraScopes());
      fluent.withIssuer(instance.getIssuer());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenIDIdentityProviderBuilder(OpenIDIdentityProvider instance) {
    this(instance,false);
  }
  public OpenIDIdentityProviderBuilder(OpenIDIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCa(instance.getCa());
      this.withClaims(instance.getClaims());
      this.withClientID(instance.getClientID());
      this.withClientSecret(instance.getClientSecret());
      this.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters());
      this.withExtraScopes(instance.getExtraScopes());
      this.withIssuer(instance.getIssuer());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenIDIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public OpenIDIdentityProvider build() {
    OpenIDIdentityProvider buildable = new OpenIDIdentityProvider(fluent.getCa(),fluent.getClaims(),fluent.getClientID(),fluent.getClientSecret(),fluent.getExtraAuthorizeParameters(),fluent.getExtraScopes(),fluent.getIssuer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}