package io.fabric8.openshift.api.model.config.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface OpenIDIdentityProviderFluent<A extends OpenIDIdentityProviderFluent<A>> extends Fluent<A>{
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getCa();
  public ConfigMapNameReference buildCa();
  public A withCa(ConfigMapNameReference ca);
  public Boolean hasCa();
  public A withNewCa(String name);
  public OpenIDIdentityProviderFluent.CaNested<A> withNewCa();
  public OpenIDIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item);
  public OpenIDIdentityProviderFluent.CaNested<A> editCa();
  public OpenIDIdentityProviderFluent.CaNested<A> editOrNewCa();
  public OpenIDIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item);
  
  /**
   * This method has been deprecated, please use method buildClaims instead.
   * @return The buildable object.
   */
  @Deprecated
  public OpenIDClaims getClaims();
  public OpenIDClaims buildClaims();
  public A withClaims(OpenIDClaims claims);
  public Boolean hasClaims();
  public OpenIDIdentityProviderFluent.ClaimsNested<A> withNewClaims();
  public OpenIDIdentityProviderFluent.ClaimsNested<A> withNewClaimsLike(OpenIDClaims item);
  public OpenIDIdentityProviderFluent.ClaimsNested<A> editClaims();
  public OpenIDIdentityProviderFluent.ClaimsNested<A> editOrNewClaims();
  public OpenIDIdentityProviderFluent.ClaimsNested<A> editOrNewClaimsLike(OpenIDClaims item);
  public String getClientID();
  public A withClientID(String clientID);
  public Boolean hasClientID();
  
  /**
   * This method has been deprecated, please use method buildClientSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretNameReference getClientSecret();
  public SecretNameReference buildClientSecret();
  public A withClientSecret(SecretNameReference clientSecret);
  public Boolean hasClientSecret();
  public A withNewClientSecret(String name);
  public OpenIDIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret();
  public OpenIDIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item);
  public OpenIDIdentityProviderFluent.ClientSecretNested<A> editClientSecret();
  public OpenIDIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret();
  public OpenIDIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item);
  public A addToExtraAuthorizeParameters(String key,String value);
  public A addToExtraAuthorizeParameters(Map<String,String> map);
  public A removeFromExtraAuthorizeParameters(String key);
  public A removeFromExtraAuthorizeParameters(Map<String,String> map);
  public Map<String,String> getExtraAuthorizeParameters();
  public <K,V>A withExtraAuthorizeParameters(Map<String,String> extraAuthorizeParameters);
  public Boolean hasExtraAuthorizeParameters();
  public A addToExtraScopes(int index,String item);
  public A setToExtraScopes(int index,String item);
  public A addToExtraScopes(java.lang.String... items);
  public A addAllToExtraScopes(Collection<String> items);
  public A removeFromExtraScopes(java.lang.String... items);
  public A removeAllFromExtraScopes(Collection<String> items);
  public List<String> getExtraScopes();
  public String getExtraScope(int index);
  public String getFirstExtraScope();
  public String getLastExtraScope();
  public String getMatchingExtraScope(Predicate<String> predicate);
  public Boolean hasMatchingExtraScope(Predicate<String> predicate);
  public A withExtraScopes(List<String> extraScopes);
  public A withExtraScopes(java.lang.String... extraScopes);
  public Boolean hasExtraScopes();
  public String getIssuer();
  public A withIssuer(String issuer);
  public Boolean hasIssuer();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface CaNested<N> extends Nested<N>,ConfigMapNameReferenceFluent<OpenIDIdentityProviderFluent.CaNested<N>>{
    public N and();
    public N endCa();
    
  }
  public interface ClaimsNested<N> extends Nested<N>,OpenIDClaimsFluent<OpenIDIdentityProviderFluent.ClaimsNested<N>>{
    public N and();
    public N endClaims();
    
  }
  public interface ClientSecretNested<N> extends Nested<N>,SecretNameReferenceFluent<OpenIDIdentityProviderFluent.ClientSecretNested<N>>{
    public N and();
    public N endClientSecret();
    
  }
  
}