package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OperatorHubSpecFluentImpl<A extends OperatorHubSpecFluent<A>> extends BaseFluent<A> implements OperatorHubSpecFluent<A>{
  public OperatorHubSpecFluentImpl() {
  }
  public OperatorHubSpecFluentImpl(OperatorHubSpec instance) {
    if (instance != null) {
      this.withDisableAllDefaultSources(instance.getDisableAllDefaultSources());
      this.withSources(instance.getSources());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Boolean disableAllDefaultSources;
  private ArrayList<HubSourceBuilder> sources = new ArrayList<HubSourceBuilder>();
  private Map<String,Object> additionalProperties;
  public Boolean getDisableAllDefaultSources() {
    return this.disableAllDefaultSources;
  }
  public A withDisableAllDefaultSources(Boolean disableAllDefaultSources) {
    this.disableAllDefaultSources=disableAllDefaultSources; return (A) this;
  }
  public Boolean hasDisableAllDefaultSources() {
    return this.disableAllDefaultSources != null;
  }
  public A addToSources(int index,HubSource item) {
    if (this.sources == null) {this.sources = new ArrayList<HubSourceBuilder>();}
    HubSourceBuilder builder = new HubSourceBuilder(item);
    if (index < 0 || index >= sources.size()) { _visitables.get("sources").add(builder); sources.add(builder); } else { _visitables.get("sources").add(index, builder); sources.add(index, builder);}
    return (A)this;
  }
  public A setToSources(int index,HubSource item) {
    if (this.sources == null) {this.sources = new ArrayList<HubSourceBuilder>();}
    HubSourceBuilder builder = new HubSourceBuilder(item);
    if (index < 0 || index >= sources.size()) { _visitables.get("sources").add(builder); sources.add(builder); } else { _visitables.get("sources").set(index, builder); sources.set(index, builder);}
    return (A)this;
  }
  public A addToSources(io.fabric8.openshift.api.model.config.v1.HubSource... items) {
    if (this.sources == null) {this.sources = new ArrayList<HubSourceBuilder>();}
    for (HubSource item : items) {HubSourceBuilder builder = new HubSourceBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A addAllToSources(Collection<HubSource> items) {
    if (this.sources == null) {this.sources = new ArrayList<HubSourceBuilder>();}
    for (HubSource item : items) {HubSourceBuilder builder = new HubSourceBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
  }
  public A removeFromSources(io.fabric8.openshift.api.model.config.v1.HubSource... items) {
    for (HubSource item : items) {HubSourceBuilder builder = new HubSourceBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeAllFromSources(Collection<HubSource> items) {
    for (HubSource item : items) {HubSourceBuilder builder = new HubSourceBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSources(Predicate<HubSourceBuilder> predicate) {
    if (sources == null) return (A) this;
    final Iterator<HubSourceBuilder> each = sources.iterator();
    final List visitables = _visitables.get("sources");
    while (each.hasNext()) {
      HubSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HubSource> getSources() {
    return sources != null ? build(sources) : null;
  }
  public List<HubSource> buildSources() {
    return sources != null ? build(sources) : null;
  }
  public HubSource buildSource(int index) {
    return this.sources.get(index).build();
  }
  public HubSource buildFirstSource() {
    return this.sources.get(0).build();
  }
  public HubSource buildLastSource() {
    return this.sources.get(sources.size() - 1).build();
  }
  public HubSource buildMatchingSource(Predicate<HubSourceBuilder> predicate) {
    for (HubSourceBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSource(Predicate<HubSourceBuilder> predicate) {
    for (HubSourceBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSources(List<HubSource> sources) {
    if (this.sources != null) { _visitables.get("sources").clear();}
    if (sources != null) {this.sources = new ArrayList(); for (HubSource item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
  }
  public A withSources(io.fabric8.openshift.api.model.config.v1.HubSource... sources) {
    if (this.sources != null) {this.sources.clear(); _visitables.remove("sources"); }
    if (sources != null) {for (HubSource item :sources){ this.addToSources(item);}} return (A) this;
  }
  public Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public A addNewSource(Boolean disabled,String name) {
    return (A)addToSources(new HubSource(disabled, name));
  }
  public OperatorHubSpecFluentImpl.SourcesNested<A> addNewSource() {
    return new OperatorHubSpecFluentImpl.SourcesNestedImpl();
  }
  public OperatorHubSpecFluentImpl.SourcesNested<A> addNewSourceLike(HubSource item) {
    return new OperatorHubSpecFluentImpl.SourcesNestedImpl(-1, item);
  }
  public OperatorHubSpecFluentImpl.SourcesNested<A> setNewSourceLike(int index,HubSource item) {
    return new OperatorHubSpecFluentImpl.SourcesNestedImpl(index, item);
  }
  public OperatorHubSpecFluentImpl.SourcesNested<A> editSource(int index) {
    if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
    return setNewSourceLike(index, buildSource(index));
  }
  public OperatorHubSpecFluentImpl.SourcesNested<A> editFirstSource() {
    if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
    return setNewSourceLike(0, buildSource(0));
  }
  public OperatorHubSpecFluentImpl.SourcesNested<A> editLastSource() {
    int index = sources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
    return setNewSourceLike(index, buildSource(index));
  }
  public OperatorHubSpecFluentImpl.SourcesNested<A> editMatchingSource(Predicate<HubSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sources.size();i++) { 
    if (predicate.test(sources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
    return setNewSourceLike(index, buildSource(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OperatorHubSpecFluentImpl that = (OperatorHubSpecFluentImpl) o;
    if (!java.util.Objects.equals(disableAllDefaultSources, that.disableAllDefaultSources)) return false;

    if (!java.util.Objects.equals(sources, that.sources)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(disableAllDefaultSources,  sources,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (disableAllDefaultSources != null) { sb.append("disableAllDefaultSources:"); sb.append(disableAllDefaultSources + ","); }
    if (sources != null) { sb.append("sources:"); sb.append(sources + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withDisableAllDefaultSources() {
    return withDisableAllDefaultSources(true);
  }
  class SourcesNestedImpl<N> extends HubSourceFluentImpl<OperatorHubSpecFluentImpl.SourcesNested<N>> implements OperatorHubSpecFluentImpl.SourcesNested<N>,Nested<N>{
    SourcesNestedImpl(int index,HubSource item) {
      this.index = index;
      this.builder = new HubSourceBuilder(this, item);
    }
    SourcesNestedImpl() {
      this.index = -1;
      this.builder = new HubSourceBuilder(this);
    }
    HubSourceBuilder builder;
    int index;
    public N and() {
      return (N) OperatorHubSpecFluentImpl.this.setToSources(index,builder.build());
    }
    public N endSource() {
      return and();
    }
    
  }
  
}