package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OvirtPlatformStatusBuilder extends OvirtPlatformStatusFluentImpl<OvirtPlatformStatusBuilder> implements VisitableBuilder<OvirtPlatformStatus,OvirtPlatformStatusBuilder>{
  public OvirtPlatformStatusBuilder() {
    this(false);
  }
  public OvirtPlatformStatusBuilder(Boolean validationEnabled) {
    this(new OvirtPlatformStatus(), validationEnabled);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OvirtPlatformStatus(), validationEnabled);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent,OvirtPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatusFluent<?> fluent,OvirtPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiServerInternalIP(instance.getApiServerInternalIP());
      fluent.withIngressIP(instance.getIngressIP());
      fluent.withNodeDNSIP(instance.getNodeDNSIP());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatus instance) {
    this(instance,false);
  }
  public OvirtPlatformStatusBuilder(OvirtPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiServerInternalIP(instance.getApiServerInternalIP());
      this.withIngressIP(instance.getIngressIP());
      this.withNodeDNSIP(instance.getNodeDNSIP());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OvirtPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OvirtPlatformStatus build() {
    OvirtPlatformStatus buildable = new OvirtPlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP(),fluent.getNodeDNSIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}