package io.fabric8.openshift.api.model.config.v1;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformStatusFluentImpl<A extends PlatformStatusFluent<A>> extends BaseFluent<A> implements PlatformStatusFluent<A>{
  public PlatformStatusFluentImpl() {
  }
  public PlatformStatusFluentImpl(PlatformStatus instance) {
    if (instance != null) {
      this.withAlibabaCloud(instance.getAlibabaCloud());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withBaremetal(instance.getBaremetal());
      this.withEquinixMetal(instance.getEquinixMetal());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withKubevirt(instance.getKubevirt());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withPowervs(instance.getPowervs());
      this.withType(instance.getType());
      this.withVsphere(instance.getVsphere());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private AlibabaCloudPlatformStatusBuilder alibabaCloud;
  private AWSPlatformStatusBuilder aws;
  private AzurePlatformStatusBuilder azure;
  private BareMetalPlatformStatusBuilder baremetal;
  private EquinixMetalPlatformStatusBuilder equinixMetal;
  private GCPPlatformStatusBuilder gcp;
  private IBMCloudPlatformStatusBuilder ibmcloud;
  private KubevirtPlatformStatusBuilder kubevirt;
  private OpenStackPlatformStatusBuilder openstack;
  private OvirtPlatformStatusBuilder ovirt;
  private PowerVSPlatformStatusBuilder powervs;
  private String type;
  private VSpherePlatformStatusBuilder vsphere;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAlibabaCloud instead.
   * @return The buildable object.
   */
  @Deprecated
  public AlibabaCloudPlatformStatus getAlibabaCloud() {
    return this.alibabaCloud!=null ?this.alibabaCloud.build():null;
  }
  public AlibabaCloudPlatformStatus buildAlibabaCloud() {
    return this.alibabaCloud!=null ?this.alibabaCloud.build():null;
  }
  public A withAlibabaCloud(AlibabaCloudPlatformStatus alibabaCloud) {
    _visitables.get("alibabaCloud").remove(this.alibabaCloud);
    if (alibabaCloud!=null){ this.alibabaCloud= new AlibabaCloudPlatformStatusBuilder(alibabaCloud); _visitables.get("alibabaCloud").add(this.alibabaCloud);} else { this.alibabaCloud = null; _visitables.get("alibabaCloud").remove(this.alibabaCloud); } return (A) this;
  }
  public Boolean hasAlibabaCloud() {
    return this.alibabaCloud != null;
  }
  public PlatformStatusFluentImpl.AlibabaCloudNested<A> withNewAlibabaCloud() {
    return new PlatformStatusFluentImpl.AlibabaCloudNestedImpl();
  }
  public PlatformStatusFluentImpl.AlibabaCloudNested<A> withNewAlibabaCloudLike(AlibabaCloudPlatformStatus item) {
    return new PlatformStatusFluentImpl.AlibabaCloudNestedImpl(item);
  }
  public PlatformStatusFluentImpl.AlibabaCloudNested<A> editAlibabaCloud() {
    return withNewAlibabaCloudLike(getAlibabaCloud());
  }
  public PlatformStatusFluentImpl.AlibabaCloudNested<A> editOrNewAlibabaCloud() {
    return withNewAlibabaCloudLike(getAlibabaCloud() != null ? getAlibabaCloud(): new AlibabaCloudPlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.AlibabaCloudNested<A> editOrNewAlibabaCloudLike(AlibabaCloudPlatformStatus item) {
    return withNewAlibabaCloudLike(getAlibabaCloud() != null ? getAlibabaCloud(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAws instead.
   * @return The buildable object.
   */
  @Deprecated
  public AWSPlatformStatus getAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public AWSPlatformStatus buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public A withAws(AWSPlatformStatus aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new AWSPlatformStatusBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  public Boolean hasAws() {
    return this.aws != null;
  }
  public PlatformStatusFluentImpl.AwsNested<A> withNewAws() {
    return new PlatformStatusFluentImpl.AwsNestedImpl();
  }
  public PlatformStatusFluentImpl.AwsNested<A> withNewAwsLike(AWSPlatformStatus item) {
    return new PlatformStatusFluentImpl.AwsNestedImpl(item);
  }
  public PlatformStatusFluentImpl.AwsNested<A> editAws() {
    return withNewAwsLike(getAws());
  }
  public PlatformStatusFluentImpl.AwsNested<A> editOrNewAws() {
    return withNewAwsLike(getAws() != null ? getAws(): new AWSPlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.AwsNested<A> editOrNewAwsLike(AWSPlatformStatus item) {
    return withNewAwsLike(getAws() != null ? getAws(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzure instead.
   * @return The buildable object.
   */
  @Deprecated
  public AzurePlatformStatus getAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public AzurePlatformStatus buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public A withAzure(AzurePlatformStatus azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new AzurePlatformStatusBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  public Boolean hasAzure() {
    return this.azure != null;
  }
  public A withNewAzure(String armEndpoint,String cloudName,String networkResourceGroupName,String resourceGroupName) {
    return (A)withAzure(new AzurePlatformStatus(armEndpoint, cloudName, networkResourceGroupName, resourceGroupName));
  }
  public PlatformStatusFluentImpl.AzureNested<A> withNewAzure() {
    return new PlatformStatusFluentImpl.AzureNestedImpl();
  }
  public PlatformStatusFluentImpl.AzureNested<A> withNewAzureLike(AzurePlatformStatus item) {
    return new PlatformStatusFluentImpl.AzureNestedImpl(item);
  }
  public PlatformStatusFluentImpl.AzureNested<A> editAzure() {
    return withNewAzureLike(getAzure());
  }
  public PlatformStatusFluentImpl.AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(getAzure() != null ? getAzure(): new AzurePlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.AzureNested<A> editOrNewAzureLike(AzurePlatformStatus item) {
    return withNewAzureLike(getAzure() != null ? getAzure(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBaremetal instead.
   * @return The buildable object.
   */
  @Deprecated
  public BareMetalPlatformStatus getBaremetal() {
    return this.baremetal!=null ?this.baremetal.build():null;
  }
  public BareMetalPlatformStatus buildBaremetal() {
    return this.baremetal!=null ?this.baremetal.build():null;
  }
  public A withBaremetal(BareMetalPlatformStatus baremetal) {
    _visitables.get("baremetal").remove(this.baremetal);
    if (baremetal!=null){ this.baremetal= new BareMetalPlatformStatusBuilder(baremetal); _visitables.get("baremetal").add(this.baremetal);} else { this.baremetal = null; _visitables.get("baremetal").remove(this.baremetal); } return (A) this;
  }
  public Boolean hasBaremetal() {
    return this.baremetal != null;
  }
  public A withNewBaremetal(String apiServerInternalIP,String ingressIP,String nodeDNSIP) {
    return (A)withBaremetal(new BareMetalPlatformStatus(apiServerInternalIP, ingressIP, nodeDNSIP));
  }
  public PlatformStatusFluentImpl.BaremetalNested<A> withNewBaremetal() {
    return new PlatformStatusFluentImpl.BaremetalNestedImpl();
  }
  public PlatformStatusFluentImpl.BaremetalNested<A> withNewBaremetalLike(BareMetalPlatformStatus item) {
    return new PlatformStatusFluentImpl.BaremetalNestedImpl(item);
  }
  public PlatformStatusFluentImpl.BaremetalNested<A> editBaremetal() {
    return withNewBaremetalLike(getBaremetal());
  }
  public PlatformStatusFluentImpl.BaremetalNested<A> editOrNewBaremetal() {
    return withNewBaremetalLike(getBaremetal() != null ? getBaremetal(): new BareMetalPlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.BaremetalNested<A> editOrNewBaremetalLike(BareMetalPlatformStatus item) {
    return withNewBaremetalLike(getBaremetal() != null ? getBaremetal(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildEquinixMetal instead.
   * @return The buildable object.
   */
  @Deprecated
  public EquinixMetalPlatformStatus getEquinixMetal() {
    return this.equinixMetal!=null ?this.equinixMetal.build():null;
  }
  public EquinixMetalPlatformStatus buildEquinixMetal() {
    return this.equinixMetal!=null ?this.equinixMetal.build():null;
  }
  public A withEquinixMetal(EquinixMetalPlatformStatus equinixMetal) {
    _visitables.get("equinixMetal").remove(this.equinixMetal);
    if (equinixMetal!=null){ this.equinixMetal= new EquinixMetalPlatformStatusBuilder(equinixMetal); _visitables.get("equinixMetal").add(this.equinixMetal);} else { this.equinixMetal = null; _visitables.get("equinixMetal").remove(this.equinixMetal); } return (A) this;
  }
  public Boolean hasEquinixMetal() {
    return this.equinixMetal != null;
  }
  public A withNewEquinixMetal(String apiServerInternalIP,String ingressIP) {
    return (A)withEquinixMetal(new EquinixMetalPlatformStatus(apiServerInternalIP, ingressIP));
  }
  public PlatformStatusFluentImpl.EquinixMetalNested<A> withNewEquinixMetal() {
    return new PlatformStatusFluentImpl.EquinixMetalNestedImpl();
  }
  public PlatformStatusFluentImpl.EquinixMetalNested<A> withNewEquinixMetalLike(EquinixMetalPlatformStatus item) {
    return new PlatformStatusFluentImpl.EquinixMetalNestedImpl(item);
  }
  public PlatformStatusFluentImpl.EquinixMetalNested<A> editEquinixMetal() {
    return withNewEquinixMetalLike(getEquinixMetal());
  }
  public PlatformStatusFluentImpl.EquinixMetalNested<A> editOrNewEquinixMetal() {
    return withNewEquinixMetalLike(getEquinixMetal() != null ? getEquinixMetal(): new EquinixMetalPlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.EquinixMetalNested<A> editOrNewEquinixMetalLike(EquinixMetalPlatformStatus item) {
    return withNewEquinixMetalLike(getEquinixMetal() != null ? getEquinixMetal(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGcp instead.
   * @return The buildable object.
   */
  @Deprecated
  public GCPPlatformStatus getGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public GCPPlatformStatus buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public A withGcp(GCPPlatformStatus gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new GCPPlatformStatusBuilder(gcp); _visitables.get("gcp").add(this.gcp);} else { this.gcp = null; _visitables.get("gcp").remove(this.gcp); } return (A) this;
  }
  public Boolean hasGcp() {
    return this.gcp != null;
  }
  public A withNewGcp(String projectID,String region) {
    return (A)withGcp(new GCPPlatformStatus(projectID, region));
  }
  public PlatformStatusFluentImpl.GcpNested<A> withNewGcp() {
    return new PlatformStatusFluentImpl.GcpNestedImpl();
  }
  public PlatformStatusFluentImpl.GcpNested<A> withNewGcpLike(GCPPlatformStatus item) {
    return new PlatformStatusFluentImpl.GcpNestedImpl(item);
  }
  public PlatformStatusFluentImpl.GcpNested<A> editGcp() {
    return withNewGcpLike(getGcp());
  }
  public PlatformStatusFluentImpl.GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(getGcp() != null ? getGcp(): new GCPPlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.GcpNested<A> editOrNewGcpLike(GCPPlatformStatus item) {
    return withNewGcpLike(getGcp() != null ? getGcp(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIbmcloud instead.
   * @return The buildable object.
   */
  @Deprecated
  public IBMCloudPlatformStatus getIbmcloud() {
    return this.ibmcloud!=null ?this.ibmcloud.build():null;
  }
  public IBMCloudPlatformStatus buildIbmcloud() {
    return this.ibmcloud!=null ?this.ibmcloud.build():null;
  }
  public A withIbmcloud(IBMCloudPlatformStatus ibmcloud) {
    _visitables.get("ibmcloud").remove(this.ibmcloud);
    if (ibmcloud!=null){ this.ibmcloud= new IBMCloudPlatformStatusBuilder(ibmcloud); _visitables.get("ibmcloud").add(this.ibmcloud);} else { this.ibmcloud = null; _visitables.get("ibmcloud").remove(this.ibmcloud); } return (A) this;
  }
  public Boolean hasIbmcloud() {
    return this.ibmcloud != null;
  }
  public A withNewIbmcloud(String cisInstanceCRN,String location,String providerType,String resourceGroupName) {
    return (A)withIbmcloud(new IBMCloudPlatformStatus(cisInstanceCRN, location, providerType, resourceGroupName));
  }
  public PlatformStatusFluentImpl.IbmcloudNested<A> withNewIbmcloud() {
    return new PlatformStatusFluentImpl.IbmcloudNestedImpl();
  }
  public PlatformStatusFluentImpl.IbmcloudNested<A> withNewIbmcloudLike(IBMCloudPlatformStatus item) {
    return new PlatformStatusFluentImpl.IbmcloudNestedImpl(item);
  }
  public PlatformStatusFluentImpl.IbmcloudNested<A> editIbmcloud() {
    return withNewIbmcloudLike(getIbmcloud());
  }
  public PlatformStatusFluentImpl.IbmcloudNested<A> editOrNewIbmcloud() {
    return withNewIbmcloudLike(getIbmcloud() != null ? getIbmcloud(): new IBMCloudPlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.IbmcloudNested<A> editOrNewIbmcloudLike(IBMCloudPlatformStatus item) {
    return withNewIbmcloudLike(getIbmcloud() != null ? getIbmcloud(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKubevirt instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubevirtPlatformStatus getKubevirt() {
    return this.kubevirt!=null ?this.kubevirt.build():null;
  }
  public KubevirtPlatformStatus buildKubevirt() {
    return this.kubevirt!=null ?this.kubevirt.build():null;
  }
  public A withKubevirt(KubevirtPlatformStatus kubevirt) {
    _visitables.get("kubevirt").remove(this.kubevirt);
    if (kubevirt!=null){ this.kubevirt= new KubevirtPlatformStatusBuilder(kubevirt); _visitables.get("kubevirt").add(this.kubevirt);} else { this.kubevirt = null; _visitables.get("kubevirt").remove(this.kubevirt); } return (A) this;
  }
  public Boolean hasKubevirt() {
    return this.kubevirt != null;
  }
  public A withNewKubevirt(String apiServerInternalIP,String ingressIP) {
    return (A)withKubevirt(new KubevirtPlatformStatus(apiServerInternalIP, ingressIP));
  }
  public PlatformStatusFluentImpl.KubevirtNested<A> withNewKubevirt() {
    return new PlatformStatusFluentImpl.KubevirtNestedImpl();
  }
  public PlatformStatusFluentImpl.KubevirtNested<A> withNewKubevirtLike(KubevirtPlatformStatus item) {
    return new PlatformStatusFluentImpl.KubevirtNestedImpl(item);
  }
  public PlatformStatusFluentImpl.KubevirtNested<A> editKubevirt() {
    return withNewKubevirtLike(getKubevirt());
  }
  public PlatformStatusFluentImpl.KubevirtNested<A> editOrNewKubevirt() {
    return withNewKubevirtLike(getKubevirt() != null ? getKubevirt(): new KubevirtPlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.KubevirtNested<A> editOrNewKubevirtLike(KubevirtPlatformStatus item) {
    return withNewKubevirtLike(getKubevirt() != null ? getKubevirt(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOpenstack instead.
   * @return The buildable object.
   */
  @Deprecated
  public OpenStackPlatformStatus getOpenstack() {
    return this.openstack!=null ?this.openstack.build():null;
  }
  public OpenStackPlatformStatus buildOpenstack() {
    return this.openstack!=null ?this.openstack.build():null;
  }
  public A withOpenstack(OpenStackPlatformStatus openstack) {
    _visitables.get("openstack").remove(this.openstack);
    if (openstack!=null){ this.openstack= new OpenStackPlatformStatusBuilder(openstack); _visitables.get("openstack").add(this.openstack);} else { this.openstack = null; _visitables.get("openstack").remove(this.openstack); } return (A) this;
  }
  public Boolean hasOpenstack() {
    return this.openstack != null;
  }
  public A withNewOpenstack(String apiServerInternalIP,String cloudName,String ingressIP,String nodeDNSIP) {
    return (A)withOpenstack(new OpenStackPlatformStatus(apiServerInternalIP, cloudName, ingressIP, nodeDNSIP));
  }
  public PlatformStatusFluentImpl.OpenstackNested<A> withNewOpenstack() {
    return new PlatformStatusFluentImpl.OpenstackNestedImpl();
  }
  public PlatformStatusFluentImpl.OpenstackNested<A> withNewOpenstackLike(OpenStackPlatformStatus item) {
    return new PlatformStatusFluentImpl.OpenstackNestedImpl(item);
  }
  public PlatformStatusFluentImpl.OpenstackNested<A> editOpenstack() {
    return withNewOpenstackLike(getOpenstack());
  }
  public PlatformStatusFluentImpl.OpenstackNested<A> editOrNewOpenstack() {
    return withNewOpenstackLike(getOpenstack() != null ? getOpenstack(): new OpenStackPlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.OpenstackNested<A> editOrNewOpenstackLike(OpenStackPlatformStatus item) {
    return withNewOpenstackLike(getOpenstack() != null ? getOpenstack(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOvirt instead.
   * @return The buildable object.
   */
  @Deprecated
  public OvirtPlatformStatus getOvirt() {
    return this.ovirt!=null ?this.ovirt.build():null;
  }
  public OvirtPlatformStatus buildOvirt() {
    return this.ovirt!=null ?this.ovirt.build():null;
  }
  public A withOvirt(OvirtPlatformStatus ovirt) {
    _visitables.get("ovirt").remove(this.ovirt);
    if (ovirt!=null){ this.ovirt= new OvirtPlatformStatusBuilder(ovirt); _visitables.get("ovirt").add(this.ovirt);} else { this.ovirt = null; _visitables.get("ovirt").remove(this.ovirt); } return (A) this;
  }
  public Boolean hasOvirt() {
    return this.ovirt != null;
  }
  public A withNewOvirt(String apiServerInternalIP,String ingressIP,String nodeDNSIP) {
    return (A)withOvirt(new OvirtPlatformStatus(apiServerInternalIP, ingressIP, nodeDNSIP));
  }
  public PlatformStatusFluentImpl.OvirtNested<A> withNewOvirt() {
    return new PlatformStatusFluentImpl.OvirtNestedImpl();
  }
  public PlatformStatusFluentImpl.OvirtNested<A> withNewOvirtLike(OvirtPlatformStatus item) {
    return new PlatformStatusFluentImpl.OvirtNestedImpl(item);
  }
  public PlatformStatusFluentImpl.OvirtNested<A> editOvirt() {
    return withNewOvirtLike(getOvirt());
  }
  public PlatformStatusFluentImpl.OvirtNested<A> editOrNewOvirt() {
    return withNewOvirtLike(getOvirt() != null ? getOvirt(): new OvirtPlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.OvirtNested<A> editOrNewOvirtLike(OvirtPlatformStatus item) {
    return withNewOvirtLike(getOvirt() != null ? getOvirt(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPowervs instead.
   * @return The buildable object.
   */
  @Deprecated
  public PowerVSPlatformStatus getPowervs() {
    return this.powervs!=null ?this.powervs.build():null;
  }
  public PowerVSPlatformStatus buildPowervs() {
    return this.powervs!=null ?this.powervs.build():null;
  }
  public A withPowervs(PowerVSPlatformStatus powervs) {
    _visitables.get("powervs").remove(this.powervs);
    if (powervs!=null){ this.powervs= new PowerVSPlatformStatusBuilder(powervs); _visitables.get("powervs").add(this.powervs);} else { this.powervs = null; _visitables.get("powervs").remove(this.powervs); } return (A) this;
  }
  public Boolean hasPowervs() {
    return this.powervs != null;
  }
  public PlatformStatusFluentImpl.PowervsNested<A> withNewPowervs() {
    return new PlatformStatusFluentImpl.PowervsNestedImpl();
  }
  public PlatformStatusFluentImpl.PowervsNested<A> withNewPowervsLike(PowerVSPlatformStatus item) {
    return new PlatformStatusFluentImpl.PowervsNestedImpl(item);
  }
  public PlatformStatusFluentImpl.PowervsNested<A> editPowervs() {
    return withNewPowervsLike(getPowervs());
  }
  public PlatformStatusFluentImpl.PowervsNested<A> editOrNewPowervs() {
    return withNewPowervsLike(getPowervs() != null ? getPowervs(): new PowerVSPlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.PowervsNested<A> editOrNewPowervsLike(PowerVSPlatformStatus item) {
    return withNewPowervsLike(getPowervs() != null ? getPowervs(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  
  /**
   * This method has been deprecated, please use method buildVsphere instead.
   * @return The buildable object.
   */
  @Deprecated
  public VSpherePlatformStatus getVsphere() {
    return this.vsphere!=null ?this.vsphere.build():null;
  }
  public VSpherePlatformStatus buildVsphere() {
    return this.vsphere!=null ?this.vsphere.build():null;
  }
  public A withVsphere(VSpherePlatformStatus vsphere) {
    _visitables.get("vsphere").remove(this.vsphere);
    if (vsphere!=null){ this.vsphere= new VSpherePlatformStatusBuilder(vsphere); _visitables.get("vsphere").add(this.vsphere);} else { this.vsphere = null; _visitables.get("vsphere").remove(this.vsphere); } return (A) this;
  }
  public Boolean hasVsphere() {
    return this.vsphere != null;
  }
  public A withNewVsphere(String apiServerInternalIP,String ingressIP,String nodeDNSIP) {
    return (A)withVsphere(new VSpherePlatformStatus(apiServerInternalIP, ingressIP, nodeDNSIP));
  }
  public PlatformStatusFluentImpl.VsphereNested<A> withNewVsphere() {
    return new PlatformStatusFluentImpl.VsphereNestedImpl();
  }
  public PlatformStatusFluentImpl.VsphereNested<A> withNewVsphereLike(VSpherePlatformStatus item) {
    return new PlatformStatusFluentImpl.VsphereNestedImpl(item);
  }
  public PlatformStatusFluentImpl.VsphereNested<A> editVsphere() {
    return withNewVsphereLike(getVsphere());
  }
  public PlatformStatusFluentImpl.VsphereNested<A> editOrNewVsphere() {
    return withNewVsphereLike(getVsphere() != null ? getVsphere(): new VSpherePlatformStatusBuilder().build());
  }
  public PlatformStatusFluentImpl.VsphereNested<A> editOrNewVsphereLike(VSpherePlatformStatus item) {
    return withNewVsphereLike(getVsphere() != null ? getVsphere(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformStatusFluentImpl that = (PlatformStatusFluentImpl) o;
    if (!java.util.Objects.equals(alibabaCloud, that.alibabaCloud)) return false;

    if (!java.util.Objects.equals(aws, that.aws)) return false;

    if (!java.util.Objects.equals(azure, that.azure)) return false;

    if (!java.util.Objects.equals(baremetal, that.baremetal)) return false;

    if (!java.util.Objects.equals(equinixMetal, that.equinixMetal)) return false;

    if (!java.util.Objects.equals(gcp, that.gcp)) return false;

    if (!java.util.Objects.equals(ibmcloud, that.ibmcloud)) return false;

    if (!java.util.Objects.equals(kubevirt, that.kubevirt)) return false;

    if (!java.util.Objects.equals(openstack, that.openstack)) return false;

    if (!java.util.Objects.equals(ovirt, that.ovirt)) return false;

    if (!java.util.Objects.equals(powervs, that.powervs)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(vsphere, that.vsphere)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(alibabaCloud,  aws,  azure,  baremetal,  equinixMetal,  gcp,  ibmcloud,  kubevirt,  openstack,  ovirt,  powervs,  type,  vsphere,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alibabaCloud != null) { sb.append("alibabaCloud:"); sb.append(alibabaCloud + ","); }
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (baremetal != null) { sb.append("baremetal:"); sb.append(baremetal + ","); }
    if (equinixMetal != null) { sb.append("equinixMetal:"); sb.append(equinixMetal + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (ibmcloud != null) { sb.append("ibmcloud:"); sb.append(ibmcloud + ","); }
    if (kubevirt != null) { sb.append("kubevirt:"); sb.append(kubevirt + ","); }
    if (openstack != null) { sb.append("openstack:"); sb.append(openstack + ","); }
    if (ovirt != null) { sb.append("ovirt:"); sb.append(ovirt + ","); }
    if (powervs != null) { sb.append("powervs:"); sb.append(powervs + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (vsphere != null) { sb.append("vsphere:"); sb.append(vsphere + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AlibabaCloudNestedImpl<N> extends AlibabaCloudPlatformStatusFluentImpl<PlatformStatusFluentImpl.AlibabaCloudNested<N>> implements PlatformStatusFluentImpl.AlibabaCloudNested<N>,Nested<N>{
    AlibabaCloudNestedImpl(AlibabaCloudPlatformStatus item) {
      this.builder = new AlibabaCloudPlatformStatusBuilder(this, item);
    }
    AlibabaCloudNestedImpl() {
      this.builder = new AlibabaCloudPlatformStatusBuilder(this);
    }
    AlibabaCloudPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withAlibabaCloud(builder.build());
    }
    public N endAlibabaCloud() {
      return and();
    }
    
  }
  class AwsNestedImpl<N> extends AWSPlatformStatusFluentImpl<PlatformStatusFluentImpl.AwsNested<N>> implements PlatformStatusFluentImpl.AwsNested<N>,Nested<N>{
    AwsNestedImpl(AWSPlatformStatus item) {
      this.builder = new AWSPlatformStatusBuilder(this, item);
    }
    AwsNestedImpl() {
      this.builder = new AWSPlatformStatusBuilder(this);
    }
    AWSPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withAws(builder.build());
    }
    public N endAws() {
      return and();
    }
    
  }
  class AzureNestedImpl<N> extends AzurePlatformStatusFluentImpl<PlatformStatusFluentImpl.AzureNested<N>> implements PlatformStatusFluentImpl.AzureNested<N>,Nested<N>{
    AzureNestedImpl(AzurePlatformStatus item) {
      this.builder = new AzurePlatformStatusBuilder(this, item);
    }
    AzureNestedImpl() {
      this.builder = new AzurePlatformStatusBuilder(this);
    }
    AzurePlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withAzure(builder.build());
    }
    public N endAzure() {
      return and();
    }
    
  }
  class BaremetalNestedImpl<N> extends BareMetalPlatformStatusFluentImpl<PlatformStatusFluentImpl.BaremetalNested<N>> implements PlatformStatusFluentImpl.BaremetalNested<N>,Nested<N>{
    BaremetalNestedImpl(BareMetalPlatformStatus item) {
      this.builder = new BareMetalPlatformStatusBuilder(this, item);
    }
    BaremetalNestedImpl() {
      this.builder = new BareMetalPlatformStatusBuilder(this);
    }
    BareMetalPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withBaremetal(builder.build());
    }
    public N endBaremetal() {
      return and();
    }
    
  }
  class EquinixMetalNestedImpl<N> extends EquinixMetalPlatformStatusFluentImpl<PlatformStatusFluentImpl.EquinixMetalNested<N>> implements PlatformStatusFluentImpl.EquinixMetalNested<N>,Nested<N>{
    EquinixMetalNestedImpl(EquinixMetalPlatformStatus item) {
      this.builder = new EquinixMetalPlatformStatusBuilder(this, item);
    }
    EquinixMetalNestedImpl() {
      this.builder = new EquinixMetalPlatformStatusBuilder(this);
    }
    EquinixMetalPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withEquinixMetal(builder.build());
    }
    public N endEquinixMetal() {
      return and();
    }
    
  }
  class GcpNestedImpl<N> extends GCPPlatformStatusFluentImpl<PlatformStatusFluentImpl.GcpNested<N>> implements PlatformStatusFluentImpl.GcpNested<N>,Nested<N>{
    GcpNestedImpl(GCPPlatformStatus item) {
      this.builder = new GCPPlatformStatusBuilder(this, item);
    }
    GcpNestedImpl() {
      this.builder = new GCPPlatformStatusBuilder(this);
    }
    GCPPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withGcp(builder.build());
    }
    public N endGcp() {
      return and();
    }
    
  }
  class IbmcloudNestedImpl<N> extends IBMCloudPlatformStatusFluentImpl<PlatformStatusFluentImpl.IbmcloudNested<N>> implements PlatformStatusFluentImpl.IbmcloudNested<N>,Nested<N>{
    IbmcloudNestedImpl(IBMCloudPlatformStatus item) {
      this.builder = new IBMCloudPlatformStatusBuilder(this, item);
    }
    IbmcloudNestedImpl() {
      this.builder = new IBMCloudPlatformStatusBuilder(this);
    }
    IBMCloudPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withIbmcloud(builder.build());
    }
    public N endIbmcloud() {
      return and();
    }
    
  }
  class KubevirtNestedImpl<N> extends KubevirtPlatformStatusFluentImpl<PlatformStatusFluentImpl.KubevirtNested<N>> implements PlatformStatusFluentImpl.KubevirtNested<N>,Nested<N>{
    KubevirtNestedImpl(KubevirtPlatformStatus item) {
      this.builder = new KubevirtPlatformStatusBuilder(this, item);
    }
    KubevirtNestedImpl() {
      this.builder = new KubevirtPlatformStatusBuilder(this);
    }
    KubevirtPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withKubevirt(builder.build());
    }
    public N endKubevirt() {
      return and();
    }
    
  }
  class OpenstackNestedImpl<N> extends OpenStackPlatformStatusFluentImpl<PlatformStatusFluentImpl.OpenstackNested<N>> implements PlatformStatusFluentImpl.OpenstackNested<N>,Nested<N>{
    OpenstackNestedImpl(OpenStackPlatformStatus item) {
      this.builder = new OpenStackPlatformStatusBuilder(this, item);
    }
    OpenstackNestedImpl() {
      this.builder = new OpenStackPlatformStatusBuilder(this);
    }
    OpenStackPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withOpenstack(builder.build());
    }
    public N endOpenstack() {
      return and();
    }
    
  }
  class OvirtNestedImpl<N> extends OvirtPlatformStatusFluentImpl<PlatformStatusFluentImpl.OvirtNested<N>> implements PlatformStatusFluentImpl.OvirtNested<N>,Nested<N>{
    OvirtNestedImpl(OvirtPlatformStatus item) {
      this.builder = new OvirtPlatformStatusBuilder(this, item);
    }
    OvirtNestedImpl() {
      this.builder = new OvirtPlatformStatusBuilder(this);
    }
    OvirtPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withOvirt(builder.build());
    }
    public N endOvirt() {
      return and();
    }
    
  }
  class PowervsNestedImpl<N> extends PowerVSPlatformStatusFluentImpl<PlatformStatusFluentImpl.PowervsNested<N>> implements PlatformStatusFluentImpl.PowervsNested<N>,Nested<N>{
    PowervsNestedImpl(PowerVSPlatformStatus item) {
      this.builder = new PowerVSPlatformStatusBuilder(this, item);
    }
    PowervsNestedImpl() {
      this.builder = new PowerVSPlatformStatusBuilder(this);
    }
    PowerVSPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withPowervs(builder.build());
    }
    public N endPowervs() {
      return and();
    }
    
  }
  class VsphereNestedImpl<N> extends VSpherePlatformStatusFluentImpl<PlatformStatusFluentImpl.VsphereNested<N>> implements PlatformStatusFluentImpl.VsphereNested<N>,Nested<N>{
    VsphereNestedImpl(VSpherePlatformStatus item) {
      this.builder = new VSpherePlatformStatusBuilder(this, item);
    }
    VsphereNestedImpl() {
      this.builder = new VSpherePlatformStatusBuilder(this);
    }
    VSpherePlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluentImpl.this.withVsphere(builder.build());
    }
    public N endVsphere() {
      return and();
    }
    
  }
  
}