package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PowerVSPlatformStatusBuilder extends PowerVSPlatformStatusFluentImpl<PowerVSPlatformStatusBuilder> implements VisitableBuilder<PowerVSPlatformStatus,PowerVSPlatformStatusBuilder>{
  public PowerVSPlatformStatusBuilder() {
    this(false);
  }
  public PowerVSPlatformStatusBuilder(Boolean validationEnabled) {
    this(new PowerVSPlatformStatus(), validationEnabled);
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PowerVSPlatformStatus(), validationEnabled);
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatusFluent<?> fluent,PowerVSPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatusFluent<?> fluent,PowerVSPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCisInstanceCRN(instance.getCisInstanceCRN());
      fluent.withRegion(instance.getRegion());
      fluent.withServiceEndpoints(instance.getServiceEndpoints());
      fluent.withZone(instance.getZone());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatus instance) {
    this(instance,false);
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCisInstanceCRN(instance.getCisInstanceCRN());
      this.withRegion(instance.getRegion());
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withZone(instance.getZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PowerVSPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PowerVSPlatformStatus build() {
    PowerVSPlatformStatus buildable = new PowerVSPlatformStatus(fluent.getCisInstanceCRN(),fluent.getRegion(),fluent.getServiceEndpoints(),fluent.getZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}