package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ReleaseFluentImpl<A extends ReleaseFluent<A>> extends BaseFluent<A> implements ReleaseFluent<A>{
  public ReleaseFluentImpl() {
  }
  public ReleaseFluentImpl(Release instance) {
    if (instance != null) {
      this.withChannels(instance.getChannels());
      this.withImage(instance.getImage());
      this.withUrl(instance.getUrl());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> channels = new ArrayList<String>();
  private String image;
  private String url;
  private String version;
  private Map<String,Object> additionalProperties;
  public A addToChannels(int index,String item) {
    if (this.channels == null) {this.channels = new ArrayList<String>();}
    this.channels.add(index, item);
    return (A)this;
  }
  public A setToChannels(int index,String item) {
    if (this.channels == null) {this.channels = new ArrayList<String>();}
    this.channels.set(index, item); return (A)this;
  }
  public A addToChannels(java.lang.String... items) {
    if (this.channels == null) {this.channels = new ArrayList<String>();}
    for (String item : items) {this.channels.add(item);} return (A)this;
  }
  public A addAllToChannels(Collection<String> items) {
    if (this.channels == null) {this.channels = new ArrayList<String>();}
    for (String item : items) {this.channels.add(item);} return (A)this;
  }
  public A removeFromChannels(java.lang.String... items) {
    for (String item : items) {if (this.channels!= null){ this.channels.remove(item);}} return (A)this;
  }
  public A removeAllFromChannels(Collection<String> items) {
    for (String item : items) {if (this.channels!= null){ this.channels.remove(item);}} return (A)this;
  }
  public List<String> getChannels() {
    return this.channels;
  }
  public String getChannel(int index) {
    return this.channels.get(index);
  }
  public String getFirstChannel() {
    return this.channels.get(0);
  }
  public String getLastChannel() {
    return this.channels.get(channels.size() - 1);
  }
  public String getMatchingChannel(Predicate<String> predicate) {
    for (String item: channels) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingChannel(Predicate<String> predicate) {
    for (String item: channels) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withChannels(List<String> channels) {
    if (channels != null) {this.channels = new ArrayList(); for (String item : channels){this.addToChannels(item);}} else { this.channels = null;} return (A) this;
  }
  public A withChannels(java.lang.String... channels) {
    if (this.channels != null) {this.channels.clear(); _visitables.remove("channels"); }
    if (channels != null) {for (String item :channels){ this.addToChannels(item);}} return (A) this;
  }
  public Boolean hasChannels() {
    return channels != null && !channels.isEmpty();
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReleaseFluentImpl that = (ReleaseFluentImpl) o;
    if (!java.util.Objects.equals(channels, that.channels)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(url, that.url)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(channels,  image,  url,  version,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (channels != null && !channels.isEmpty()) { sb.append("channels:"); sb.append(channels + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}